/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat;

import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.Build;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.compat.StreamConfigurationMapCompatApi23Impl;
import androidx.camera.camera2.internal.compat.StreamConfigurationMapCompatBaseImpl;
import androidx.camera.camera2.internal.compat.workaround.OutputSizesCorrector;
import androidx.camera.core.Logger;
import java.util.HashMap;
import java.util.Map;

@RequiresApi(value=21)
public class StreamConfigurationMapCompat {
    private static final String TAG = "StreamConfigurationMapCompat";
    private final StreamConfigurationMapCompatImpl mImpl;
    private final OutputSizesCorrector mOutputSizesCorrector;
    private final Map<Integer, Size[]> mCachedFormatOutputSizes = new HashMap<Integer, Size[]>();
    private final Map<Integer, Size[]> mCachedFormatHighResolutionOutputSizes = new HashMap<Integer, Size[]>();
    private final Map<Class<?>, Size[]> mCachedClassOutputSizes = new HashMap();

    private StreamConfigurationMapCompat(@NonNull StreamConfigurationMap map, @NonNull OutputSizesCorrector outputSizesCorrector) {
        this.mImpl = Build.VERSION.SDK_INT >= 23 ? new StreamConfigurationMapCompatApi23Impl(map) : new StreamConfigurationMapCompatBaseImpl(map);
        this.mOutputSizesCorrector = outputSizesCorrector;
    }

    @NonNull
    static StreamConfigurationMapCompat toStreamConfigurationMapCompat(@NonNull StreamConfigurationMap map, @NonNull OutputSizesCorrector outputSizesCorrector) {
        return new StreamConfigurationMapCompat(map, outputSizesCorrector);
    }

    @Nullable
    public Size[] getOutputSizes(int format) {
        if (this.mCachedFormatOutputSizes.containsKey(format)) {
            Size[] cachedOutputSizes = this.mCachedFormatOutputSizes.get(format);
            return cachedOutputSizes == null ? null : (Size[])this.mCachedFormatOutputSizes.get(format).clone();
        }
        Size[] outputSizes = this.mImpl.getOutputSizes(format);
        if (outputSizes == null || outputSizes.length == 0) {
            Logger.w((String)TAG, (String)("Retrieved output sizes array is null or empty for format " + format));
            return outputSizes;
        }
        outputSizes = this.mOutputSizesCorrector.applyQuirks(outputSizes, format);
        this.mCachedFormatOutputSizes.put(format, outputSizes);
        return (Size[])outputSizes.clone();
    }

    @Nullable
    public <T> Size[] getOutputSizes(@NonNull Class<T> klass) {
        if (this.mCachedClassOutputSizes.containsKey(klass)) {
            Size[] cachedOutputSizes = this.mCachedClassOutputSizes.get(klass);
            return cachedOutputSizes == null ? null : (Size[])this.mCachedClassOutputSizes.get(klass).clone();
        }
        Size[] outputSizes = this.mImpl.getOutputSizes(klass);
        if (outputSizes == null || outputSizes.length == 0) {
            Logger.w((String)TAG, (String)("Retrieved output sizes array is null or empty for class " + klass));
            return outputSizes;
        }
        outputSizes = this.mOutputSizesCorrector.applyQuirks(outputSizes, klass);
        this.mCachedClassOutputSizes.put(klass, outputSizes);
        return (Size[])outputSizes.clone();
    }

    @Nullable
    public Size[] getHighResolutionOutputSizes(int format) {
        if (this.mCachedFormatHighResolutionOutputSizes.containsKey(format)) {
            Size[] cachedOutputSizes = this.mCachedFormatHighResolutionOutputSizes.get(format);
            return cachedOutputSizes == null ? null : (Size[])this.mCachedFormatHighResolutionOutputSizes.get(format).clone();
        }
        Size[] outputSizes = this.mImpl.getHighResolutionOutputSizes(format);
        if (outputSizes != null && outputSizes.length > 0) {
            outputSizes = this.mOutputSizesCorrector.applyQuirks(outputSizes, format);
        }
        this.mCachedFormatHighResolutionOutputSizes.put(format, outputSizes);
        return outputSizes != null ? (Size[])outputSizes.clone() : null;
    }

    @NonNull
    public StreamConfigurationMap toStreamConfigurationMap() {
        return this.mImpl.unwrap();
    }

    static interface StreamConfigurationMapCompatImpl {
        @Nullable
        public Size[] getOutputSizes(int var1);

        @Nullable
        public <T> Size[] getOutputSizes(@NonNull Class<T> var1);

        @Nullable
        public Size[] getHighResolutionOutputSizes(int var1);

        @NonNull
        public StreamConfigurationMap unwrap();
    }
}

