/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat;

import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.os.Build;
import android.os.Handler;
import android.util.ArrayMap;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RequiresPermission;
import androidx.annotation.VisibleForTesting;
import androidx.camera.camera2.internal.compat.ApiCompat;
import androidx.camera.camera2.internal.compat.CameraAccessExceptionCompat;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.camera2.internal.compat.CameraManagerCompatApi28Impl;
import androidx.camera.camera2.internal.compat.CameraManagerCompatApi29Impl;
import androidx.camera.camera2.internal.compat.CameraManagerCompatApi30Impl;
import androidx.camera.camera2.internal.compat.CameraManagerCompatBaseImpl;
import androidx.camera.core.impl.utils.MainThreadAsyncHandler;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;

@RequiresApi(value=21)
public final class CameraManagerCompat {
    private final CameraManagerCompatImpl mImpl;
    @GuardedBy(value="mCameraCharacteristicsMap")
    private final Map<String, CameraCharacteristicsCompat> mCameraCharacteristicsMap = new ArrayMap(4);

    private CameraManagerCompat(CameraManagerCompatImpl impl) {
        this.mImpl = impl;
    }

    @NonNull
    public static CameraManagerCompat from(@NonNull Context context) {
        return CameraManagerCompat.from(context, MainThreadAsyncHandler.getInstance());
    }

    @NonNull
    public static CameraManagerCompat from(@NonNull Context context, @NonNull Handler compatHandler) {
        return new CameraManagerCompat(CameraManagerCompatImpl.from(context, compatHandler));
    }

    @VisibleForTesting
    @NonNull
    public static CameraManagerCompat from(@NonNull CameraManagerCompatImpl impl) {
        return new CameraManagerCompat(impl);
    }

    @NonNull
    public String[] getCameraIdList() throws CameraAccessExceptionCompat {
        return this.mImpl.getCameraIdList();
    }

    @NonNull
    public Set<Set<String>> getConcurrentCameraIds() throws CameraAccessExceptionCompat {
        return this.mImpl.getConcurrentCameraIds();
    }

    public void registerAvailabilityCallback(@NonNull Executor executor, @NonNull CameraManager.AvailabilityCallback callback) {
        this.mImpl.registerAvailabilityCallback(executor, callback);
    }

    public void unregisterAvailabilityCallback(@NonNull CameraManager.AvailabilityCallback callback) {
        this.mImpl.unregisterAvailabilityCallback(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public CameraCharacteristicsCompat getCameraCharacteristicsCompat(@NonNull String cameraId) throws CameraAccessExceptionCompat {
        CameraCharacteristicsCompat characteristics;
        Map<String, CameraCharacteristicsCompat> map = this.mCameraCharacteristicsMap;
        synchronized (map) {
            characteristics = this.mCameraCharacteristicsMap.get(cameraId);
            if (characteristics == null) {
                try {
                    characteristics = CameraCharacteristicsCompat.toCameraCharacteristicsCompat(this.mImpl.getCameraCharacteristics(cameraId), cameraId);
                    this.mCameraCharacteristicsMap.put(cameraId, characteristics);
                }
                catch (AssertionError e) {
                    throw new CameraAccessExceptionCompat(10002, ((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
                }
            }
        }
        return characteristics;
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public void openCamera(@NonNull String cameraId, @NonNull Executor executor, @NonNull CameraDevice.StateCallback callback) throws CameraAccessExceptionCompat {
        this.mImpl.openCamera(cameraId, executor, callback);
    }

    @NonNull
    public CameraManager unwrap() {
        return this.mImpl.getCameraManager();
    }

    public static interface CameraManagerCompatImpl {
        @NonNull
        public String[] getCameraIdList() throws CameraAccessExceptionCompat;

        @NonNull
        public Set<Set<String>> getConcurrentCameraIds() throws CameraAccessExceptionCompat;

        public void registerAvailabilityCallback(@NonNull Executor var1, @NonNull CameraManager.AvailabilityCallback var2);

        public void unregisterAvailabilityCallback(@NonNull CameraManager.AvailabilityCallback var1);

        @NonNull
        public CameraCharacteristics getCameraCharacteristics(@NonNull String var1) throws CameraAccessExceptionCompat;

        @RequiresPermission(value="android.permission.CAMERA")
        public void openCamera(@NonNull String var1, @NonNull Executor var2, @NonNull CameraDevice.StateCallback var3) throws CameraAccessExceptionCompat;

        @NonNull
        public CameraManager getCameraManager();

        @NonNull
        public static CameraManagerCompatImpl from(@NonNull Context context, @NonNull Handler compatHandler) {
            if (Build.VERSION.SDK_INT >= 30) {
                return new CameraManagerCompatApi30Impl(context);
            }
            if (Build.VERSION.SDK_INT >= 29) {
                return new CameraManagerCompatApi29Impl(context);
            }
            if (Build.VERSION.SDK_INT >= 28) {
                return CameraManagerCompatApi28Impl.create(context);
            }
            return CameraManagerCompatBaseImpl.create(context, compatHandler);
        }
    }

    @RequiresApi(value=21)
    static final class AvailabilityCallbackExecutorWrapper
    extends CameraManager.AvailabilityCallback {
        private final Executor mExecutor;
        final CameraManager.AvailabilityCallback mWrappedCallback;
        private final Object mLock = new Object();
        @GuardedBy(value="mLock")
        private boolean mDisabled = false;

        AvailabilityCallbackExecutorWrapper(@NonNull Executor executor, @NonNull CameraManager.AvailabilityCallback wrappedCallback) {
            this.mExecutor = executor;
            this.mWrappedCallback = wrappedCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setDisabled() {
            Object object = this.mLock;
            synchronized (object) {
                this.mDisabled = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RequiresApi(value=29)
        public void onCameraAccessPrioritiesChanged() {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.mDisabled) {
                    this.mExecutor.execute(() -> ApiCompat.Api29Impl.onCameraAccessPrioritiesChanged(this.mWrappedCallback));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCameraAvailable(@NonNull String cameraId) {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.mDisabled) {
                    this.mExecutor.execute(() -> this.mWrappedCallback.onCameraAvailable(cameraId));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCameraUnavailable(@NonNull String cameraId) {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.mDisabled) {
                    this.mExecutor.execute(() -> this.mWrappedCallback.onCameraUnavailable(cameraId));
                }
            }
        }
    }
}

