/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.graphics.SurfaceTexture;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.Camera2SessionOptionUnpacker;
import androidx.camera.camera2.internal.DisplayInfoManager;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.camera2.internal.compat.StreamConfigurationMapCompat;
import androidx.camera.camera2.internal.compat.workaround.SupportedRepeatingSurfaceSize;
import androidx.camera.core.Logger;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.ImmediateSurface;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;

@RequiresApi(value=21)
class MeteringRepeatingSession {
    private static final String TAG = "MeteringRepeating";
    private DeferrableSurface mDeferrableSurface;
    @NonNull
    private SessionConfig mSessionConfig;
    @NonNull
    private final MeteringRepeatingConfig mConfigWithDefaults;
    @NonNull
    private final Size mMeteringRepeatingSize;
    @NonNull
    private final SupportedRepeatingSurfaceSize mSupportedRepeatingSurfaceSize = new SupportedRepeatingSurfaceSize();
    @Nullable
    private final SurfaceResetCallback mSurfaceResetCallback;

    MeteringRepeatingSession(@NonNull CameraCharacteristicsCompat cameraCharacteristicsCompat, @NonNull DisplayInfoManager displayInfoManager, @Nullable SurfaceResetCallback surfaceResetCallback) {
        this.mConfigWithDefaults = new MeteringRepeatingConfig();
        this.mSurfaceResetCallback = surfaceResetCallback;
        this.mMeteringRepeatingSize = this.getProperPreviewSize(cameraCharacteristicsCompat, displayInfoManager);
        Logger.d((String)TAG, (String)("MeteringSession SurfaceTexture size: " + this.mMeteringRepeatingSize));
        this.mSessionConfig = this.createSessionConfig();
    }

    @NonNull
    SessionConfig createSessionConfig() {
        final SurfaceTexture surfaceTexture = new SurfaceTexture(0);
        surfaceTexture.setDefaultBufferSize(this.mMeteringRepeatingSize.getWidth(), this.mMeteringRepeatingSize.getHeight());
        final Surface surface = new Surface(surfaceTexture);
        SessionConfig.Builder builder = SessionConfig.Builder.createFrom((UseCaseConfig)this.mConfigWithDefaults, (Size)this.mMeteringRepeatingSize);
        builder.setTemplateType(1);
        this.mDeferrableSurface = new ImmediateSurface(surface);
        Futures.addCallback((ListenableFuture)this.mDeferrableSurface.getTerminationFuture(), (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(@Nullable Void result) {
                surface.release();
                surfaceTexture.release();
            }

            public void onFailure(@NonNull Throwable t) {
                throw new IllegalStateException("Future should never fail. Did it get completed by GC?", t);
            }
        }, (Executor)CameraXExecutors.directExecutor());
        builder.addSurface(this.mDeferrableSurface);
        builder.addErrorListener((sessionConfig, error) -> {
            this.mSessionConfig = this.createSessionConfig();
            if (this.mSurfaceResetCallback != null) {
                this.mSurfaceResetCallback.onSurfaceReset();
            }
        });
        return builder.build();
    }

    @NonNull
    UseCaseConfig<?> getUseCaseConfig() {
        return this.mConfigWithDefaults;
    }

    @NonNull
    SessionConfig getSessionConfig() {
        return this.mSessionConfig;
    }

    @NonNull
    String getName() {
        return TAG;
    }

    void clear() {
        Logger.d((String)TAG, (String)"MeteringRepeating clear!");
        if (this.mDeferrableSurface != null) {
            this.mDeferrableSurface.close();
        }
        this.mDeferrableSurface = null;
    }

    @NonNull
    private Size getProperPreviewSize(@NonNull CameraCharacteristicsCompat cameraCharacteristicsCompat, @NonNull DisplayInfoManager displayInfoManager) {
        StreamConfigurationMapCompat mapCompat = cameraCharacteristicsCompat.getStreamConfigurationMapCompat();
        Size[] outputSizes = mapCompat.getOutputSizes(34);
        if (outputSizes == null) {
            Logger.e((String)TAG, (String)"Can not get output size list.");
            return new Size(0, 0);
        }
        outputSizes = this.mSupportedRepeatingSurfaceSize.getSupportedSizes(outputSizes);
        List<Size> outSizesList = Arrays.asList(outputSizes);
        Collections.sort(outSizesList, (o1, o2) -> {
            int result = Long.signum((long)o1.getWidth() * (long)o1.getHeight() - (long)o2.getWidth() * (long)o2.getHeight());
            return result;
        });
        Size previewMaxSize = displayInfoManager.getPreviewSize();
        long maxSizeProduct = Math.min((long)previewMaxSize.getWidth() * (long)previewMaxSize.getHeight(), 307200L);
        Size previousSize = null;
        for (Size outputSize : outputSizes) {
            long product = (long)outputSize.getWidth() * (long)outputSize.getHeight();
            if (product == maxSizeProduct) {
                return outputSize;
            }
            if (product > maxSizeProduct) {
                if (previousSize == null) break;
                return previousSize;
            }
            previousSize = outputSize;
        }
        return outSizesList.get(0);
    }

    private static class MeteringRepeatingConfig
    implements UseCaseConfig<UseCase> {
        @NonNull
        private final Config mConfig;

        MeteringRepeatingConfig() {
            MutableOptionsBundle mutableOptionsBundle = MutableOptionsBundle.create();
            mutableOptionsBundle.insertOption(UseCaseConfig.OPTION_SESSION_CONFIG_UNPACKER, (Object)new Camera2SessionOptionUnpacker());
            this.mConfig = mutableOptionsBundle;
        }

        @NonNull
        public Config getConfig() {
            return this.mConfig;
        }

        @NonNull
        public UseCaseConfigFactory.CaptureType getCaptureType() {
            return UseCaseConfigFactory.CaptureType.METERING_REPEATING;
        }
    }

    static interface SurfaceResetCallback {
        public void onSurfaceReset();
    }
}

