/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.Camera2CameraCaptureFailure;
import androidx.camera.camera2.internal.Camera2CameraCaptureResult;
import androidx.camera.camera2.internal.CaptureCallbackContainer;
import androidx.camera.camera2.internal.CaptureSession;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraCaptureFailure;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.RequestProcessor;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.SessionProcessorSurface;
import androidx.camera.core.impl.TagBundle;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;

@RequiresApi(value=21)
public class Camera2RequestProcessor
implements RequestProcessor {
    private static final String TAG = "Camera2RequestProcessor";
    @NonNull
    private final CaptureSession mCaptureSession;
    @NonNull
    private final List<SessionProcessorSurface> mProcessorSurfaces;
    private volatile boolean mIsClosed = false;
    @Nullable
    private volatile SessionConfig mSessionConfig;

    public Camera2RequestProcessor(@NonNull CaptureSession captureSession, @NonNull List<SessionProcessorSurface> processorSurfaces) {
        Preconditions.checkArgument((captureSession.mState == CaptureSession.State.OPENED ? 1 : 0) != 0, (Object)("CaptureSession state must be OPENED. Current state:" + (Object)((Object)captureSession.mState)));
        this.mCaptureSession = captureSession;
        this.mProcessorSurfaces = Collections.unmodifiableList(new ArrayList<SessionProcessorSurface>(processorSurfaces));
    }

    public void close() {
        this.mIsClosed = true;
    }

    public void updateSessionConfig(@Nullable SessionConfig sessionConfig) {
        this.mSessionConfig = sessionConfig;
    }

    private boolean areRequestsValid(@NonNull List<RequestProcessor.Request> requests) {
        for (RequestProcessor.Request request : requests) {
            if (this.isRequestValid(request)) continue;
            return false;
        }
        return true;
    }

    private boolean isRequestValid(@NonNull RequestProcessor.Request request) {
        if (request.getTargetOutputConfigIds().isEmpty()) {
            Logger.e((String)TAG, (String)"Unable to submit the RequestProcessor.Request: empty targetOutputConfigIds");
            return false;
        }
        for (Integer outputConfigId : request.getTargetOutputConfigIds()) {
            if (this.findSurface(outputConfigId) != null) continue;
            Logger.e((String)TAG, (String)("Unable to submit the RequestProcessor.Request: targetOutputConfigId(" + outputConfigId + ") is not a valid id"));
            return false;
        }
        return true;
    }

    public int submit(@NonNull RequestProcessor.Request request, @NonNull RequestProcessor.Callback callback) {
        return this.submit(Arrays.asList(request), callback);
    }

    public int submit(@NonNull List<RequestProcessor.Request> requests, @NonNull RequestProcessor.Callback callback) {
        if (this.mIsClosed || !this.areRequestsValid(requests)) {
            return -1;
        }
        ArrayList<CaptureConfig> captureConfigs = new ArrayList<CaptureConfig>();
        boolean shouldInvokeSequenceCallback = true;
        for (RequestProcessor.Request request : requests) {
            CaptureConfig.Builder builder = new CaptureConfig.Builder();
            builder.setTemplateType(request.getTemplateId());
            builder.setImplementationOptions(request.getParameters());
            builder.addCameraCaptureCallback((CameraCaptureCallback)CaptureCallbackContainer.create(new Camera2CallbackWrapper(request, callback, shouldInvokeSequenceCallback)));
            shouldInvokeSequenceCallback = false;
            for (Integer outputConfigId : request.getTargetOutputConfigIds()) {
                builder.addSurface(this.findSurface(outputConfigId));
            }
            captureConfigs.add(builder.build());
        }
        return this.mCaptureSession.issueBurstCaptureRequest(captureConfigs);
    }

    public int setRepeating(@NonNull RequestProcessor.Request request, @NonNull RequestProcessor.Callback callback) {
        if (this.mIsClosed || !this.isRequestValid(request)) {
            return -1;
        }
        SessionConfig.Builder sessionConfigBuilder = new SessionConfig.Builder();
        sessionConfigBuilder.setTemplateType(request.getTemplateId());
        sessionConfigBuilder.setImplementationOptions(request.getParameters());
        sessionConfigBuilder.addCameraCaptureCallback((CameraCaptureCallback)CaptureCallbackContainer.create(new Camera2CallbackWrapper(request, callback, true)));
        if (this.mSessionConfig != null) {
            for (Object cameraCaptureCallback : this.mSessionConfig.getRepeatingCameraCaptureCallbacks()) {
                sessionConfigBuilder.addCameraCaptureCallback((CameraCaptureCallback)cameraCaptureCallback);
            }
            TagBundle tagBundle = this.mSessionConfig.getRepeatingCaptureConfig().getTagBundle();
            for (String key : tagBundle.listKeys()) {
                sessionConfigBuilder.addTag(key, tagBundle.getTag(key));
            }
        }
        for (Integer outputConfigId : request.getTargetOutputConfigIds()) {
            sessionConfigBuilder.addSurface(this.findSurface(outputConfigId));
        }
        return this.mCaptureSession.issueRepeatingCaptureRequests(sessionConfigBuilder.build());
    }

    public void abortCaptures() {
        if (this.mIsClosed) {
            return;
        }
        this.mCaptureSession.abortCaptures();
    }

    public void stopRepeating() {
        if (this.mIsClosed) {
            return;
        }
        this.mCaptureSession.stopRepeating();
    }

    int findOutputConfigId(@NonNull Surface surface) {
        for (SessionProcessorSurface sessionProcessorSurface : this.mProcessorSurfaces) {
            try {
                if (sessionProcessorSurface.getSurface().get() != surface) continue;
                return sessionProcessorSurface.getOutputConfigId();
            }
            catch (InterruptedException | ExecutionException exception) {
            }
        }
        return -1;
    }

    @Nullable
    private DeferrableSurface findSurface(int outputConfigId) {
        for (SessionProcessorSurface sessionProcessorSurface : this.mProcessorSurfaces) {
            if (sessionProcessorSurface.getOutputConfigId() != outputConfigId) continue;
            return sessionProcessorSurface;
        }
        return null;
    }

    private class Camera2CallbackWrapper
    extends CameraCaptureSession.CaptureCallback {
        private final RequestProcessor.Callback mCallback;
        private final RequestProcessor.Request mRequest;
        private final boolean mInvokeSequenceCallback;

        Camera2CallbackWrapper(@NonNull RequestProcessor.Request captureRequest, RequestProcessor.Callback callback, boolean invokeSequenceCallback) {
            this.mCallback = callback;
            this.mRequest = captureRequest;
            this.mInvokeSequenceCallback = invokeSequenceCallback;
        }

        public void onCaptureStarted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, long timestamp, long frameNumber) {
            this.mCallback.onCaptureStarted(this.mRequest, frameNumber, timestamp);
        }

        public void onCaptureProgressed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureResult partialResult) {
            this.mCallback.onCaptureProgressed(this.mRequest, (CameraCaptureResult)new Camera2CameraCaptureResult(partialResult));
        }

        public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
            this.mCallback.onCaptureCompleted(this.mRequest, (CameraCaptureResult)new Camera2CameraCaptureResult((CaptureResult)result));
        }

        public void onCaptureFailed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureFailure failure) {
            this.mCallback.onCaptureFailed(this.mRequest, (CameraCaptureFailure)new Camera2CameraCaptureFailure(CameraCaptureFailure.Reason.ERROR, failure));
        }

        public void onCaptureSequenceCompleted(@NonNull CameraCaptureSession session, int sequenceId, long frameNumber) {
            if (this.mInvokeSequenceCallback) {
                this.mCallback.onCaptureSequenceCompleted(sequenceId, frameNumber);
            }
        }

        public void onCaptureSequenceAborted(@NonNull CameraCaptureSession session, int sequenceId) {
            if (this.mInvokeSequenceCallback) {
                this.mCallback.onCaptureSequenceAborted(sequenceId);
            }
        }

        public void onCaptureBufferLost(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull Surface target, long frameNumber) {
            this.mCallback.onCaptureBufferLost(this.mRequest, frameNumber, Camera2RequestProcessor.this.findOutputConfigId(target));
        }
    }
}

