/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.os.Build;
import androidx.annotation.NonNull;
import androidx.camera.core.impl.ImageAnalysisConfig;
import androidx.camera.core.impl.ImageCaptureConfig;
import androidx.camera.core.impl.PreviewConfig;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.VideoCaptureConfig;
import java.util.Collection;

public final class StreamUseCaseUtil {
    private StreamUseCaseUtil() {
    }

    public static long getStreamUseCaseFromUseCaseConfigs(@NonNull Collection<UseCaseConfig<?>> useCaseConfigs, @NonNull Collection<SessionConfig> sessionConfigs) {
        if (Build.VERSION.SDK_INT < 33) {
            return -1L;
        }
        if (useCaseConfigs.isEmpty()) {
            return 0L;
        }
        for (SessionConfig sessionConfig : sessionConfigs) {
            if (sessionConfig.getTemplateType() != 5) continue;
            return 0L;
        }
        boolean hasImageCapture = false;
        boolean hasVideoCapture = false;
        boolean hasPreview = false;
        for (UseCaseConfig<?> useCaseConfig : useCaseConfigs) {
            if (useCaseConfig instanceof ImageAnalysisConfig) {
                return 0L;
            }
            if (useCaseConfig instanceof PreviewConfig) {
                hasPreview = true;
                continue;
            }
            if (useCaseConfig instanceof ImageCaptureConfig) {
                if (hasVideoCapture) {
                    return 4L;
                }
                hasImageCapture = true;
                continue;
            }
            if (!(useCaseConfig instanceof VideoCaptureConfig)) continue;
            if (hasImageCapture) {
                return 4L;
            }
            hasVideoCapture = true;
        }
        if (hasImageCapture) {
            return 2L;
        }
        if (hasVideoCapture) {
            return 3L;
        }
        if (!hasPreview) {
            return 0L;
        }
        return 1L;
    }
}

