/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.workaround;

import android.hardware.camera2.CameraCharacteristics;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.camera2.internal.compat.quirk.DeviceQuirks;
import androidx.camera.camera2.internal.compat.quirk.FlashAvailabilityBufferUnderflowQuirk;
import androidx.camera.core.Logger;
import java.nio.BufferUnderflowException;

@RequiresApi(value=21)
public final class FlashAvailabilityChecker {
    private static final String TAG = "FlashAvailability";

    public static boolean isFlashAvailable(@NonNull CameraCharacteristicsCompat characteristics) {
        if (DeviceQuirks.get(FlashAvailabilityBufferUnderflowQuirk.class) != null) {
            Logger.d((String)TAG, (String)("Device has quirk " + FlashAvailabilityBufferUnderflowQuirk.class.getSimpleName() + ". Checking for flash availability safely..."));
            return FlashAvailabilityChecker.checkFlashAvailabilityWithPossibleBufferUnderflow(characteristics);
        }
        return FlashAvailabilityChecker.checkFlashAvailabilityNormally(characteristics);
    }

    private static boolean checkFlashAvailabilityWithPossibleBufferUnderflow(@NonNull CameraCharacteristicsCompat characteristics) {
        try {
            return FlashAvailabilityChecker.checkFlashAvailabilityNormally(characteristics);
        }
        catch (BufferUnderflowException e) {
            return false;
        }
    }

    private static boolean checkFlashAvailabilityNormally(@NonNull CameraCharacteristicsCompat characteristics) {
        Boolean flashAvailable = (Boolean)characteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        if (flashAvailable == null) {
            Logger.w((String)TAG, (String)"Characteristics did not contain key FLASH_INFO_AVAILABLE. Flash is not available.");
        }
        return flashAvailable != null ? flashAvailable : false;
    }

    private FlashAvailabilityChecker() {
    }
}

