/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.workaround;

import android.util.Size;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.compat.quirk.CamcorderProfileResolutionQuirk;
import androidx.camera.core.impl.CamcorderProfileProxy;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@RequiresApi(value=21)
public class CamcorderProfileResolutionValidator {
    private final CamcorderProfileResolutionQuirk mQuirk;
    private final Set<Size> mSupportedResolutions;

    public CamcorderProfileResolutionValidator(@Nullable CamcorderProfileResolutionQuirk quirk) {
        this.mQuirk = quirk;
        this.mSupportedResolutions = quirk != null ? new HashSet<Size>(quirk.getSupportedResolutions()) : Collections.emptySet();
    }

    public boolean hasQuirk() {
        return this.mQuirk != null;
    }

    public boolean hasValidVideoResolution(@Nullable CamcorderProfileProxy profile) {
        if (profile == null) {
            return false;
        }
        if (this.mQuirk == null) {
            return true;
        }
        Size videoSize = new Size(profile.getVideoFrameWidth(), profile.getVideoFrameHeight());
        return this.mSupportedResolutions.contains(videoSize);
    }
}

