/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.quirk;

import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.Build;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.Quirk;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RequiresApi(value=21)
public class CamcorderProfileResolutionQuirk
implements Quirk {
    private static final String TAG = "CamcorderProfileResolutionQuirk";
    private final List<Size> mSupportedResolutions;

    static boolean load(@NonNull CameraCharacteristicsCompat characteristicsCompat) {
        Integer level = (Integer)characteristicsCompat.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
        return level != null && level == 2;
    }

    public CamcorderProfileResolutionQuirk(@NonNull CameraCharacteristicsCompat characteristicsCompat) {
        StreamConfigurationMap map = (StreamConfigurationMap)characteristicsCompat.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        if (map == null) {
            Logger.e((String)TAG, (String)"StreamConfigurationMap is null");
        }
        Size[] sizes = Build.VERSION.SDK_INT < 23 ? (map != null ? map.getOutputSizes(SurfaceTexture.class) : null) : (map != null ? map.getOutputSizes(34) : null);
        this.mSupportedResolutions = sizes != null ? Arrays.asList((Size[])sizes.clone()) : Collections.emptyList();
        Logger.d((String)TAG, (String)("mSupportedResolutions = " + this.mSupportedResolutions));
    }

    @NonNull
    public List<Size> getSupportedResolutions() {
        return new ArrayList<Size>(this.mSupportedResolutions);
    }
}

