/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.params.InputConfiguration;
import android.os.Handler;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.compat.CameraAccessExceptionCompat;
import androidx.camera.camera2.internal.compat.CameraCaptureSessionCompat;
import androidx.camera.camera2.internal.compat.CameraDeviceCompatBaseImpl;
import androidx.camera.camera2.internal.compat.params.InputConfigurationCompat;
import androidx.camera.camera2.internal.compat.params.SessionConfigurationCompat;
import androidx.core.util.Preconditions;
import java.util.List;

@RequiresApi(value=23)
class CameraDeviceCompatApi23Impl
extends CameraDeviceCompatBaseImpl {
    CameraDeviceCompatApi23Impl(@NonNull CameraDevice cameraDevice, @Nullable Object implParams) {
        super(cameraDevice, implParams);
    }

    static CameraDeviceCompatApi23Impl create(@NonNull CameraDevice cameraDevice, @NonNull Handler compatHandler) {
        return new CameraDeviceCompatApi23Impl(cameraDevice, new CameraDeviceCompatBaseImpl.CameraDeviceCompatParamsApi21(compatHandler));
    }

    @Override
    public void createCaptureSession(@NonNull SessionConfigurationCompat config) throws CameraAccessExceptionCompat {
        CameraDeviceCompatApi23Impl.checkPreconditions(this.mCameraDevice, config);
        CameraCaptureSessionCompat.StateCallbackExecutorWrapper cb = new CameraCaptureSessionCompat.StateCallbackExecutorWrapper(config.getExecutor(), config.getStateCallback());
        List<Surface> surfaces = CameraDeviceCompatApi23Impl.unpackSurfaces(config.getOutputConfigurations());
        CameraDeviceCompatBaseImpl.CameraDeviceCompatParamsApi21 params = (CameraDeviceCompatBaseImpl.CameraDeviceCompatParamsApi21)this.mImplParams;
        Handler handler = ((CameraDeviceCompatBaseImpl.CameraDeviceCompatParamsApi21)Preconditions.checkNotNull((Object)params)).mCompatHandler;
        InputConfigurationCompat inputConfigCompat = config.getInputConfiguration();
        try {
            if (inputConfigCompat != null) {
                InputConfiguration inputConfig = (InputConfiguration)inputConfigCompat.unwrap();
                Preconditions.checkNotNull((Object)inputConfig);
                this.mCameraDevice.createReprocessableCaptureSession(inputConfig, surfaces, (CameraCaptureSession.StateCallback)cb, handler);
            } else if (config.getSessionType() == 1) {
                this.mCameraDevice.createConstrainedHighSpeedCaptureSession(surfaces, (CameraCaptureSession.StateCallback)cb, handler);
            } else {
                this.createBaseCaptureSession(this.mCameraDevice, surfaces, cb, handler);
            }
        }
        catch (CameraAccessException e) {
            throw CameraAccessExceptionCompat.toCameraAccessExceptionCompat(e);
        }
    }
}

