/*
 * Decompiled with CFR 0.152.
 */
package android.arch.persistence.room;

import android.arch.persistence.db.SupportSQLiteStatement;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.SharedSQLiteStatement;
import android.support.annotation.RestrictTo;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class EntityDeletionOrUpdateAdapter<T>
extends SharedSQLiteStatement {
    public EntityDeletionOrUpdateAdapter(RoomDatabase database) {
        super(database);
    }

    @Override
    protected abstract String createQuery();

    protected abstract void bind(SupportSQLiteStatement var1, T var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int handle(T entity) {
        SupportSQLiteStatement stmt = this.acquire();
        try {
            this.bind(stmt, entity);
            int n = stmt.executeUpdateDelete();
            return n;
        }
        finally {
            this.release(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int handleMultiple(Iterable<T> entities) {
        SupportSQLiteStatement stmt = this.acquire();
        try {
            int total = 0;
            for (T entity : entities) {
                this.bind(stmt, entity);
                total += stmt.executeUpdateDelete();
            }
            int n = total;
            return n;
        }
        finally {
            this.release(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int handleMultiple(T[] entities) {
        SupportSQLiteStatement stmt = this.acquire();
        try {
            int total = 0;
            for (T entity : entities) {
                this.bind(stmt, entity);
                total += stmt.executeUpdateDelete();
            }
            int n = total;
            return n;
        }
        finally {
            this.release(stmt);
        }
    }
}

