/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.test.api.score.stream;

import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.api.score.stream.ConstraintFactory;
import ai.timefold.solver.core.api.score.stream.ConstraintProvider;
import ai.timefold.solver.core.api.score.stream.ConstraintStreamImplType;
import ai.timefold.solver.core.config.score.director.ScoreDirectorFactoryConfig;
import ai.timefold.solver.core.config.solver.SolverConfig;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.test.api.score.stream.MultiConstraintVerification;
import ai.timefold.solver.test.api.score.stream.SingleConstraintVerification;
import ai.timefold.solver.test.impl.score.stream.DefaultConstraintVerifier;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;

public interface ConstraintVerifier<ConstraintProvider_ extends ConstraintProvider, Solution_> {
    public static <ConstraintProvider_ extends ConstraintProvider, Solution_> ConstraintVerifier<ConstraintProvider_, Solution_> build(ConstraintProvider_ constraintProvider, Class<Solution_> planningSolutionClass, Class<?> ... entityClasses) {
        Objects.requireNonNull(constraintProvider);
        SolutionDescriptor solutionDescriptor = SolutionDescriptor.buildSolutionDescriptor(Objects.requireNonNull(planningSolutionClass), (Class[])entityClasses);
        return new DefaultConstraintVerifier(constraintProvider, solutionDescriptor);
    }

    public static <ConstraintProvider_ extends ConstraintProvider, Solution_> ConstraintVerifier<ConstraintProvider_, Solution_> create(SolverConfig solverConfig) {
        Objects.requireNonNull(solverConfig);
        SolutionDescriptor solutionDescriptor = SolutionDescriptor.buildSolutionDescriptor((Class)Objects.requireNonNull(solverConfig.getSolutionClass()), (Class[])solverConfig.getEntityClassList().toArray(new Class[0]));
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = Objects.requireNonNull(solverConfig.getScoreDirectorFactoryConfig());
        ConstraintProvider constraintProvider = (ConstraintProvider)ConfigUtils.newInstance(null, (String)"constraintProviderClass", (Class)scoreDirectorFactoryConfig.getConstraintProviderClass());
        ConfigUtils.applyCustomProperties((Object)constraintProvider, (String)"constraintProviderClass", (Map)scoreDirectorFactoryConfig.getConstraintProviderCustomProperties(), (String)"constraintProviderCustomProperties");
        DefaultConstraintVerifier constraintVerifier = new DefaultConstraintVerifier(constraintProvider, solutionDescriptor);
        if (scoreDirectorFactoryConfig.getConstraintStreamImplType() != null) {
            constraintVerifier.withConstraintStreamImplType(scoreDirectorFactoryConfig.getConstraintStreamImplType());
        }
        if (scoreDirectorFactoryConfig.getDroolsAlphaNetworkCompilationEnabled() != null) {
            constraintVerifier.withDroolsAlphaNetworkCompilationEnabled(scoreDirectorFactoryConfig.getDroolsAlphaNetworkCompilationEnabled());
        }
        return constraintVerifier;
    }

    public ConstraintVerifier<ConstraintProvider_, Solution_> withConstraintStreamImplType(ConstraintStreamImplType var1);

    @Deprecated(forRemoval=true)
    default public ConstraintVerifier<ConstraintProvider_, Solution_> withDroolsAlphaNetworkCompilationEnabled(boolean droolsAlphaNetworkCompilationEnabled) {
        return this;
    }

    public SingleConstraintVerification<Solution_> verifyThat(BiFunction<ConstraintProvider_, ConstraintFactory, Constraint> var1);

    public MultiConstraintVerification<Solution_> verifyThat();
}

