/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.spring.boot.autoconfigure;

import ai.timefold.solver.benchmark.api.PlannerBenchmarkFactory;
import ai.timefold.solver.benchmark.config.PlannerBenchmarkConfig;
import ai.timefold.solver.benchmark.config.SolverBenchmarkConfig;
import ai.timefold.solver.core.config.solver.SolverConfig;
import ai.timefold.solver.core.config.solver.termination.TerminationConfig;
import ai.timefold.solver.spring.boot.autoconfigure.TimefoldSolverAutoConfiguration;
import ai.timefold.solver.spring.boot.autoconfigure.config.TimefoldProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@AutoConfigureAfter(value={TimefoldSolverAutoConfiguration.class})
@ConditionalOnClass(value={PlannerBenchmarkFactory.class})
@ConditionalOnMissingBean(value={PlannerBenchmarkFactory.class})
@EnableConfigurationProperties(value={TimefoldProperties.class})
public class TimefoldBenchmarkAutoConfiguration
implements BeanClassLoaderAware,
ApplicationContextAware {
    private final TimefoldProperties timefoldProperties;
    private ClassLoader beanClassLoader;
    private ApplicationContext context;

    protected TimefoldBenchmarkAutoConfiguration(TimefoldProperties timefoldProperties) {
        this.timefoldProperties = timefoldProperties;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    @Bean
    @Lazy
    public PlannerBenchmarkConfig plannerBenchmarkConfig() {
        TerminationConfig inheritedTerminationConfig;
        SolverBenchmarkConfig inheritedBenchmarkConfig;
        PlannerBenchmarkConfig benchmarkConfig;
        this.assertSingleSolver();
        SolverConfig solverConfig = (SolverConfig)this.context.getBean(SolverConfig.class);
        if (this.timefoldProperties.getBenchmark() != null && this.timefoldProperties.getBenchmark().getSolverBenchmarkConfigXml() != null) {
            if (this.beanClassLoader.getResource(this.timefoldProperties.getBenchmark().getSolverBenchmarkConfigXml()) == null) {
                throw new IllegalStateException("Invalid timefold.benchmark.solverBenchmarkConfigXml property (%s): that classpath resource does not exist.".formatted(this.timefoldProperties.getBenchmark().getSolverBenchmarkConfigXml()));
            }
            benchmarkConfig = PlannerBenchmarkConfig.createFromXmlResource((String)this.timefoldProperties.getBenchmark().getSolverBenchmarkConfigXml(), (ClassLoader)this.beanClassLoader);
        } else if (this.beanClassLoader.getResource("solverBenchmarkConfig.xml") != null) {
            benchmarkConfig = PlannerBenchmarkConfig.createFromXmlResource((String)"solverBenchmarkConfig.xml", (ClassLoader)this.beanClassLoader);
        } else {
            benchmarkConfig = PlannerBenchmarkConfig.createFromSolverConfig((SolverConfig)solverConfig);
            benchmarkConfig.setBenchmarkDirectory(new File("target/benchmarks"));
        }
        if (this.timefoldProperties.getBenchmark() != null && this.timefoldProperties.getBenchmark().getResultDirectory() != null) {
            benchmarkConfig.setBenchmarkDirectory(new File(this.timefoldProperties.getBenchmark().getResultDirectory()));
        }
        if (benchmarkConfig.getBenchmarkDirectory() == null) {
            benchmarkConfig.setBenchmarkDirectory(new File("target/benchmarks"));
        }
        if ((inheritedBenchmarkConfig = benchmarkConfig.getInheritedSolverBenchmarkConfig()) == null) {
            inheritedBenchmarkConfig = new SolverBenchmarkConfig();
            benchmarkConfig.setInheritedSolverBenchmarkConfig(inheritedBenchmarkConfig);
            inheritedBenchmarkConfig.setSolverConfig(solverConfig.copyConfig());
        }
        SolverConfig inheritedBenchmarkSolverConfig = Objects.requireNonNull(inheritedBenchmarkConfig.getSolverConfig());
        if (this.timefoldProperties.getBenchmark() != null && this.timefoldProperties.getBenchmark().getSolver() != null) {
            TimefoldSolverAutoConfiguration.applyTerminationProperties(inheritedBenchmarkSolverConfig, this.timefoldProperties.getBenchmark().getSolver().getTermination());
        }
        if ((inheritedTerminationConfig = inheritedBenchmarkSolverConfig.getTerminationConfig()) == null || !inheritedTerminationConfig.isConfigured()) {
            List solverBenchmarkConfigList = benchmarkConfig.getSolverBenchmarkConfigList();
            ArrayList<String> unconfiguredTerminationSolverBenchmarkList = new ArrayList<String>();
            if (solverBenchmarkConfigList == null) {
                throw new IllegalStateException("At least one of the properties timefold.benchmark.solver.termination.spent-limit, timefold.benchmark.solver.termination.best-score-limit, timefold.benchmark.solver.termination.unimproved-spent-limit is required if termination is not configured in the inherited solver benchmark config and solverBenchmarkBluePrint is used.\n");
            }
            if (solverBenchmarkConfigList.size() == 1 && ((SolverBenchmarkConfig)solverBenchmarkConfigList.get(0)).getSolverConfig() == null) {
                if (!inheritedBenchmarkSolverConfig.canTerminate()) {
                    String benchmarkConfigName = Objects.requireNonNullElse(inheritedBenchmarkConfig.getName(), "InheritedSolverBenchmarkConfig");
                    unconfiguredTerminationSolverBenchmarkList.add(benchmarkConfigName);
                }
            } else {
                for (int i = 0; i < solverBenchmarkConfigList.size(); ++i) {
                    SolverBenchmarkConfig solverBenchmarkConfig = (SolverBenchmarkConfig)solverBenchmarkConfigList.get(i);
                    if (solverConfig.canTerminate()) continue;
                    String benchmarkConfigName = (String)((Object)Objects.requireNonNullElse(solverBenchmarkConfig.getName(), "SolverBenchmarkConfig" + i));
                    unconfiguredTerminationSolverBenchmarkList.add(benchmarkConfigName);
                }
            }
            if (!unconfiguredTerminationSolverBenchmarkList.isEmpty()) {
                throw new IllegalStateException("The following %s do not have termination configured: %s. At least one of the properties timefold.benchmark.solver.termination.spent-limit, timefold.benchmark.solver.termination.best-score-limit, timefold.benchmark.solver.termination.unimproved-spent-limit is required if termination is not configured in a solver benchmark and the inherited solver benchmark config.\n".formatted(SolverBenchmarkConfig.class.getSimpleName(), unconfiguredTerminationSolverBenchmarkList.stream().collect(Collectors.joining(", ", "[", "]"))));
            }
        }
        return benchmarkConfig;
    }

    @Bean
    @Lazy
    public PlannerBenchmarkFactory plannerBenchmarkFactory(PlannerBenchmarkConfig benchmarkConfig) {
        if (benchmarkConfig == null) {
            return null;
        }
        this.assertSingleSolver();
        return PlannerBenchmarkFactory.create((PlannerBenchmarkConfig)benchmarkConfig);
    }

    private void assertSingleSolver() {
        if (this.timefoldProperties.getSolver() != null && this.timefoldProperties.getSolver().size() > 1) {
            throw new IllegalStateException("When defining multiple solvers, the benchmark feature is not enabled.\nConsider using separate <solverBenchmark> instances for evaluating different solver configurations.");
        }
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }
}

