/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.quarkus;

import ai.timefold.solver.core.api.domain.solution.cloner.SolutionCloner;
import ai.timefold.solver.core.api.solver.SolverFactory;
import ai.timefold.solver.core.api.solver.SolverManager;
import ai.timefold.solver.core.config.solver.SolverConfig;
import ai.timefold.solver.core.config.solver.SolverManagerConfig;
import ai.timefold.solver.core.config.solver.termination.DiminishedReturnsTerminationConfig;
import ai.timefold.solver.core.config.solver.termination.TerminationConfig;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.quarkus.config.DiminishedReturnsRuntimeConfig;
import ai.timefold.solver.quarkus.config.SolverRuntimeConfig;
import ai.timefold.solver.quarkus.config.TimefoldRuntimeConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.inject.Named;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;

@Recorder
public class TimefoldRecorder {
    final TimefoldRuntimeConfig timefoldRuntimeConfig;

    public TimefoldRecorder(TimefoldRuntimeConfig timefoldRuntimeConfig) {
        this.timefoldRuntimeConfig = timefoldRuntimeConfig;
    }

    public static void assertNoUnmatchedProperties(Set<String> expectedNames, Set<String> actualNames) {
        HashSet<String> allExpectedNames = new HashSet<String>(expectedNames);
        allExpectedNames.add("default");
        if (!allExpectedNames.containsAll(actualNames)) {
            List expectedNamesSorted = expectedNames.stream().sorted().toList();
            List<String> unmatchedNamesSorted = actualNames.stream().filter(Predicate.not(allExpectedNames::contains)).sorted().toList();
            throw new IllegalStateException("Some names defined in properties (%s) do not have a corresponding @%s injection point (%s). Maybe you misspelled them?\n".formatted(unmatchedNamesSorted, Named.class.getSimpleName(), expectedNamesSorted));
        }
    }

    public void assertNoUnmatchedRuntimeProperties(Set<String> names) {
        TimefoldRecorder.assertNoUnmatchedProperties(names, this.timefoldRuntimeConfig.solver().keySet());
    }

    public Supplier<SolverConfig> solverConfigSupplier(String solverName, SolverConfig solverConfig, Map<String, RuntimeValue<MemberAccessor>> generatedGizmoMemberAccessorMap, Map<String, RuntimeValue<SolutionCloner>> generatedGizmoSolutionClonerMap) {
        return () -> {
            this.updateSolverConfigWithRuntimeProperties(solverName, solverConfig);
            HashMap memberAccessorMap = new HashMap();
            HashMap solutionClonerMap = new HashMap();
            generatedGizmoMemberAccessorMap.forEach((className, runtimeValue) -> memberAccessorMap.put(className, (MemberAccessor)runtimeValue.getValue()));
            generatedGizmoSolutionClonerMap.forEach((className, runtimeValue) -> solutionClonerMap.put(className, (SolutionCloner)runtimeValue.getValue()));
            solverConfig.setGizmoMemberAccessorMap(memberAccessorMap);
            solverConfig.setGizmoSolutionClonerMap(solutionClonerMap);
            return solverConfig;
        };
    }

    public Supplier<SolverManagerConfig> solverManagerConfig(SolverManagerConfig solverManagerConfig) {
        return () -> {
            this.updateSolverManagerConfigWithRuntimeProperties(solverManagerConfig);
            return solverManagerConfig;
        };
    }

    public <Solution_, ProblemId_> Supplier<SolverManager<Solution_, ProblemId_>> solverManager(String solverName, SolverConfig solverConfig, Map<String, RuntimeValue<MemberAccessor>> generatedGizmoMemberAccessorMap, Map<String, RuntimeValue<SolutionCloner>> generatedGizmoSolutionClonerMap) {
        return () -> {
            this.updateSolverConfigWithRuntimeProperties(solverName, solverConfig);
            HashMap memberAccessorMap = new HashMap();
            HashMap solutionClonerMap = new HashMap();
            generatedGizmoMemberAccessorMap.forEach((className, runtimeValue) -> memberAccessorMap.put(className, (MemberAccessor)runtimeValue.getValue()));
            generatedGizmoSolutionClonerMap.forEach((className, runtimeValue) -> solutionClonerMap.put(className, (SolutionCloner)runtimeValue.getValue()));
            solverConfig.setGizmoMemberAccessorMap(memberAccessorMap);
            solverConfig.setGizmoSolutionClonerMap(solutionClonerMap);
            SolverManagerConfig solverManagerConfig = new SolverManagerConfig();
            this.updateSolverManagerConfigWithRuntimeProperties(solverManagerConfig);
            SolverFactory solverFactory = SolverFactory.create((SolverConfig)solverConfig);
            return SolverManager.create((SolverFactory)solverFactory, (SolverManagerConfig)solverManagerConfig);
        };
    }

    private void updateSolverConfigWithRuntimeProperties(String solverName, SolverConfig solverConfig) {
        TimefoldRecorder.updateSolverConfigWithRuntimeProperties(solverConfig, this.timefoldRuntimeConfig.getSolverRuntimeConfig(solverName).orElse(null));
    }

    public static void updateSolverConfigWithRuntimeProperties(SolverConfig solverConfig, @Nullable SolverRuntimeConfig solverRuntimeConfig) {
        TerminationConfig terminationConfig = solverConfig.getTerminationConfig();
        if (terminationConfig == null) {
            terminationConfig = new TerminationConfig();
            solverConfig.setTerminationConfig(terminationConfig);
        }
        Optional<SolverRuntimeConfig> maybeSolverRuntimeConfig = Optional.ofNullable(solverRuntimeConfig);
        maybeSolverRuntimeConfig.flatMap(config -> config.termination().spentLimit()).ifPresent(arg_0 -> ((TerminationConfig)terminationConfig).setSpentLimit(arg_0));
        maybeSolverRuntimeConfig.flatMap(config -> config.termination().unimprovedSpentLimit()).ifPresent(arg_0 -> ((TerminationConfig)terminationConfig).setUnimprovedSpentLimit(arg_0));
        maybeSolverRuntimeConfig.flatMap(config -> config.termination().bestScoreLimit()).ifPresent(arg_0 -> ((TerminationConfig)terminationConfig).setBestScoreLimit(arg_0));
        maybeSolverRuntimeConfig.flatMap(SolverRuntimeConfig::environmentMode).ifPresent(arg_0 -> ((SolverConfig)solverConfig).setEnvironmentMode(arg_0));
        maybeSolverRuntimeConfig.flatMap(SolverRuntimeConfig::daemon).ifPresent(arg_0 -> ((SolverConfig)solverConfig).setDaemon(arg_0));
        maybeSolverRuntimeConfig.flatMap(SolverRuntimeConfig::moveThreadCount).ifPresent(arg_0 -> ((SolverConfig)solverConfig).setMoveThreadCount(arg_0));
        maybeSolverRuntimeConfig.flatMap(config -> config.termination().diminishedReturns()).ifPresent(diminishedReturnsConfig -> TimefoldRecorder.setDiminishedReturns(solverConfig, diminishedReturnsConfig));
    }

    private static void setDiminishedReturns(SolverConfig solverConfig, DiminishedReturnsRuntimeConfig diminishedReturnsRuntimeConfig) {
        if (!diminishedReturnsRuntimeConfig.enabled().orElse(diminishedReturnsRuntimeConfig.minimumImprovementRatio().isPresent() || diminishedReturnsRuntimeConfig.slidingWindowDuration().isPresent()).booleanValue()) {
            return;
        }
        TerminationConfig terminationConfig = solverConfig.getTerminationConfig();
        if (terminationConfig == null) {
            terminationConfig = new TerminationConfig();
            solverConfig.setTerminationConfig(terminationConfig);
        }
        DiminishedReturnsTerminationConfig diminishedReturnsConfig = new DiminishedReturnsTerminationConfig();
        diminishedReturnsRuntimeConfig.slidingWindowDuration().ifPresent(arg_0 -> ((DiminishedReturnsTerminationConfig)diminishedReturnsConfig).setSlidingWindowDuration(arg_0));
        diminishedReturnsRuntimeConfig.minimumImprovementRatio().ifPresent(arg_0 -> ((DiminishedReturnsTerminationConfig)diminishedReturnsConfig).setMinimumImprovementRatio(arg_0));
        terminationConfig.setDiminishedReturnsConfig(diminishedReturnsConfig);
    }

    private void updateSolverManagerConfigWithRuntimeProperties(SolverManagerConfig solverManagerConfig) {
        this.timefoldRuntimeConfig.solverManager().parallelSolverCount().ifPresent(arg_0 -> ((SolverManagerConfig)solverManagerConfig).setParallelSolverCount(arg_0));
    }
}

