/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.quarkus.it;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.buildin.hardsoft.HardSoftScore;
import ai.timefold.solver.core.api.solver.SolverConfigOverride;
import ai.timefold.solver.core.api.solver.SolverJob;
import ai.timefold.solver.core.api.solver.SolverJobBuilder;
import ai.timefold.solver.core.api.solver.SolverManager;
import ai.timefold.solver.core.config.solver.termination.TerminationConfig;
import ai.timefold.solver.core.impl.solver.DefaultSolverJob;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.quarkus.it.domain.TestdataStringLengthShadowEntity;
import ai.timefold.solver.quarkus.it.domain.TestdataStringLengthShadowSolution;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;

@Path(value="/timefold/test")
public class TimefoldTestResource {
    private final SolverManager<TestdataStringLengthShadowSolution, Long> solverManager;

    @Inject
    public TimefoldTestResource(SolverManager<TestdataStringLengthShadowSolution, Long> solverManager) {
        this.solverManager = solverManager;
    }

    private static TestdataStringLengthShadowSolution generateProblem() {
        TestdataStringLengthShadowSolution planningProblem = new TestdataStringLengthShadowSolution();
        TestdataStringLengthShadowEntity firstEntity = new TestdataStringLengthShadowEntity();
        firstEntity.setValueList(List.of("ccc"));
        TestdataStringLengthShadowEntity secondEntity = new TestdataStringLengthShadowEntity();
        secondEntity.setValueList(List.of("ccc"));
        planningProblem.setEntityList(Arrays.asList(firstEntity, secondEntity));
        planningProblem.setValueList(Arrays.asList("a", "bb"));
        return planningProblem;
    }

    @POST
    @Path(value="/solver-factory")
    @Produces(value={"text/plain"})
    public String solveWithSolverFactory() {
        SolverJob solverJob = this.solverManager.solve((Object)1L, (Object)TimefoldTestResource.generateProblem());
        try {
            return ((TestdataStringLengthShadowSolution)solverJob.getFinalBestSolution()).getScore().toString();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Solving was interrupted.", e);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Solving failed.", e);
        }
    }

    @GET
    @Path(value="/solver-factory/override")
    @Produces(value={"text/plain"})
    public String solveWithOverriddenTime(@QueryParam(value="seconds") Integer seconds) {
        SolverJobBuilder solverJobBuilder = this.solverManager.solveBuilder().withProblemId((Object)1L).withProblem((Object)TimefoldTestResource.generateProblem()).withConfigOverride(new SolverConfigOverride().withTerminationConfig(new TerminationConfig().withSpentLimit(Duration.ofSeconds(seconds.intValue()))));
        DefaultSolverJob solverJob = (DefaultSolverJob)solverJobBuilder.run();
        SolverScope<TestdataStringLengthShadowSolution> customScope = new SolverScope<TestdataStringLengthShadowSolution>(){

            public long calculateTimeMillisSpentUpToNow() {
                return 5000L;
            }
        };
        customScope.setStartingInitializedScore((Score)HardSoftScore.of((int)-1, (int)-1));
        customScope.setInitializedBestScore((Score)HardSoftScore.of((int)-1, (int)-1));
        try {
            String score = ((TestdataStringLengthShadowSolution)solverJob.getFinalBestSolution()).getScore().toString();
            DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance();
            decimalFormatSymbols.setDecimalSeparator('.');
            DecimalFormat decimalFormat = new DecimalFormat("0.00", decimalFormatSymbols);
            double gradientTime = solverJob.getSolverTermination().calculateSolverTimeGradient((SolverScope)customScope);
            this.solverManager.terminateEarly((Object)1L);
            return String.format("%s,%s", score, decimalFormat.format(gradientTime));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Solving was interrupted.", e);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Solving failed.", e);
        }
    }
}

