/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.python.score;

import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.types.PythonJavaTypeMapping;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.numeric.PythonDecimal;
import ai.timefold.solver.core.api.score.buildin.hardmediumsoftbigdecimal.HardMediumSoftBigDecimalScore;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;

public final class HardMediumSoftDecimalScorePythonJavaTypeMapping
implements PythonJavaTypeMapping<PythonLikeObject, HardMediumSoftBigDecimalScore> {
    private final PythonLikeType type;
    private final Constructor<?> constructor;
    private final Field hardScoreField;
    private final Field mediumScoreField;
    private final Field softScoreField;

    public HardMediumSoftDecimalScorePythonJavaTypeMapping(PythonLikeType type) throws ClassNotFoundException, NoSuchFieldException, NoSuchMethodException {
        this.type = type;
        Class clazz = type.getJavaClass();
        this.constructor = clazz.getConstructor(new Class[0]);
        this.hardScoreField = clazz.getField("hard_score");
        this.mediumScoreField = clazz.getField("medium_score");
        this.softScoreField = clazz.getField("soft_score");
    }

    public PythonLikeType getPythonType() {
        return this.type;
    }

    public Class<? extends HardMediumSoftBigDecimalScore> getJavaType() {
        return HardMediumSoftBigDecimalScore.class;
    }

    public PythonLikeObject toPythonObject(HardMediumSoftBigDecimalScore javaObject) {
        try {
            Object instance = this.constructor.newInstance(new Object[0]);
            this.hardScoreField.set(instance, new PythonDecimal(javaObject.hardScore()));
            this.mediumScoreField.set(instance, new PythonDecimal(javaObject.mediumScore()));
            this.softScoreField.set(instance, new PythonDecimal(javaObject.softScore()));
            return (PythonLikeObject)instance;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public HardMediumSoftBigDecimalScore toJavaObject(PythonLikeObject pythonObject) {
        try {
            BigDecimal hardScore = ((PythonDecimal)this.hardScoreField.get((Object)pythonObject)).value;
            BigDecimal mediumScore = ((PythonDecimal)this.mediumScoreField.get((Object)pythonObject)).value;
            BigDecimal softScore = ((PythonDecimal)this.softScoreField.get((Object)pythonObject)).value;
            return HardMediumSoftBigDecimalScore.of((BigDecimal)hardScore, (BigDecimal)mediumScore, (BigDecimal)softScore);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }
}

