/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.python.score;

import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.types.PythonJavaTypeMapping;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.numeric.PythonDecimal;
import ai.timefold.solver.core.api.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScore;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;

public final class HardSoftDecimalScorePythonJavaTypeMapping
implements PythonJavaTypeMapping<PythonLikeObject, HardSoftBigDecimalScore> {
    private final PythonLikeType type;
    private final Constructor<?> constructor;
    private final Field hardScoreField;
    private final Field softScoreField;

    public HardSoftDecimalScorePythonJavaTypeMapping(PythonLikeType type) throws ClassNotFoundException, NoSuchFieldException, NoSuchMethodException {
        this.type = type;
        Class clazz = type.getJavaClass();
        this.constructor = clazz.getConstructor(new Class[0]);
        this.hardScoreField = clazz.getField("hard_score");
        this.softScoreField = clazz.getField("soft_score");
    }

    public PythonLikeType getPythonType() {
        return this.type;
    }

    public Class<? extends HardSoftBigDecimalScore> getJavaType() {
        return HardSoftBigDecimalScore.class;
    }

    public PythonLikeObject toPythonObject(HardSoftBigDecimalScore javaObject) {
        try {
            Object instance = this.constructor.newInstance(new Object[0]);
            this.hardScoreField.set(instance, new PythonDecimal(javaObject.hardScore()));
            this.softScoreField.set(instance, new PythonDecimal(javaObject.softScore()));
            return (PythonLikeObject)instance;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public HardSoftBigDecimalScore toJavaObject(PythonLikeObject pythonObject) {
        try {
            BigDecimal hardScore = ((PythonDecimal)this.hardScoreField.get((Object)pythonObject)).value;
            BigDecimal softScore = ((PythonDecimal)this.softScoreField.get((Object)pythonObject)).value;
            return HardSoftBigDecimalScore.of((BigDecimal)hardScore, (BigDecimal)softScore);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }
}

