/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.python;

import ai.timefold.jpyinterpreter.types.numeric.PythonBoolean;
import ai.timefold.jpyinterpreter.types.numeric.PythonFloat;
import ai.timefold.jpyinterpreter.types.numeric.PythonInteger;
import ai.timefold.solver.core.api.domain.valuerange.CountableValueRange;
import ai.timefold.solver.core.api.domain.valuerange.ValueRangeFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Random;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;

public class PythonValueRangeFactory {
    private PythonValueRangeFactory() {
    }

    public static CountableValueRange<PythonInteger> createIntValueRange(BigInteger from, BigInteger to) {
        return new ValueRangeMapper<BigInteger, PythonInteger>(ValueRangeFactory.createBigIntegerValueRange((BigInteger)from, (BigInteger)to), PythonInteger::valueOf, pythonInteger -> pythonInteger.value);
    }

    public static CountableValueRange<PythonInteger> createIntValueRange(BigInteger from, BigInteger to, BigInteger step) {
        return new ValueRangeMapper<BigInteger, PythonInteger>(ValueRangeFactory.createBigIntegerValueRange((BigInteger)from, (BigInteger)to, (BigInteger)step), PythonInteger::valueOf, pythonInteger -> pythonInteger.value);
    }

    public static CountableValueRange<PythonFloat> createFloatValueRange(BigDecimal from, BigDecimal to) {
        return new ValueRangeMapper<BigDecimal, PythonFloat>(ValueRangeFactory.createBigDecimalValueRange((BigDecimal)from, (BigDecimal)to), decimal -> PythonFloat.valueOf((double)decimal.doubleValue()), pythonFloat -> BigDecimal.valueOf(pythonFloat.value));
    }

    public static CountableValueRange<PythonFloat> createFloatValueRange(BigDecimal from, BigDecimal to, BigDecimal step) {
        return new ValueRangeMapper<BigDecimal, PythonFloat>(ValueRangeFactory.createBigDecimalValueRange((BigDecimal)from, (BigDecimal)to, (BigDecimal)step), decimal -> PythonFloat.valueOf((double)decimal.doubleValue()), pythonFloat -> BigDecimal.valueOf(pythonFloat.value));
    }

    public static CountableValueRange<PythonBoolean> createBooleanValueRange() {
        return new ValueRangeMapper<Boolean, PythonBoolean>(ValueRangeFactory.createBooleanValueRange(), PythonBoolean::valueOf, PythonBoolean::getBooleanValue);
    }

    private record ValueRangeMapper<From_, To_>(CountableValueRange<From_> sourceValueRange, Function<From_, To_> valueConvertor, Function<To_, From_> inverseValueConvertor) implements CountableValueRange<To_>
    {
        public long getSize() {
            return this.sourceValueRange.getSize();
        }

        public To_ get(long index) {
            return this.valueConvertor.apply(this.sourceValueRange.get(index));
        }

        public @NonNull Iterator<To_> createOriginalIterator() {
            return new IteratorMapper<From_, To_>(this.sourceValueRange.createOriginalIterator(), this.valueConvertor);
        }

        public boolean isEmpty() {
            return this.sourceValueRange.isEmpty();
        }

        public boolean contains(To_ value) {
            return this.sourceValueRange.contains(this.inverseValueConvertor.apply(value));
        }

        public @NonNull Iterator<To_> createRandomIterator(@NonNull Random random) {
            return new IteratorMapper<From_, To_>(this.sourceValueRange.createRandomIterator(random), this.valueConvertor);
        }
    }

    private record IteratorMapper<From_, To_>(Iterator<From_> sourceIterator, Function<From_, To_> valueConvertor) implements Iterator<To_>
    {
        @Override
        public boolean hasNext() {
            return this.sourceIterator.hasNext();
        }

        @Override
        public To_ next() {
            return this.valueConvertor.apply(this.sourceIterator.next());
        }
    }
}

