/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.python;

import ai.timefold.jpyinterpreter.PythonBytecodeToJavaBytecodeTranslator;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.solver.core.api.domain.variable.VariableListener;
import ai.timefold.solver.core.api.score.calculator.ConstraintMatchAwareIncrementalScoreCalculator;
import ai.timefold.solver.core.api.score.calculator.EasyScoreCalculator;
import ai.timefold.solver.core.api.score.calculator.IncrementalScoreCalculator;
import ai.timefold.solver.core.api.score.stream.ConstraintProvider;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class PythonWrapperGenerator {
    public static ClassLoader getClassLoaderForAliasMap(final Map<String, Class<?>> aliasMap) {
        return new ClassLoader(){

            @Override
            public String getName() {
                return "Timefold Alias Map ClassLoader";
            }

            @Override
            public Class<?> findClass(String name) throws ClassNotFoundException {
                if (aliasMap.containsKey(name)) {
                    return (Class)aliasMap.get(name);
                }
                return BuiltinTypes.asmClassLoader.loadClass(name);
            }
        };
    }

    private static ClassOutput getClassOutput(AtomicReference<byte[]> bytesReference) {
        return (path, byteCode) -> bytesReference.set(byteCode);
    }

    public static <A> Class<? extends A> defineWrapperFunction(String className, Class<A> baseInterface, Object delegate) {
        FieldDescriptor delegateField;
        Method[] interfaceMethods = baseInterface.getMethods();
        if (interfaceMethods.length != 1) {
            throw new IllegalArgumentException("Can only call this function for functional interfaces (only 1 method)");
        }
        if (BuiltinTypes.classNameToBytecode.containsKey(className)) {
            try {
                return BuiltinTypes.asmClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Impossible State: the class (" + className + ") should exists since it was created");
            }
        }
        AtomicReference<byte[]> classBytecodeHolder = new AtomicReference<byte[]>();
        ClassOutput classOutput = PythonWrapperGenerator.getClassOutput(classBytecodeHolder);
        try (ClassCreator classCreator = ClassCreator.builder().className(className).interfaces(new Class[]{baseInterface}).classOutput(classOutput).build();){
            delegateField = ((FieldCreator)classCreator.getFieldCreator("delegate", baseInterface).setModifiers(9)).getFieldDescriptor();
            MethodCreator methodCreator = classCreator.getMethodCreator(MethodDescriptor.ofMethod((Method)interfaceMethods[0]));
            ResultHandle pythonProxy = methodCreator.readStaticField(delegateField);
            ResultHandle[] args = new ResultHandle[interfaceMethods[0].getParameterCount()];
            for (int i = 0; i < args.length; ++i) {
                args[i] = methodCreator.getMethodParam(i);
            }
            ResultHandle constraints = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod((Method)interfaceMethods[0]), pythonProxy, args);
            methodCreator.returnValue(constraints);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        PythonBytecodeToJavaBytecodeTranslator.writeClassOutput((Map)BuiltinTypes.classNameToBytecode, (String)className, (byte[])classBytecodeHolder.get());
        try {
            Class<?> out = BuiltinTypes.asmClassLoader.loadClass(className);
            out.getField(delegateField.getName()).set(null, delegate);
            return out;
        }
        catch (Exception e) {
            throw new IllegalStateException("Impossible State: the class (" + className + ") should exists since it was just created");
        }
    }

    public static <A> Class<? extends A> defineWrapperClass(String className, Class<? extends A> baseInterface, Supplier<? extends A> delegateSupplier) {
        FieldDescriptor supplierField;
        Method[] interfaceMethods = baseInterface.getMethods();
        if (BuiltinTypes.classNameToBytecode.containsKey(className)) {
            try {
                return BuiltinTypes.asmClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Impossible State: the class (" + className + ") should exists since it was created");
            }
        }
        AtomicReference<byte[]> classBytecodeHolder = new AtomicReference<byte[]>();
        ClassOutput classOutput = PythonWrapperGenerator.getClassOutput(classBytecodeHolder);
        try (ClassCreator classCreator = ClassCreator.builder().className(className).interfaces(new Class[]{baseInterface}).classOutput(classOutput).build();){
            supplierField = ((FieldCreator)classCreator.getFieldCreator("delegateSupplier", Supplier.class).setModifiers(9)).getFieldDescriptor();
            FieldDescriptor delegateField = ((FieldCreator)classCreator.getFieldCreator("delegate", baseInterface).setModifiers(17)).getFieldDescriptor();
            MethodCreator constructorCreator = classCreator.getMethodCreator(MethodDescriptor.ofConstructor((String)classCreator.getClassName(), (String[])new String[0]));
            constructorCreator.invokeSpecialMethod(MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]), constructorCreator.getThis(), new ResultHandle[0]);
            constructorCreator.writeInstanceField(delegateField, constructorCreator.getThis(), constructorCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Supplier.class, (String)"get", Object.class, (Class[])new Class[0]), constructorCreator.readStaticField(supplierField), new ResultHandle[0]));
            constructorCreator.returnValue(constructorCreator.getThis());
            for (Method method : interfaceMethods) {
                MethodCreator methodCreator = classCreator.getMethodCreator(MethodDescriptor.ofMethod((Method)method));
                ResultHandle pythonProxy = methodCreator.readInstanceField(delegateField, methodCreator.getThis());
                ResultHandle[] args = new ResultHandle[method.getParameterCount()];
                for (int i = 0; i < args.length; ++i) {
                    args[i] = methodCreator.getMethodParam(i);
                }
                ResultHandle result = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod((Method)method), pythonProxy, args);
                methodCreator.returnValue(result);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        PythonBytecodeToJavaBytecodeTranslator.writeClassOutput((Map)BuiltinTypes.classNameToBytecode, (String)className, (byte[])classBytecodeHolder.get());
        try {
            Class<?> out = BuiltinTypes.asmClassLoader.loadClass(className);
            out.getField(supplierField.getName()).set(null, delegateSupplier);
            return out;
        }
        catch (Exception e) {
            throw new IllegalStateException("Impossible State: the class (" + className + ") should exists since it was just created");
        }
    }

    public static Class<?> defineConstraintProviderClass(String className, ConstraintProvider defineConstraintsImpl) {
        return PythonWrapperGenerator.defineWrapperFunction(className, ConstraintProvider.class, defineConstraintsImpl);
    }

    public static Class<?> defineEasyScoreCalculatorClass(String className, EasyScoreCalculator easyScoreCalculatorImpl) {
        return PythonWrapperGenerator.defineWrapperFunction(className, EasyScoreCalculator.class, easyScoreCalculatorImpl);
    }

    public static Class<?> defineIncrementalScoreCalculatorClass(String className, Supplier<? extends IncrementalScoreCalculator> incrementalScoreCalculatorSupplier, boolean constraintMatchAware) {
        if (constraintMatchAware) {
            return PythonWrapperGenerator.defineWrapperClass(className, ConstraintMatchAwareIncrementalScoreCalculator.class, incrementalScoreCalculatorSupplier);
        }
        return PythonWrapperGenerator.defineWrapperClass(className, IncrementalScoreCalculator.class, incrementalScoreCalculatorSupplier);
    }

    public static Class<?> defineVariableListenerClass(String className, Supplier<? extends VariableListener> variableListenerSupplier) {
        return PythonWrapperGenerator.defineWrapperClass(className, VariableListener.class, variableListenerSupplier);
    }
}

