/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.migration.v8;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public final class ScoreGettersRecipe
extends Recipe {
    private static final MatcherMeta[] MATCHER_METAS = new MatcherMeta[]{new MatcherMeta("IBendableScore", "getHardLevelsSize()"), new MatcherMeta("IBendableScore", "getSoftLevelsSize()"), new MatcherMeta("IBendableScore", "getLevelsSize()"), new MatcherMeta("Score", "getInitScore()"), new MatcherMeta("BendableScore", "getHardScores()"), new MatcherMeta("BendableScore", "getHardScore(int)"), new MatcherMeta("BendableScore", "getSoftScores()"), new MatcherMeta("BendableScore", "getSoftScore(int)"), new MatcherMeta("BendableBigDecimalScore", "getHardScores()"), new MatcherMeta("BendableBigDecimalScore", "getHardScore(int)"), new MatcherMeta("BendableBigDecimalScore", "getSoftScores()"), new MatcherMeta("BendableBigDecimalScore", "getSoftScore(int)"), new MatcherMeta("BendableLongScore", "getHardScores()"), new MatcherMeta("BendableLongScore", "getHardScore(int)"), new MatcherMeta("BendableLongScore", "getSoftScores()"), new MatcherMeta("BendableLongScore", "getSoftScore(int)"), new MatcherMeta("HardMediumSoftScore", "getHardScore()"), new MatcherMeta("HardMediumSoftScore", "getMediumScore()"), new MatcherMeta("HardMediumSoftScore", "getSoftScore()"), new MatcherMeta("HardMediumSoftBigDecimalScore", "getHardScore()"), new MatcherMeta("HardMediumSoftBigDecimalScore", "getMediumScore()"), new MatcherMeta("HardMediumSoftBigDecimalScore", "getSoftScore()"), new MatcherMeta("HardMediumSoftLongScore", "getHardScore()"), new MatcherMeta("HardMediumSoftLongScore", "getMediumScore()"), new MatcherMeta("HardMediumSoftLongScore", "getSoftScore()"), new MatcherMeta("HardSoftScore", "getHardScore()"), new MatcherMeta("HardSoftScore", "getSoftScore()"), new MatcherMeta("HardSoftBigDecimalScore", "getHardScore()"), new MatcherMeta("HardSoftBigDecimalScore", "getSoftScore()"), new MatcherMeta("HardSoftLongScore", "getHardScore()"), new MatcherMeta("HardSoftLongScore", "getSoftScore()"), new MatcherMeta("SimpleScore", "getScore()"), new MatcherMeta("SimpleBigDecimalScore", "getScore()"), new MatcherMeta("SimpleLongScore", "getScore()")};

    public String getDisplayName() {
        return "Score: use shorter getters";
    }

    public String getDescription() {
        return "Use `score()` instead of `getScore()` on `Score` implementations.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor[] visitors = (TreeVisitor[])Arrays.stream(MATCHER_METAS).map(m -> new UsesMethod(m.methodMatcher)).toArray(TreeVisitor[]::new);
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])visitors), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public Expression visitExpression(Expression expression, ExecutionContext executionContext) {
                Expression e = super.visitExpression(expression, (Object)executionContext);
                MatcherMeta matcherMeta = Arrays.stream(MATCHER_METAS).filter(m -> m.methodMatcher.matches(e)).findFirst().orElse(null);
                if (matcherMeta == null) {
                    return e;
                }
                J.MethodInvocation mi = (J.MethodInvocation)e;
                Expression select = mi.getSelect();
                List arguments = mi.getArguments();
                String score = "#{any(" + matcherMeta.scoreClassFqn + ")}";
                String getterWithoutGet = matcherMeta.methodName.substring(3, 4).toLowerCase() + matcherMeta.methodName.substring(4);
                Object pattern = score + "." + getterWithoutGet;
                if (getterWithoutGet.contains("(int)")) {
                    pattern = ((String)pattern).replace("(int)", "(#{any(int)})");
                    return (Expression)JavaTemplate.builder((String)pattern).javaParser(ScoreGettersRecipe.buildJavaParser()).build().apply(this.getCursor(), e.getCoordinates().replace(), new Object[]{select, arguments.get(0)});
                }
                return (Expression)JavaTemplate.builder((String)pattern).javaParser(ScoreGettersRecipe.buildJavaParser()).build().apply(this.getCursor(), e.getCoordinates().replace(), new Object[]{select});
            }
        });
    }

    public static JavaParser.Builder buildJavaParser() {
        return JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath());
    }

    private static final class MatcherMeta {
        public final String scoreClassFqn;
        public final MethodMatcher methodMatcher;
        public final String methodName;

        public MatcherMeta(String select, String method) {
            this.scoreClassFqn = switch (select) {
                case "Score", "IBendableScore" -> "ai.timefold.solver.core.api.score." + select;
                default -> "ai.timefold.solver.core.api.score.buildin." + select.toLowerCase().replace("score", "") + "." + select;
            };
            this.methodMatcher = new MethodMatcher(this.scoreClassFqn + " " + method);
            this.methodName = method;
        }
    }
}

