/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.jaxb.impl.domain.solution;

import ai.timefold.solver.persistence.common.api.domain.solution.SolutionFileIO;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;

public class JaxbSolutionFileIO<Solution_>
implements SolutionFileIO<Solution_> {
    private final Marshaller marshaller;
    private final Unmarshaller unmarshaller;

    public JaxbSolutionFileIO(Class ... jaxbAnnotatedClasses) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])jaxbAnnotatedClasses);
            this.marshaller = jaxbContext.createMarshaller();
            this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
            this.unmarshaller = jaxbContext.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("JAXB creation for classes (" + Arrays.toString(jaxbAnnotatedClasses) + ") has failed.", e);
        }
    }

    public String getInputFileExtension() {
        return "xml";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Solution_ read(File inputSolutionFile) {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(inputSolutionFile), "UTF-8");){
            Object object = this.unmarshaller.unmarshal((Reader)reader);
            return (Solution_)object;
        }
        catch (JAXBException | IOException e) {
            throw new IllegalArgumentException("Failed reading inputSolutionFile (" + String.valueOf(inputSolutionFile) + ").", e);
        }
    }

    public void write(Solution_ solution, File outputSolutionFile) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputSolutionFile), "UTF-8");){
            this.marshaller.marshal(solution, (Writer)writer);
        }
        catch (JAXBException | IOException e) {
            throw new IllegalArgumentException("Failed writing outputSolutionFile (" + String.valueOf(outputSolutionFile) + ").", e);
        }
    }
}

