/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.preview.api.domain.metamodel;

import ai.timefold.solver.core.preview.api.domain.metamodel.GenuineVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningListVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningSolutionMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.ShadowVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.VariableMetaModel;
import java.util.List;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface PlanningEntityMetaModel<Solution_, Entity_> {
    public PlanningSolutionMetaModel<Solution_> solution();

    public Class<Entity_> type();

    public List<VariableMetaModel<Solution_, Entity_, ?>> variables();

    default public List<GenuineVariableMetaModel<Solution_, Entity_, ?>> genuineVariables() {
        return this.variables().stream().filter(v -> v instanceof GenuineVariableMetaModel).map(v -> (GenuineVariableMetaModel)v).toList();
    }

    default public <Value_> GenuineVariableMetaModel<Solution_, Entity_, Value_> genuineVariable() {
        List<GenuineVariableMetaModel<Solution_, Entity_, ?>> genuineVariables = this.genuineVariables();
        switch (genuineVariables.size()) {
            case 0: {
                throw new IllegalStateException("The entity class (%s) has no genuine variables.".formatted(this.type().getCanonicalName()));
            }
            case 1: {
                break;
            }
            default: {
                throw new IllegalStateException("The entity class (%s) has multiple genuine variables (%s).".formatted(this.type().getCanonicalName(), genuineVariables));
            }
        }
        return genuineVariables.get(0);
    }

    default public <Value_> GenuineVariableMetaModel<Solution_, Entity_, Value_> genuineVariable(String variableName) {
        VariableMetaModel<Solution_, Entity_, Value_> variable = this.variable(variableName);
        if (!(variable instanceof GenuineVariableMetaModel)) {
            throw new IllegalArgumentException("The variableName (%s) exists among variables (%s) but is not genuine.".formatted(variableName, this.variables()));
        }
        GenuineVariableMetaModel genuineVariable = (GenuineVariableMetaModel)variable;
        return genuineVariable;
    }

    default public <Value_> GenuineVariableMetaModel<Solution_, Entity_, Value_> genuineVariable(String variableName, Class<Value_> variableClass) {
        VariableMetaModel<Solution_, Entity_, Value_> variable = this.variable(variableName, variableClass);
        if (!(variable instanceof GenuineVariableMetaModel)) {
            throw new IllegalArgumentException("The variableName (%s) exists among variables (%s) but is not genuine.".formatted(variableName, this.variables()));
        }
        GenuineVariableMetaModel genuineVariable = (GenuineVariableMetaModel)variable;
        return genuineVariable;
    }

    default public <Value_> VariableMetaModel<Solution_, Entity_, Value_> variable(String variableName) {
        for (VariableMetaModel<Solution_, Entity_, ?> variableMetaModel : this.variables()) {
            if (!variableMetaModel.name().equals(variableName)) continue;
            return variableMetaModel;
        }
        throw new IllegalArgumentException("The variableName (%s) does not exist in the variables (%s).".formatted(variableName, this.variables()));
    }

    default public <Value_> VariableMetaModel<Solution_, Entity_, Value_> variable(String variableName, Class<Value_> variableClass) {
        for (VariableMetaModel<Solution_, Entity_, ?> variableMetaModel : this.variables()) {
            if (!variableMetaModel.name().equals(variableName)) continue;
            if (!variableClass.isAssignableFrom(variableMetaModel.type())) {
                throw new IllegalArgumentException("The variableName (%s) exists among variables (%s) but is not of type (%s).".formatted(variableName, this.variables(), variableClass.getCanonicalName()));
            }
            return variableMetaModel;
        }
        throw new IllegalArgumentException("The variableName (%s) does not exist in the variables (%s).".formatted(variableName, this.variables()));
    }

    default public boolean hasVariable(String variableName) {
        for (VariableMetaModel<Solution_, Entity_, ?> variableMetaModel : this.variables()) {
            if (!variableMetaModel.name().equals(variableName)) continue;
            return true;
        }
        return false;
    }

    default public <Value_> PlanningVariableMetaModel<Solution_, Entity_, Value_> basicVariable() {
        return (PlanningVariableMetaModel)this.genuineVariable();
    }

    default public <Value_> PlanningVariableMetaModel<Solution_, Entity_, Value_> basicVariable(String variableName) {
        return (PlanningVariableMetaModel)this.variable(variableName);
    }

    default public <Value_> PlanningVariableMetaModel<Solution_, Entity_, Value_> basicVariable(String variableName, Class<Value_> variableClass) {
        return (PlanningVariableMetaModel)this.variable(variableName, variableClass);
    }

    default public <Value_> PlanningListVariableMetaModel<Solution_, Entity_, Value_> listVariable() {
        return (PlanningListVariableMetaModel)this.genuineVariable();
    }

    default public <Value_> PlanningListVariableMetaModel<Solution_, Entity_, Value_> listVariable(String variableName) {
        return (PlanningListVariableMetaModel)this.variable(variableName);
    }

    default public <Value_> PlanningListVariableMetaModel<Solution_, Entity_, Value_> listVariable(String variableName, Class<Value_> variableClass) {
        return (PlanningListVariableMetaModel)this.variable(variableName, variableClass);
    }

    default public <Value_> ShadowVariableMetaModel<Solution_, Entity_, Value_> shadowVariable(String variableName) {
        return (ShadowVariableMetaModel)this.variable(variableName);
    }

    default public <Value_> ShadowVariableMetaModel<Solution_, Entity_, Value_> shadowVariable(String variableName, Class<Value_> variableClass) {
        return (ShadowVariableMetaModel)this.variable(variableName, variableClass);
    }

    default public boolean isGenuine() {
        for (VariableMetaModel<Solution_, Entity_, ?> variableMetaModel : this.variables()) {
            if (!(variableMetaModel instanceof GenuineVariableMetaModel)) continue;
            return true;
        }
        return false;
    }
}

