/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.util;

import java.util.Arrays;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class DynamicLinearProbeNonNegativeIntCounter {
    private static final int MISSING = -1;
    private @Nullable int[] keys = null;
    private @Nullable int[] counts = null;

    int capacity() {
        if (this.keys == null) {
            return 0;
        }
        return this.keys.length;
    }

    private int getEntryIndex(int key) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] != key) continue;
            return i;
        }
        return -1;
    }

    private void createEntry(int key) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] != -1) continue;
            this.keys[i] = key;
            this.counts[i] = 1;
            return;
        }
        int keyIndex = this.keys.length;
        int newSize = keyIndex + 1;
        this.keys = Arrays.copyOf(this.keys, newSize);
        this.counts = Arrays.copyOf(this.counts, newSize);
        this.keys[keyIndex] = key;
        this.counts[keyIndex] = 1;
    }

    public int getCount(int key) {
        if (this.keys == null) {
            return 0;
        }
        int index = this.getEntryIndex(key);
        if (index == -1) {
            return 0;
        }
        return this.counts[index];
    }

    public void increment(int key) {
        if (this.keys == null) {
            this.keys = new int[]{key};
            this.counts = new int[]{1};
            return;
        }
        int index = this.getEntryIndex(key);
        if (index == -1) {
            this.createEntry(key);
        } else {
            int n = index;
            this.counts[n] = this.counts[n] + 1;
        }
    }

    public void decrement(int key) {
        if (this.keys == null) {
            throw new IllegalArgumentException("key %d is not in the map %s".formatted(key, this));
        }
        int index = this.getEntryIndex(key);
        if (index == -1) {
            throw new IllegalArgumentException("key %d is not in the map %s".formatted(key, this));
        }
        int n = index;
        this.counts[n] = this.counts[n] - 1;
        int newCount = this.counts[n];
        if (newCount == 0) {
            this.keys[index] = -1;
        }
    }

    public String toString() {
        if (this.keys == null) {
            return "{}";
        }
        StringBuilder out = new StringBuilder();
        boolean isFirst = true;
        out.append("{");
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == -1) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                out.append(", ");
            }
            out.append(this.keys[i]).append(": ").append(this.counts[i]);
        }
        out.append("}");
        return out.toString();
    }
}

