/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.util;

import ai.timefold.solver.core.api.function.QuadFunction;
import ai.timefold.solver.core.api.function.ToIntQuadFunction;
import ai.timefold.solver.core.api.function.ToIntTriFunction;
import ai.timefold.solver.core.api.function.ToLongQuadFunction;
import ai.timefold.solver.core.api.function.ToLongTriFunction;
import ai.timefold.solver.core.api.function.TriFunction;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongBiFunction;
import java.util.function.ToLongFunction;

public final class ConstantLambdaUtils {
    private static final Runnable NO_OP = () -> {};
    private static final Function IDENTITY = Function.identity();
    private static final BiPredicate NOT_EQUALS = (a, b) -> !Objects.equals(a, b);
    private static final BiFunction BI_PICK_FIRST = (a, b) -> a;
    private static final TriFunction TRI_PICK_FIRST = (a, b, c) -> a;
    private static final QuadFunction QUAD_PICK_FIRST = (a, b, c, d) -> a;
    private static final BiFunction BI_PICK_SECOND = (a, b) -> b;
    private static final TriFunction TRI_PICK_SECOND = (a, b, c) -> b;
    private static final QuadFunction QUAD_PICK_SECOND = (a, b, c, d) -> b;
    private static final TriFunction TRI_PICK_THIRD = (a, b, c) -> c;
    private static final QuadFunction QUAD_PICK_THIRD = (a, b, c, d) -> c;
    private static final QuadFunction QUAD_PICK_FOURTH = (a, b, c, d) -> d;
    private static final Function UNI_CONSTANT_NULL = a -> null;
    private static final ToLongFunction UNI_CONSTANT_ZERO_LONG = a -> 0L;
    private static final ToIntFunction UNI_CONSTANT_ONE = a -> 1;
    private static final ToLongFunction UNI_CONSTANT_ONE_LONG = a -> 1L;
    private static final Function UNI_CONSTANT_ONE_BIG_DECIMAL = a -> BigDecimal.ONE;
    private static final BiFunction BI_CONSTANT_NULL = (a, b) -> null;
    private static final ToLongBiFunction BI_CONSTANT_ZERO_LONG = (a, b) -> 0L;
    private static final ToIntBiFunction BI_CONSTANT_ONE = (a, b) -> 1;
    private static final ToLongBiFunction BI_CONSTANT_ONE_LONG = (a, b) -> 1L;
    private static final BiFunction BI_CONSTANT_ONE_BIG_DECIMAL = (a, b) -> BigDecimal.ONE;
    private static final TriFunction TRI_CONSTANT_NULL = (a, b, c) -> null;
    private static final ToLongTriFunction TRI_CONSTANT_ZERO_LONG = (a, b, c) -> 0L;
    private static final ToIntTriFunction TRI_CONSTANT_ONE = (a, b, c) -> 1;
    private static final ToLongTriFunction TRI_CONSTANT_ONE_LONG = (a, b, c) -> 1L;
    private static final TriFunction TRI_CONSTANT_ONE_BIG_DECIMAL = (a, b, c) -> BigDecimal.ONE;
    private static final ToLongQuadFunction QUAD_CONSTANT_ZERO_LONG = (a, b, c, d) -> 0L;
    private static final ToIntQuadFunction QUAD_CONSTANT_ONE = (a, b, c, d) -> 1;
    private static final ToLongQuadFunction QUAD_CONSTANT_ONE_LONG = (a, b, c, d) -> 1L;
    private static final QuadFunction QUAD_CONSTANT_ONE_BIG_DECiMAL = (a, b, c, d) -> BigDecimal.ONE;

    public static <T, R> Function<T, R> uncheck(ThrowableFunction<T, R> function) {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static Runnable noop() {
        return NO_OP;
    }

    public static <A> Function<A, A> identity() {
        return IDENTITY;
    }

    public static <A> BiPredicate<A, A> notEquals() {
        return NOT_EQUALS;
    }

    public static <A, B> BiFunction<A, B, A> biPickFirst() {
        return BI_PICK_FIRST;
    }

    public static <A, B, C> TriFunction<A, B, C, A> triPickFirst() {
        return TRI_PICK_FIRST;
    }

    public static <A, B, C, D> QuadFunction<A, B, C, D, A> quadPickFirst() {
        return QUAD_PICK_FIRST;
    }

    public static <A, B> BiFunction<A, B, B> biPickSecond() {
        return BI_PICK_SECOND;
    }

    public static <A, B, C> TriFunction<A, B, C, B> triPickSecond() {
        return TRI_PICK_SECOND;
    }

    public static <A, B, C, D> QuadFunction<A, B, C, D, B> quadPickSecond() {
        return QUAD_PICK_SECOND;
    }

    public static <A, B, C> TriFunction<A, B, C, C> triPickThird() {
        return TRI_PICK_THIRD;
    }

    public static <A, B, C, D> QuadFunction<A, B, C, D, C> quadPickThird() {
        return QUAD_PICK_THIRD;
    }

    public static <A, B, C, D> QuadFunction<A, B, C, D, D> quadPickFourth() {
        return QUAD_PICK_FOURTH;
    }

    public static <A, B> Function<A, B> uniConstantNull() {
        return UNI_CONSTANT_NULL;
    }

    public static <A> ToIntFunction<A> uniConstantOne() {
        return UNI_CONSTANT_ONE;
    }

    public static <A> ToLongFunction<A> uniConstantZeroLong() {
        return UNI_CONSTANT_ZERO_LONG;
    }

    public static <A> ToLongFunction<A> uniConstantOneLong() {
        return UNI_CONSTANT_ONE_LONG;
    }

    public static <A> Function<A, BigDecimal> uniConstantOneBigDecimal() {
        return UNI_CONSTANT_ONE_BIG_DECIMAL;
    }

    public static <A, B, C> BiFunction<A, B, C> biConstantNull() {
        return BI_CONSTANT_NULL;
    }

    public static <A, B> ToLongBiFunction<A, B> biConstantZeroLong() {
        return BI_CONSTANT_ZERO_LONG;
    }

    public static <A, B> ToIntBiFunction<A, B> biConstantOne() {
        return BI_CONSTANT_ONE;
    }

    public static <A, B> ToLongBiFunction<A, B> biConstantOneLong() {
        return BI_CONSTANT_ONE_LONG;
    }

    public static <A, B> BiFunction<A, B, BigDecimal> biConstantOneBigDecimal() {
        return BI_CONSTANT_ONE_BIG_DECIMAL;
    }

    public static <A, B, C, D> TriFunction<A, B, C, D> triConstantNull() {
        return TRI_CONSTANT_NULL;
    }

    public static <A, B, C> ToLongTriFunction<A, B, C> triConstantZeroLong() {
        return TRI_CONSTANT_ZERO_LONG;
    }

    public static <A, B, C> ToIntTriFunction<A, B, C> triConstantOne() {
        return TRI_CONSTANT_ONE;
    }

    public static <A, B, C> ToLongTriFunction<A, B, C> triConstantOneLong() {
        return TRI_CONSTANT_ONE_LONG;
    }

    public static <A, B, C> TriFunction<A, B, C, BigDecimal> triConstantOneBigDecimal() {
        return TRI_CONSTANT_ONE_BIG_DECIMAL;
    }

    public static <A, B, C, D> ToLongQuadFunction<A, B, C, D> quadConstantZeroLong() {
        return QUAD_CONSTANT_ZERO_LONG;
    }

    public static <A, B, C, D> ToIntQuadFunction<A, B, C, D> quadConstantOne() {
        return QUAD_CONSTANT_ONE;
    }

    public static <A, B, C, D> ToLongQuadFunction<A, B, C, D> quadConstantOneLong() {
        return QUAD_CONSTANT_ONE_LONG;
    }

    public static <A, B, C, D> QuadFunction<A, B, C, D, BigDecimal> quadConstantOneBigDecimal() {
        return QUAD_CONSTANT_ONE_BIG_DECiMAL;
    }

    private ConstantLambdaUtils() {
    }

    @FunctionalInterface
    public static interface ThrowableFunction<T, R> {
        public R apply(T var1) throws Throwable;
    }
}

