/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver;

import ai.timefold.solver.core.api.solver.SolverConfigOverride;
import ai.timefold.solver.core.api.solver.SolverJob;
import ai.timefold.solver.core.api.solver.SolverJobBuilder;
import ai.timefold.solver.core.api.solver.event.FinalBestSolutionEvent;
import ai.timefold.solver.core.api.solver.event.FirstInitializedSolutionEvent;
import ai.timefold.solver.core.api.solver.event.NewBestSolutionEvent;
import ai.timefold.solver.core.api.solver.event.SolverJobStartedEvent;
import ai.timefold.solver.core.impl.solver.DefaultSolverManager;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;

public final class DefaultSolverJobBuilder<Solution_, ProblemId_>
implements SolverJobBuilder<Solution_, ProblemId_> {
    private final DefaultSolverManager<Solution_, ProblemId_> solverManager;
    private ProblemId_ problemId;
    private Function<? super ProblemId_, ? extends Solution_> problemFinder;
    private Consumer<NewBestSolutionEvent<Solution_>> bestSolutionConsumer;
    private Consumer<FinalBestSolutionEvent<Solution_>> finalBestSolutionConsumer;
    private Consumer<FirstInitializedSolutionEvent<Solution_>> initializedSolutionConsumer;
    private Consumer<SolverJobStartedEvent<Solution_>> solverJobStartedConsumer;
    private BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler;
    private SolverConfigOverride<Solution_> solverConfigOverride;

    public DefaultSolverJobBuilder(DefaultSolverManager<Solution_, ProblemId_> solverManager) {
        this.solverManager = Objects.requireNonNull(solverManager, "The SolverManager (" + String.valueOf(solverManager) + ") cannot be null.");
    }

    @Override
    public @NonNull SolverJobBuilder<Solution_, ProblemId_> withProblemId(@NonNull ProblemId_ problemId) {
        this.problemId = Objects.requireNonNull(problemId, "Invalid problemId (null) given to SolverJobBuilder.");
        return this;
    }

    @Override
    public @NonNull SolverJobBuilder<Solution_, ProblemId_> withProblemFinder(@NonNull Function<? super ProblemId_, ? extends Solution_> problemFinder) {
        this.problemFinder = Objects.requireNonNull(problemFinder, "Invalid problemFinder (null) given to SolverJobBuilder.");
        return this;
    }

    @Override
    public @NonNull SolverJobBuilder<Solution_, ProblemId_> withBestSolutionEventConsumer(@NonNull Consumer<NewBestSolutionEvent<Solution_>> bestSolutionConsumer) {
        this.bestSolutionConsumer = Objects.requireNonNull(bestSolutionConsumer, "Invalid bestSolutionConsumer (null) given to SolverJobBuilder.");
        return this;
    }

    @Override
    public @NonNull SolverJobBuilder<Solution_, ProblemId_> withFinalBestSolutionEventConsumer(@NonNull Consumer<FinalBestSolutionEvent<Solution_>> finalBestSolutionConsumer) {
        this.finalBestSolutionConsumer = Objects.requireNonNull(finalBestSolutionConsumer, "Invalid finalBestSolutionConsumer (null) given to SolverJobBuilder.");
        return this;
    }

    @Override
    public @NonNull SolverJobBuilder<Solution_, ProblemId_> withFirstInitializedSolutionEventConsumer(@NonNull Consumer<FirstInitializedSolutionEvent<Solution_>> firstInitializedSolutionConsumer) {
        this.initializedSolutionConsumer = Objects.requireNonNull(firstInitializedSolutionConsumer, "Invalid initializedSolutionConsumer (null) given to SolverJobBuilder.");
        return this;
    }

    @Override
    public SolverJobBuilder<Solution_, ProblemId_> withSolverJobStartedEventConsumer(Consumer<SolverJobStartedEvent<Solution_>> solverJobStartedConsumer) {
        this.solverJobStartedConsumer = Objects.requireNonNull(solverJobStartedConsumer, "Invalid startSolverJobHandler (null) given to SolverJobBuilder.");
        return this;
    }

    @Override
    public @NonNull SolverJobBuilder<Solution_, ProblemId_> withExceptionHandler(@NonNull BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler) {
        this.exceptionHandler = Objects.requireNonNull(exceptionHandler, "Invalid exceptionHandler (null) given to SolverJobBuilder.");
        return this;
    }

    @Override
    public @NonNull SolverJobBuilder<Solution_, ProblemId_> withConfigOverride(@NonNull SolverConfigOverride<Solution_> solverConfigOverride) {
        this.solverConfigOverride = Objects.requireNonNull(solverConfigOverride, "Invalid solverConfigOverride (null) given to SolverJobBuilder.");
        return this;
    }

    @Override
    public @NonNull SolverJob<Solution_, ProblemId_> run() {
        if (this.solverConfigOverride == null) {
            this.solverConfigOverride = new SolverConfigOverride();
        }
        if (this.bestSolutionConsumer == null) {
            return this.solverManager.solve((ProblemId_)this.problemId, this.problemFinder, null, (Consumer<FinalBestSolutionEvent<? extends Solution_>>)this.finalBestSolutionConsumer, (Consumer<FirstInitializedSolutionEvent<? extends Solution_>>)this.initializedSolutionConsumer, (Consumer<SolverJobStartedEvent<? extends Solution_>>)this.solverJobStartedConsumer, (BiConsumer<? super ProblemId_, Throwable>)this.exceptionHandler, (SolverConfigOverride<? extends Solution_>)this.solverConfigOverride);
        }
        return this.solverManager.solveAndListen((ProblemId_)this.problemId, this.problemFinder, (Consumer<NewBestSolutionEvent<? extends Solution_>>)this.bestSolutionConsumer, (Consumer<FinalBestSolutionEvent<? extends Solution_>>)this.finalBestSolutionConsumer, (Consumer<FirstInitializedSolutionEvent<? extends Solution_>>)this.initializedSolutionConsumer, (Consumer<SolverJobStartedEvent<? extends Solution_>>)this.solverJobStartedConsumer, (BiConsumer<? super ProblemId_, Throwable>)this.exceptionHandler, (SolverConfigOverride<? extends Solution_>)this.solverConfigOverride);
    }
}

