/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.common.quad;

import ai.timefold.solver.core.api.function.PentaFunction;
import ai.timefold.solver.core.api.function.QuadFunction;
import ai.timefold.solver.core.api.function.ToIntQuadFunction;
import ai.timefold.solver.core.api.function.ToLongQuadFunction;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.api.score.stream.DefaultConstraintJustification;
import ai.timefold.solver.core.api.score.stream.penta.PentaJoiner;
import ai.timefold.solver.core.api.score.stream.quad.QuadConstraintBuilder;
import ai.timefold.solver.core.api.score.stream.quad.QuadConstraintStream;
import ai.timefold.solver.core.impl.score.stream.common.RetrievalSemantics;
import ai.timefold.solver.core.impl.score.stream.common.ScoreImpactType;
import ai.timefold.solver.core.impl.util.ConstantLambdaUtils;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import org.jspecify.annotations.NonNull;

public interface InnerQuadConstraintStream<A, B, C, D>
extends QuadConstraintStream<A, B, C, D> {
    public static <A, B, C, D> PentaFunction<A, B, C, D, Score<?>, DefaultConstraintJustification> createDefaultJustificationMapping() {
        return (a, b, c, d, score) -> DefaultConstraintJustification.of(score, a, b, c, d);
    }

    public static <A, B, C, D> QuadFunction<A, B, C, D, Collection<?>> createDefaultIndictedObjectsMapping() {
        return (xva$0, xva$1, xva$2, xva$3) -> Arrays.asList(xva$0, xva$1, xva$2, xva$3);
    }

    public RetrievalSemantics getRetrievalSemantics();

    public boolean guaranteesDistinct();

    @Override
    default public <E> @NonNull QuadConstraintStream<A, B, C, D> ifExists(@NonNull Class<E> otherClass, PentaJoiner<A, B, C, D, E> ... joiners) {
        return switch (this.getRetrievalSemantics()) {
            default -> throw new IncompatibleClassChangeError();
            case RetrievalSemantics.STANDARD -> this.ifExists(this.getConstraintFactory().forEach(otherClass), joiners);
            case RetrievalSemantics.PRECOMPUTE -> this.ifExists(this.getConstraintFactory().forEachUnfiltered(otherClass), joiners);
            case RetrievalSemantics.LEGACY -> this.ifExists(this.getConstraintFactory().fromUnfiltered(otherClass), joiners);
        };
    }

    @Override
    default public <E> @NonNull QuadConstraintStream<A, B, C, D> ifExistsIncludingUnassigned(@NonNull Class<E> otherClass, PentaJoiner<A, B, C, D, E> ... joiners) {
        return switch (this.getRetrievalSemantics()) {
            default -> throw new IncompatibleClassChangeError();
            case RetrievalSemantics.STANDARD -> this.ifExists(this.getConstraintFactory().forEachIncludingUnassigned(otherClass), joiners);
            case RetrievalSemantics.PRECOMPUTE -> this.ifExists(this.getConstraintFactory().forEachUnfiltered(otherClass), joiners);
            case RetrievalSemantics.LEGACY -> this.ifExists(this.getConstraintFactory().fromUnfiltered(otherClass), joiners);
        };
    }

    @Override
    default public <E> @NonNull QuadConstraintStream<A, B, C, D> ifNotExists(@NonNull Class<E> otherClass, PentaJoiner<A, B, C, D, E> ... joiners) {
        return switch (this.getRetrievalSemantics()) {
            default -> throw new IncompatibleClassChangeError();
            case RetrievalSemantics.STANDARD -> this.ifNotExists(this.getConstraintFactory().forEach(otherClass), joiners);
            case RetrievalSemantics.PRECOMPUTE -> this.ifNotExists(this.getConstraintFactory().forEachUnfiltered(otherClass), joiners);
            case RetrievalSemantics.LEGACY -> this.ifNotExists(this.getConstraintFactory().fromUnfiltered(otherClass), joiners);
        };
    }

    @Override
    default public <E> @NonNull QuadConstraintStream<A, B, C, D> ifNotExistsIncludingUnassigned(@NonNull Class<E> otherClass, PentaJoiner<A, B, C, D, E> ... joiners) {
        return switch (this.getRetrievalSemantics()) {
            default -> throw new IncompatibleClassChangeError();
            case RetrievalSemantics.STANDARD -> this.ifNotExists(this.getConstraintFactory().forEachIncludingUnassigned(otherClass), joiners);
            case RetrievalSemantics.PRECOMPUTE -> this.ifNotExists(this.getConstraintFactory().forEachUnfiltered(otherClass), joiners);
            case RetrievalSemantics.LEGACY -> this.ifNotExists(this.getConstraintFactory().fromUnfiltered(otherClass), joiners);
        };
    }

    @Override
    default public @NonNull QuadConstraintStream<A, B, C, D> distinct() {
        if (this.guaranteesDistinct()) {
            return this;
        }
        return this.groupBy(ConstantLambdaUtils.quadPickFirst(), ConstantLambdaUtils.quadPickSecond(), ConstantLambdaUtils.quadPickThird(), ConstantLambdaUtils.quadPickFourth());
    }

    @Override
    default public <Score_ extends Score<Score_>> @NonNull QuadConstraintBuilder<A, B, C, D, Score_> penalize(@NonNull Score_ constraintWeight, @NonNull ToIntQuadFunction<A, B, C, D> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.PENALTY);
    }

    @Override
    default public <Score_ extends Score<Score_>> @NonNull QuadConstraintBuilder<A, B, C, D, Score_> penalizeLong(@NonNull Score_ constraintWeight, @NonNull ToLongQuadFunction<A, B, C, D> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.PENALTY);
    }

    @Override
    default public <Score_ extends Score<Score_>> @NonNull QuadConstraintBuilder<A, B, C, D, Score_> penalizeBigDecimal(@NonNull Score_ constraintWeight, @NonNull QuadFunction<A, B, C, D, BigDecimal> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.PENALTY);
    }

    @Override
    default public QuadConstraintBuilder<A, B, C, D, ?> penalizeConfigurable(ToIntQuadFunction<A, B, C, D> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.PENALTY);
    }

    @Override
    default public QuadConstraintBuilder<A, B, C, D, ?> penalizeConfigurableLong(ToLongQuadFunction<A, B, C, D> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.PENALTY);
    }

    @Override
    default public QuadConstraintBuilder<A, B, C, D, ?> penalizeConfigurableBigDecimal(QuadFunction<A, B, C, D, BigDecimal> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.PENALTY);
    }

    @Override
    default public <Score_ extends Score<Score_>> @NonNull QuadConstraintBuilder<A, B, C, D, Score_> reward(@NonNull Score_ constraintWeight, @NonNull ToIntQuadFunction<A, B, C, D> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.REWARD);
    }

    @Override
    default public <Score_ extends Score<Score_>> @NonNull QuadConstraintBuilder<A, B, C, D, Score_> rewardLong(@NonNull Score_ constraintWeight, @NonNull ToLongQuadFunction<A, B, C, D> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.REWARD);
    }

    @Override
    default public <Score_ extends Score<Score_>> @NonNull QuadConstraintBuilder<A, B, C, D, Score_> rewardBigDecimal(@NonNull Score_ constraintWeight, @NonNull QuadFunction<A, B, C, D, BigDecimal> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.REWARD);
    }

    @Override
    default public QuadConstraintBuilder<A, B, C, D, ?> rewardConfigurable(ToIntQuadFunction<A, B, C, D> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.REWARD);
    }

    @Override
    default public QuadConstraintBuilder<A, B, C, D, ?> rewardConfigurableLong(ToLongQuadFunction<A, B, C, D> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.REWARD);
    }

    @Override
    default public QuadConstraintBuilder<A, B, C, D, ?> rewardConfigurableBigDecimal(QuadFunction<A, B, C, D, BigDecimal> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.REWARD);
    }

    @Override
    default public <Score_ extends Score<Score_>> @NonNull QuadConstraintBuilder<A, B, C, D, Score_> impact(@NonNull Score_ constraintWeight, @NonNull ToIntQuadFunction<A, B, C, D> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.MIXED);
    }

    @Override
    default public <Score_ extends Score<Score_>> @NonNull QuadConstraintBuilder<A, B, C, D, Score_> impactLong(@NonNull Score_ constraintWeight, @NonNull ToLongQuadFunction<A, B, C, D> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.MIXED);
    }

    @Override
    default public <Score_ extends Score<Score_>> @NonNull QuadConstraintBuilder<A, B, C, D, Score_> impactBigDecimal(@NonNull Score_ constraintWeight, @NonNull QuadFunction<A, B, C, D, BigDecimal> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.MIXED);
    }

    @Override
    default public QuadConstraintBuilder<A, B, C, D, ?> impactConfigurable(ToIntQuadFunction<A, B, C, D> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.MIXED);
    }

    @Override
    default public QuadConstraintBuilder<A, B, C, D, ?> impactConfigurableLong(ToLongQuadFunction<A, B, C, D> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.MIXED);
    }

    @Override
    default public QuadConstraintBuilder<A, B, C, D, ?> impactConfigurableBigDecimal(QuadFunction<A, B, C, D, BigDecimal> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.MIXED);
    }

    public <Score_ extends Score<Score_>> QuadConstraintBuilder<A, B, C, D, Score_> innerImpact(Score_ var1, ToIntQuadFunction<A, B, C, D> var2, ScoreImpactType var3);

    public <Score_ extends Score<Score_>> QuadConstraintBuilder<A, B, C, D, Score_> innerImpact(Score_ var1, ToLongQuadFunction<A, B, C, D> var2, ScoreImpactType var3);

    public <Score_ extends Score<Score_>> QuadConstraintBuilder<A, B, C, D, Score_> innerImpact(Score_ var1, QuadFunction<A, B, C, D, BigDecimal> var2, ScoreImpactType var3);

    @Override
    default public @NonNull Constraint penalize(@NonNull String constraintName, @NonNull Score<?> constraintWeight) {
        return this.penalize(constraintWeight).asConstraint(constraintName);
    }

    @Override
    default public @NonNull Constraint penalize(@NonNull String constraintPackage, @NonNull String constraintName, @NonNull Score<?> constraintWeight) {
        return this.penalize(constraintWeight).asConstraint(constraintPackage, constraintName);
    }

    @Override
    default public @NonNull Constraint penalizeConfigurable(@NonNull String constraintName) {
        return this.penalizeConfigurable().asConstraint(constraintName);
    }

    @Override
    default public @NonNull Constraint penalizeConfigurable(@NonNull String constraintPackage, @NonNull String constraintName) {
        return this.penalizeConfigurable().asConstraint(constraintPackage, constraintName);
    }

    @Override
    default public @NonNull Constraint reward(@NonNull String constraintName, @NonNull Score<?> constraintWeight) {
        return this.reward(constraintWeight).asConstraint(constraintName);
    }

    @Override
    default public @NonNull Constraint reward(@NonNull String constraintPackage, @NonNull String constraintName, @NonNull Score<?> constraintWeight) {
        return this.reward(constraintWeight).asConstraint(constraintPackage, constraintName);
    }

    @Override
    default public @NonNull Constraint rewardConfigurable(@NonNull String constraintName) {
        return this.rewardConfigurable().asConstraint(constraintName);
    }

    @Override
    default public @NonNull Constraint rewardConfigurable(@NonNull String constraintPackage, @NonNull String constraintName) {
        return this.penalizeConfigurable().asConstraint(constraintPackage, constraintName);
    }

    @Override
    default public @NonNull Constraint impact(@NonNull String constraintName, @NonNull Score<?> constraintWeight) {
        return this.impact(constraintWeight).asConstraint(constraintName);
    }

    @Override
    default public @NonNull Constraint impact(@NonNull String constraintPackage, @NonNull String constraintName, @NonNull Score<?> constraintWeight) {
        return this.impact(constraintWeight).asConstraint(constraintPackage, constraintName);
    }
}

