/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet.tri;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.bavet.common.BavetAbstractConstraintStream;
import ai.timefold.solver.core.impl.bavet.common.TupleSource;
import ai.timefold.solver.core.impl.bavet.tri.PrecomputeTriNode;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraintFactory;
import ai.timefold.solver.core.impl.score.stream.bavet.common.BavetPrecomputeBuildHelper;
import ai.timefold.solver.core.impl.score.stream.bavet.common.ConstraintNodeBuildHelper;
import ai.timefold.solver.core.impl.score.stream.bavet.common.bridge.BavetAftBridgeTriConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.tri.BavetAbstractTriConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.tri.BavetRecordingTriConstraintStream;
import ai.timefold.solver.core.impl.score.stream.common.RetrievalSemantics;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

public class BavetPrecomputeTriConstraintStream<Solution_, A, B, C>
extends BavetAbstractTriConstraintStream<Solution_, A, B, C>
implements TupleSource {
    private final BavetAbstractConstraintStream<Solution_> recordingPrecomputedConstraintStream;
    private final Set<Class<?>> entityClassSet;
    private BavetAftBridgeTriConstraintStream<Solution_, A, B, C> aftStream;

    public BavetPrecomputeTriConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractConstraintStream<Solution_> precomputedConstraintStream) {
        super(constraintFactory, RetrievalSemantics.STANDARD);
        this.recordingPrecomputedConstraintStream = new BavetRecordingTriConstraintStream(constraintFactory, precomputedConstraintStream);
        this.entityClassSet = constraintFactory.getSolutionDescriptor().getEntityClassSet();
        precomputedConstraintStream.getChildStreamList().add(this.recordingPrecomputedConstraintStream);
    }

    public void setAftBridge(BavetAftBridgeTriConstraintStream<Solution_, A, B, C> aftStream) {
        this.aftStream = aftStream;
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(ConstraintNodeBuildHelper<Solution_, Score_> buildHelper) {
        Supplier precomputeBuildHelperSupplier = () -> new BavetPrecomputeBuildHelper(this.recordingPrecomputedConstraintStream, this.entityClassSet);
        int outputStoreSize = buildHelper.extractTupleStoreSize(this.aftStream);
        buildHelper.addNode(new PrecomputeTriNode(precomputeBuildHelperSupplier, outputStoreSize, buildHelper.getAggregatedTupleLifecycle(this.aftStream.getChildStreamList()), precomputeBuildHelperSupplier.get().getSourceClasses()), this);
    }

    @Override
    public void collectActiveConstraintStreams(Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet) {
        constraintStreamSet.add(this);
    }

    public int hashCode() {
        return Objects.hash(this.recordingPrecomputedConstraintStream);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BavetPrecomputeTriConstraintStream) {
            BavetPrecomputeTriConstraintStream other = (BavetPrecomputeTriConstraintStream)o;
            return this.recordingPrecomputedConstraintStream.equals(other.recordingPrecomputedConstraintStream);
        }
        return false;
    }
}

