/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.constraint.ConstraintRef;
import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.api.score.stream.ConstraintMetaModel;
import ai.timefold.solver.core.impl.bavet.NodeNetwork;
import ai.timefold.solver.core.impl.bavet.common.AbstractNode;
import ai.timefold.solver.core.impl.bavet.common.AbstractNodeBuildHelper;
import ai.timefold.solver.core.impl.bavet.common.BavetAbstractConstraintStream;
import ai.timefold.solver.core.impl.bavet.common.BavetRootNode;
import ai.timefold.solver.core.impl.bavet.uni.AbstractForEachUniNode;
import ai.timefold.solver.core.impl.bavet.visual.NodeGraph;
import ai.timefold.solver.core.impl.domain.solution.ConstraintWeightSupplier;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.declarative.ConsistencyTracker;
import ai.timefold.solver.core.impl.score.constraint.ConstraintMatchPolicy;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraint;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraintSession;
import ai.timefold.solver.core.impl.score.stream.bavet.common.ConstraintNodeBuildHelper;
import ai.timefold.solver.core.impl.score.stream.common.inliner.AbstractScoreInliner;
import ai.timefold.solver.core.impl.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public final class BavetConstraintSessionFactory<Solution_, Score_ extends Score<Score_>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BavetConstraintSessionFactory.class);
    private static final Level CONSTRAINT_WEIGHT_LOGGING_LEVEL = Level.DEBUG;
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final ConstraintMetaModel constraintMetaModel;

    public BavetConstraintSessionFactory(SolutionDescriptor<Solution_> solutionDescriptor, ConstraintMetaModel constraintMetaModel) {
        this.solutionDescriptor = Objects.requireNonNull(solutionDescriptor);
        this.constraintMetaModel = Objects.requireNonNull(constraintMetaModel);
    }

    public BavetConstraintSession<Score_> buildSession(Solution_ workingSolution, ConsistencyTracker<Solution_> consistencyTracker, ConstraintMatchPolicy constraintMatchPolicy, boolean scoreDirectorDerived, Consumer<String> nodeNetworkVisualizationConsumer) {
        ConstraintWeightSupplier constraintWeightSupplier = this.solutionDescriptor.getConstraintWeightSupplier();
        Collection<Constraint> constraints = this.constraintMetaModel.getConstraints();
        if (constraintWeightSupplier != null) {
            Set<ConstraintRef> knownConstraints = constraints.stream().map(Constraint::getConstraintRef).collect(Collectors.toSet());
            constraintWeightSupplier.validate(workingSolution, knownConstraints);
        }
        ScoreDefinition scoreDefinition = this.solutionDescriptor.getScoreDefinition();
        Object zeroScore = scoreDefinition.getZeroScore();
        LinkedHashSet<BavetAbstractConstraintStream<Solution_>> constraintStreamSet = new LinkedHashSet<BavetAbstractConstraintStream<Solution_>>();
        Map constraintWeightMap = CollectionUtils.newHashMap(constraints.size());
        boolean constraintWeightLoggingEnabled = !scoreDirectorDerived && LOGGER.isEnabledForLevel(CONSTRAINT_WEIGHT_LOGGING_LEVEL);
        StringBuilder constraintWeightString = constraintWeightLoggingEnabled ? new StringBuilder("Constraint weights for solution (%s):%n".formatted(workingSolution)) : null;
        for (Constraint constraint : constraints) {
            ConstraintRef constraintRef = constraint.getConstraintRef();
            BavetConstraint castConstraint = (BavetConstraint)constraint;
            Object defaultConstraintWeight = castConstraint.getConstraintWeight();
            Object constraintWeight = castConstraint.extractConstraintWeight(workingSolution);
            if (!constraintWeight.equals(zeroScore)) {
                if (constraintWeightLoggingEnabled) {
                    if (defaultConstraintWeight != null && !defaultConstraintWeight.equals(constraintWeight)) {
                        constraintWeightString.append("  Constraint (%s) weight overridden to (%s) from (%s).%n".formatted(constraintRef, constraintWeight, defaultConstraintWeight));
                    } else {
                        constraintWeightString.append("  Constraint (%s) weight set to (%s).%n".formatted(constraintRef, constraintWeight));
                    }
                }
                castConstraint.collectActiveConstraintStreams(constraintStreamSet);
                constraintWeightMap.put(constraint, constraintWeight);
                continue;
            }
            if (!constraintWeightLoggingEnabled) continue;
            constraintWeightString.append("  Constraint (%s) disabled.%n".formatted(constraintRef));
        }
        Object scoreInliner = AbstractScoreInliner.buildScoreInliner(scoreDefinition, constraintWeightMap, constraintMatchPolicy);
        if (constraintStreamSet.isEmpty()) {
            LOGGER.warn("No constraints enabled for solution ({}).", workingSolution);
            return new BavetConstraintSession(scoreInliner);
        }
        if (constraintWeightLoggingEnabled) {
            LOGGER.atLevel(CONSTRAINT_WEIGHT_LOGGING_LEVEL).log(constraintWeightString.toString().trim());
        }
        return new BavetConstraintSession(scoreInliner, BavetConstraintSessionFactory.buildNodeNetwork(workingSolution, consistencyTracker, constraintStreamSet, scoreInliner, nodeNetworkVisualizationConsumer));
    }

    private static <Solution_, Score_ extends Score<Score_>> NodeNetwork buildNodeNetwork(Solution_ workingSolution, ConsistencyTracker<Solution_> consistencyTracker, Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet, AbstractScoreInliner<Score_> scoreInliner, Consumer<String> nodeNetworkVisualizationConsumer) {
        ConstraintNodeBuildHelper<Solution_, Score_> buildHelper = new ConstraintNodeBuildHelper<Solution_, Score_>(consistencyTracker, constraintStreamSet, scoreInliner);
        LinkedHashMap declaredClassToNodeMap = new LinkedHashMap();
        List<AbstractNode> nodeList = buildHelper.buildNodeList(constraintStreamSet, buildHelper, BavetAbstractConstraintStream::buildNode, node -> {
            if (!(node instanceof BavetRootNode)) {
                return;
            }
            BavetRootNode tupleSourceRoot = (BavetRootNode)((Object)node);
            if (tupleSourceRoot instanceof AbstractForEachUniNode) {
                AbstractForEachUniNode forEachUniNode = (AbstractForEachUniNode)tupleSourceRoot;
                Class forEachClass = forEachUniNode.getForEachClass();
                List forEachUniNodeList = declaredClassToNodeMap.computeIfAbsent(forEachClass, k -> new ArrayList(2));
                if (forEachUniNodeList.stream().filter(sourceNode -> sourceNode instanceof AbstractForEachUniNode).count() == 3L) {
                    throw new IllegalStateException("Impossible state: For class (%s) there are already 3 nodes (%s), not adding another (%s).".formatted(forEachClass, forEachUniNodeList, forEachUniNode));
                }
                forEachUniNodeList.add(forEachUniNode);
            } else {
                for (Class<?> sourceClass : tupleSourceRoot.getSourceClasses()) {
                    List forEachUniNodeList = declaredClassToNodeMap.computeIfAbsent(sourceClass, k -> new ArrayList(2));
                    forEachUniNodeList.add(tupleSourceRoot);
                }
            }
        });
        if (nodeNetworkVisualizationConsumer != null) {
            Set<Constraint> constraintSet = scoreInliner.getConstraints();
            String visualisation = NodeGraph.of(workingSolution, nodeList, constraintSet, buildHelper::getNodeCreatingStream, buildHelper::findParentNode).buildGraphvizDOT();
            nodeNetworkVisualizationConsumer.accept(visualisation);
        }
        return AbstractNodeBuildHelper.buildNodeNetwork(nodeList, declaredClassToNodeMap);
    }
}

