/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet;

import ai.timefold.solver.core.api.score.stream.ConstraintStream;
import ai.timefold.solver.core.api.score.stream.Joiners;
import ai.timefold.solver.core.api.score.stream.PrecomputeFactory;
import ai.timefold.solver.core.api.score.stream.uni.UniConstraintStream;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.impl.bavet.common.BavetAbstractConstraintStream;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.ConstraintWeightSupplier;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.InverseRelationShadowVariableDescriptor;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraint;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetStaticDataFactory;
import ai.timefold.solver.core.impl.score.stream.bavet.bi.BavetAbstractBiConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.bi.BavetPrecomputeBiConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.common.ConstraintNodeBuildHelper;
import ai.timefold.solver.core.impl.score.stream.bavet.common.bridge.BavetAftBridgeBiConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.common.bridge.BavetAftBridgeQuadConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.common.bridge.BavetAftBridgeTriConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.common.bridge.BavetAftBridgeUniConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.quad.BavetAbstractQuadConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.quad.BavetPrecomputeQuadConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.tri.BavetAbstractTriConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.tri.BavetPrecomputeTriConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.uni.BavetAbstractUniConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.uni.BavetForEachUniConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.uni.BavetPrecomputeUniConstraintStream;
import ai.timefold.solver.core.impl.score.stream.common.ForEachFilteringCriteria;
import ai.timefold.solver.core.impl.score.stream.common.InnerConstraintFactory;
import ai.timefold.solver.core.impl.score.stream.common.RetrievalSemantics;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class BavetConstraintFactory<Solution_>
extends InnerConstraintFactory<Solution_, BavetConstraint<Solution_>> {
    private static final String DEFAULT_CONSTRAINT_PACKAGE = "unnamed.package";
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final EnvironmentMode environmentMode;
    private final String defaultConstraintPackage;
    private final Map<BavetAbstractConstraintStream<Solution_>, BavetAbstractConstraintStream<Solution_>> sharingStreamMap = new HashMap<BavetAbstractConstraintStream<Solution_>, BavetAbstractConstraintStream<Solution_>>(256);

    public BavetConstraintFactory(SolutionDescriptor<Solution_> solutionDescriptor, EnvironmentMode environmentMode) {
        this.solutionDescriptor = solutionDescriptor;
        this.environmentMode = Objects.requireNonNull(environmentMode);
        ConstraintWeightSupplier weightSupplier = solutionDescriptor.getConstraintWeightSupplier();
        this.defaultConstraintPackage = weightSupplier == null ? BavetConstraintFactory.determineDefaultConstraintPackage(solutionDescriptor.getSolutionClass().getPackage()) : BavetConstraintFactory.determineDefaultConstraintPackage(weightSupplier.getDefaultConstraintPackage());
    }

    private static String determineDefaultConstraintPackage(@Nullable Package pkg) {
        String asString = pkg == null ? "" : pkg.getName();
        return BavetConstraintFactory.determineDefaultConstraintPackage(asString);
    }

    private static String determineDefaultConstraintPackage(@Nullable String constraintPackage) {
        return constraintPackage == null || constraintPackage.isEmpty() ? DEFAULT_CONSTRAINT_PACKAGE : constraintPackage;
    }

    public <Stream_ extends BavetAbstractConstraintStream<Solution_>> Stream_ share(Stream_ stream) {
        return (Stream_)this.share(stream, t -> {});
    }

    public <Stream_ extends BavetAbstractConstraintStream<Solution_>> Stream_ share(Stream_ stream, Consumer<Stream_> consumer) {
        return (Stream_)this.sharingStreamMap.computeIfAbsent(stream, k -> {
            consumer.accept(stream);
            return stream;
        });
    }

    private <A> UniConstraintStream<A> forEachForCriteria(Class<A> sourceClass, ForEachFilteringCriteria criteria) {
        return this.forEachForCriteria(sourceClass, criteria, RetrievalSemantics.STANDARD);
    }

    private <A> UniConstraintStream<A> forEachForCriteria(Class<A> sourceClass, ForEachFilteringCriteria criteria, RetrievalSemantics retrievalSemantics) {
        this.assertValidFromType(sourceClass);
        EntityDescriptor<Solution_> entityDescriptor = this.solutionDescriptor.findEntityDescriptor(sourceClass);
        if (entityDescriptor == null || criteria == ForEachFilteringCriteria.ALL) {
            return this.share(new BavetForEachUniConstraintStream(this, sourceClass, null, retrievalSemantics));
        }
        ListVariableDescriptor<Solution_> listVariableDescriptor = this.solutionDescriptor.getListVariableDescriptor();
        if (listVariableDescriptor == null || !listVariableDescriptor.acceptsValueType(sourceClass)) {
            return this.share(new BavetForEachUniConstraintStream(this, sourceClass, new ForEachFilteringCriteriaPredicateFunction(entityDescriptor, criteria), retrievalSemantics));
        }
        Class<?> entityClass = listVariableDescriptor.getEntityDescriptor().getEntityClass();
        if (entityClass == sourceClass) {
            throw new IllegalStateException("Impossible state: entityClass (%s) and sourceClass (%s) are the same.".formatted(entityClass.getCanonicalName(), sourceClass.getCanonicalName()));
        }
        InverseRelationShadowVariableDescriptor<Solution_> shadowDescriptor = listVariableDescriptor.getInverseRelationShadowVariableDescriptor();
        if (shadowDescriptor == null && criteria == ForEachFilteringCriteria.ASSIGNED_AND_CONSISTENT) {
            return this.forEachForCriteria(sourceClass, ForEachFilteringCriteria.CONSISTENT).ifExists(entityClass, Joiners.filtering(listVariableDescriptor.getInListPredicate()));
        }
        return this.share(new BavetForEachUniConstraintStream(this, sourceClass, new ForEachFilteringCriteriaPredicateFunction(entityDescriptor, criteria), retrievalSemantics));
    }

    @Override
    public <A> UniConstraintStream<A> forEach(Class<A> sourceClass) {
        return this.forEachForCriteria(sourceClass, ForEachFilteringCriteria.ASSIGNED_AND_CONSISTENT);
    }

    @Override
    public <A> UniConstraintStream<A> forEachIncludingUnassigned(Class<A> sourceClass) {
        return this.forEachForCriteria(sourceClass, ForEachFilteringCriteria.CONSISTENT);
    }

    @Override
    public <A> UniConstraintStream<A> forEachUnfiltered(Class<A> sourceClass) {
        return this.forEachForCriteria(sourceClass, ForEachFilteringCriteria.ALL);
    }

    <A> UniConstraintStream<A> forEachUnfilteredPrecomputed(Class<A> sourceClass) {
        return this.forEachForCriteria(sourceClass, ForEachFilteringCriteria.ALL, RetrievalSemantics.PRECOMPUTE);
    }

    @Override
    public <A> UniConstraintStream<A> from(Class<A> fromClass) {
        this.assertValidFromType(fromClass);
        EntityDescriptor<Solution_> entityDescriptor = this.solutionDescriptor.findEntityDescriptor(fromClass);
        if (entityDescriptor != null && entityDescriptor.isGenuine()) {
            Predicate<Object> predicate = entityDescriptor.getIsInitializedPredicate();
            return this.share(new BavetForEachUniConstraintStream(this, fromClass, new PredicateSupplier(predicate), RetrievalSemantics.LEGACY));
        }
        return this.share(new BavetForEachUniConstraintStream(this, fromClass, null, RetrievalSemantics.LEGACY));
    }

    @Override
    public <Stream_ extends ConstraintStream> Stream_ precompute(Function<PrecomputeFactory, Stream_> precomputeSupplier) {
        ConstraintStream bavetStream = Objects.requireNonNull((ConstraintStream)precomputeSupplier.apply(new BavetStaticDataFactory(this)));
        if (bavetStream instanceof BavetAbstractUniConstraintStream) {
            BavetAbstractUniConstraintStream uniStream = (BavetAbstractUniConstraintStream)bavetStream;
            BavetPrecomputeUniConstraintStream out = new BavetPrecomputeUniConstraintStream(this, uniStream);
            return (Stream_)this.share(new BavetAftBridgeUniConstraintStream(this, out), out::setAftBridge);
        }
        if (bavetStream instanceof BavetAbstractBiConstraintStream) {
            BavetAbstractBiConstraintStream biStream = (BavetAbstractBiConstraintStream)bavetStream;
            BavetPrecomputeBiConstraintStream out = new BavetPrecomputeBiConstraintStream(this, biStream);
            return (Stream_)this.share(new BavetAftBridgeBiConstraintStream(this, out), out::setAftBridge);
        }
        if (bavetStream instanceof BavetAbstractTriConstraintStream) {
            BavetAbstractTriConstraintStream triStream = (BavetAbstractTriConstraintStream)bavetStream;
            BavetPrecomputeTriConstraintStream out = new BavetPrecomputeTriConstraintStream(this, triStream);
            return (Stream_)this.share(new BavetAftBridgeTriConstraintStream(this, out), out::setAftBridge);
        }
        if (bavetStream instanceof BavetAbstractQuadConstraintStream) {
            BavetAbstractQuadConstraintStream quadStream = (BavetAbstractQuadConstraintStream)bavetStream;
            BavetPrecomputeQuadConstraintStream out = new BavetPrecomputeQuadConstraintStream(this, quadStream);
            return (Stream_)this.share(new BavetAftBridgeQuadConstraintStream(this, out), out::setAftBridge);
        }
        throw new IllegalStateException("impossible state: the supplier (%s) returned a stream (%s) that not an instance of any Bavet ConstraintStream".formatted(precomputeSupplier, bavetStream));
    }

    @Override
    public <A> UniConstraintStream<A> fromUnfiltered(Class<A> fromClass) {
        this.assertValidFromType(fromClass);
        return this.share(new BavetForEachUniConstraintStream(this, fromClass, null, RetrievalSemantics.LEGACY));
    }

    @Override
    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    public EnvironmentMode getEnvironmentMode() {
        return this.environmentMode;
    }

    @Override
    public String getDefaultConstraintPackage() {
        return this.defaultConstraintPackage;
    }

    private record ForEachFilteringCriteriaPredicateFunction<Solution_, A>(EntityDescriptor<Solution_> entityDescriptor, ForEachFilteringCriteria criteria) implements Function<ConstraintNodeBuildHelper<Solution_, ?>, Predicate<A>>
    {
        @Override
        public Predicate<A> apply(ConstraintNodeBuildHelper<Solution_, ?> helper) {
            return helper.getForEachPredicateForEntityDescriptorAndCriteria(this.entityDescriptor, this.criteria);
        }
    }

    private record PredicateSupplier<Solution_, A>(Predicate<A> suppliedPredicate) implements Function<ConstraintNodeBuildHelper<Solution_, ?>, Predicate<A>>
    {
        @Override
        public Predicate<A> apply(ConstraintNodeBuildHelper<Solution_, ?> helper) {
            return this.suppliedPredicate;
        }
    }
}

