/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.director;

import ai.timefold.solver.core.api.domain.valuerange.CountableValueRange;
import ai.timefold.solver.core.api.solver.ProblemSizeStatistics;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.common.ReachableValues;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import ai.timefold.solver.core.impl.score.director.SolutionInitializationStatistics;
import ai.timefold.solver.core.impl.score.director.ValueRangeState;
import ai.timefold.solver.core.impl.score.director.ValueRangeStatistics;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class ValueRangeManager<Solution_> {
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private @Nullable ValueRangeState<Solution_, ?, ?> singleValueRangeState;
    private final @Nullable ValueRangeState<Solution_, ?, ?> @Nullable [] multipleValueRangeState;
    private @Nullable Solution_ cachedWorkingSolution = null;
    private @Nullable ValueRangeStatistics<Solution_> statistics;

    public static <Solution_> ValueRangeManager<Solution_> of(SolutionDescriptor<Solution_> solutionDescriptor, Solution_ solution) {
        ValueRangeManager<Solution_> valueRangeManager = new ValueRangeManager<Solution_>(solutionDescriptor);
        valueRangeManager.reset(solution);
        return valueRangeManager;
    }

    public ValueRangeManager(SolutionDescriptor<Solution_> solutionDescriptor) {
        this.solutionDescriptor = Objects.requireNonNull(solutionDescriptor);
        int countDescriptor = solutionDescriptor.getValueRangeDescriptorCount();
        this.multipleValueRangeState = countDescriptor > 1 ? new ValueRangeState[countDescriptor] : null;
    }

    private ValueRangeStatistics<Solution_> ensureStatisticsInitialized(Solution_ solution) {
        if (this.statistics == null) {
            this.statistics = new ValueRangeStatistics<Solution_>(this, this.solutionDescriptor, solution);
        } else if (this.statistics.getSolution() != solution) {
            return new ValueRangeStatistics<Solution_>(this, this.solutionDescriptor, solution);
        }
        return this.statistics;
    }

    ValueRangeStatistics<Solution_> getStatistics() {
        return this.ensureStatisticsInitialized(Objects.requireNonNull(this.cachedWorkingSolution));
    }

    public SolutionInitializationStatistics getInitializationStatistics() {
        if (this.cachedWorkingSolution == null) {
            throw new IllegalStateException("Impossible state: initialization statistics requested before the working solution is known.");
        }
        return this.getInitializationStatistics(null);
    }

    public SolutionInitializationStatistics getInitializationStatistics(@Nullable Consumer<Object> finisher) {
        if (this.cachedWorkingSolution == null) {
            throw new IllegalStateException("Impossible state: initialization statistics requested before the working solution is known.");
        }
        return this.ensureStatisticsInitialized(this.cachedWorkingSolution).computeInitializationStatistics(finisher, true);
    }

    public SolutionInitializationStatistics computeInitializationStatistics(Solution_ solution, @Nullable Consumer<Object> finisher) {
        return this.ensureStatisticsInitialized(solution).computeInitializationStatistics(finisher, false);
    }

    public ProblemSizeStatistics getProblemSizeStatistics() {
        return this.ensureStatisticsInitialized(Objects.requireNonNull(this.cachedWorkingSolution)).getProblemSizeStatistics();
    }

    private <Entity_, Value_> ValueRangeState<Solution_, Entity_, Value_> fromDescriptor(ValueRangeDescriptor<Solution_> descriptor) {
        if (this.multipleValueRangeState == null) {
            if (this.singleValueRangeState == null) {
                this.singleValueRangeState = new ValueRangeState(descriptor, Objects.requireNonNull(this.cachedWorkingSolution));
            }
            return this.singleValueRangeState;
        }
        ValueRangeState<Solution_, Object, Object> descriptorState = this.multipleValueRangeState[descriptor.getOrdinal()];
        if (descriptorState == null) {
            this.multipleValueRangeState[descriptor.getOrdinal()] = descriptorState = new ValueRangeState(descriptor, Objects.requireNonNull(this.cachedWorkingSolution));
        }
        return descriptorState;
    }

    public <Value_> CountableValueRange<Value_> getFromSolution(ValueRangeDescriptor<Solution_> valueRangeDescriptor) {
        if (this.cachedWorkingSolution == null) {
            throw new IllegalStateException("Impossible state: value range (%s) requested before the working solution is known.".formatted(valueRangeDescriptor));
        }
        return this.getFromSolution(valueRangeDescriptor, this.cachedWorkingSolution);
    }

    public <Value_> CountableValueRange<Value_> getFromSolution(ValueRangeDescriptor<Solution_> valueRangeDescriptor, @Nullable SelectionSorter<Solution_, Value_> sorter) {
        if (this.cachedWorkingSolution == null) {
            throw new IllegalStateException("Impossible state: value range (%s) requested before the working solution is known.".formatted(valueRangeDescriptor));
        }
        return this.getFromSolution(valueRangeDescriptor, this.cachedWorkingSolution, sorter);
    }

    public <Value_> CountableValueRange<Value_> getFromSolution(ValueRangeDescriptor<Solution_> valueRangeDescriptor, Solution_ solution) {
        return this.getFromSolution(valueRangeDescriptor, solution, null);
    }

    public <Value_> CountableValueRange<Value_> getFromSolution(ValueRangeDescriptor<Solution_> valueRangeDescriptor, Solution_ solution, @Nullable SelectionSorter<Solution_, Value_> sorter) {
        ValueRangeState descriptor = this.fromDescriptor(valueRangeDescriptor);
        return descriptor.getFromSolution(solution, sorter);
    }

    public <Entity_, Value_> CountableValueRange<Value_> getFromEntity(ValueRangeDescriptor<Solution_> valueRangeDescriptor, Entity_ entity) {
        return this.getFromEntity(valueRangeDescriptor, entity, null);
    }

    public <Entity_, Value_> CountableValueRange<Value_> getFromEntity(ValueRangeDescriptor<Solution_> valueRangeDescriptor, Entity_ entity, @Nullable SelectionSorter<Solution_, Value_> sorter) {
        ValueRangeState<Solution_, Entity_, Value_> descriptor = this.fromDescriptor(valueRangeDescriptor);
        return descriptor.getFromEntity(entity, this.getInitializationStatistics().genuineEntityCount(), sorter);
    }

    public long countOnSolution(ValueRangeDescriptor<Solution_> valueRangeDescriptor, Solution_ solution) {
        return this.getFromSolution(valueRangeDescriptor, solution).getSize();
    }

    public <Entity_> long countOnEntity(ValueRangeDescriptor<Solution_> valueRangeDescriptor, Entity_ entity) {
        return this.getFromEntity(valueRangeDescriptor, entity).getSize();
    }

    public <Entity_, Value_> ReachableValues<Entity_, Value_> getReachableValues(GenuineVariableDescriptor<Solution_> variableDescriptor) {
        return this.getReachableValues(variableDescriptor, null);
    }

    public <Entity_, Value_> ReachableValues<Entity_, Value_> getReachableValues(GenuineVariableDescriptor<Solution_> variableDescriptor, @Nullable SelectionSorter<Solution_, Value_> sorter) {
        ValueRangeState<Solution_, Entity_, Value_> descriptor = this.fromDescriptor(variableDescriptor.getValueRangeDescriptor());
        return descriptor.getReachableValues(variableDescriptor, sorter);
    }

    public void reset(@Nullable Solution_ workingSolution) {
        this.singleValueRangeState = null;
        if (this.multipleValueRangeState != null) {
            Arrays.fill(this.multipleValueRangeState, null);
        }
        if (workingSolution != null) {
            this.cachedWorkingSolution = workingSolution;
            this.statistics = null;
        }
    }
}

