/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.neighborhood.stream.enumerating.uni;

import ai.timefold.solver.core.impl.bavet.common.AbstractIfExistsNode;
import ai.timefold.solver.core.impl.bavet.common.index.IndexerFactory;
import ai.timefold.solver.core.impl.bavet.common.tuple.InOutTupleStorePositionTracker;
import ai.timefold.solver.core.impl.bavet.common.tuple.InTupleStorePositionTracker;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.UniTuple;
import ai.timefold.solver.core.impl.bavet.uni.IndexedIfExistsUniNode;
import ai.timefold.solver.core.impl.bavet.uni.UnindexedIfExistsUniNode;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.stream.enumerating.function.BiEnumeratingPredicate;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.EnumeratingStreamFactory;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.common.AbstractEnumeratingStream;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.common.DataNodeBuildHelper;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.common.IfExistsEnumeratingStream;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.common.bridge.ForeBridgeUniEnumeratingStream;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.joiner.DefaultBiEnumeratingJoiner;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.uni.AbstractUniEnumeratingStream;
import ai.timefold.solver.core.impl.score.director.SessionContext;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class IfExistsUniEnumeratingStream<Solution_, A, B>
extends AbstractUniEnumeratingStream<Solution_, A>
implements IfExistsEnumeratingStream<Solution_> {
    private final AbstractUniEnumeratingStream<Solution_, A> parentA;
    private final ForeBridgeUniEnumeratingStream<Solution_, B> parentBridgeB;
    private final boolean shouldExist;
    private final DefaultBiEnumeratingJoiner<A, B> joiner;
    private final @Nullable BiEnumeratingPredicate<Solution_, A, B> filtering;

    public IfExistsUniEnumeratingStream(EnumeratingStreamFactory<Solution_> enumeratingStreamFactory, AbstractUniEnumeratingStream<Solution_, A> parentA, ForeBridgeUniEnumeratingStream<Solution_, B> parentBridgeB, boolean shouldExist, DefaultBiEnumeratingJoiner<A, B> joiner, @Nullable BiEnumeratingPredicate<Solution_, A, B> filtering) {
        super(enumeratingStreamFactory);
        this.parentA = parentA;
        this.parentBridgeB = parentBridgeB;
        this.shouldExist = shouldExist;
        this.joiner = joiner;
        this.filtering = filtering;
    }

    @Override
    public void collectActiveEnumeratingStreams(Set<AbstractEnumeratingStream<Solution_>> enumeratingStreamSet) {
        this.parentA.collectActiveEnumeratingStreams(enumeratingStreamSet);
        this.parentBridgeB.collectActiveEnumeratingStreams(enumeratingStreamSet);
        enumeratingStreamSet.add(this);
    }

    @Override
    public void buildNode(DataNodeBuildHelper<Solution_> buildHelper) {
        TupleLifecycle<UniTuple<A>> downstream = buildHelper.getAggregatedTupleLifecycle(this.childStreamList);
        IndexerFactory<B> indexerFactory = new IndexerFactory<B>(this.joiner.toBiJoiner());
        AbstractIfExistsNode<UniTuple<A>, B> node = this.getNode(indexerFactory, buildHelper, downstream);
        buildHelper.addNode(node, this, this, this.parentBridgeB);
    }

    private AbstractIfExistsNode<UniTuple<A>, B> getNode(IndexerFactory<B> indexerFactory, DataNodeBuildHelper<Solution_> buildHelper, TupleLifecycle<UniTuple<A>> downstream) {
        SessionContext<Solution_> sessionContext = buildHelper.getSessionContext();
        boolean isFiltering = this.filtering != null;
        InOutTupleStorePositionTracker tupleStorePositionTracker = buildHelper.getTupleStorePositionTracker(this, this.parentA.getTupleSource(), this.parentBridgeB.getTupleSource());
        if (indexerFactory.hasJoiners()) {
            if (isFiltering) {
                return new IndexedIfExistsUniNode<A, B>(this.shouldExist, indexerFactory, downstream, this.filtering.toBiPredicate(sessionContext.solutionView()), tupleStorePositionTracker);
            }
            return new IndexedIfExistsUniNode<A, B>(this.shouldExist, indexerFactory, downstream, (InTupleStorePositionTracker)tupleStorePositionTracker);
        }
        if (isFiltering) {
            return new UnindexedIfExistsUniNode<A, B>(this.shouldExist, downstream, this.filtering.toBiPredicate(sessionContext.solutionView()), (InTupleStorePositionTracker)tupleStorePositionTracker);
        }
        return new UnindexedIfExistsUniNode(this.shouldExist, downstream, tupleStorePositionTracker);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof IfExistsUniEnumeratingStream)) return false;
        IfExistsUniEnumeratingStream that = (IfExistsUniEnumeratingStream)o;
        if (this.shouldExist != that.shouldExist) return false;
        if (!Objects.equals(this.parentA, that.parentA)) return false;
        if (!Objects.equals(this.parentBridgeB, that.parentBridgeB)) return false;
        if (!Objects.equals(this.joiner, that.joiner)) return false;
        if (!Objects.equals(this.filtering, that.filtering)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.parentA, this.parentBridgeB, this.shouldExist, this.joiner, this.filtering);
    }

    public String toString() {
        return "IfExists() with " + this.childStreamList.size() + " children";
    }

    @Override
    public AbstractEnumeratingStream<Solution_> getTupleSource() {
        return this.parentA.getTupleSource();
    }

    @Override
    public AbstractEnumeratingStream<Solution_> getLeftParent() {
        return this.parentA;
    }

    @Override
    public AbstractEnumeratingStream<Solution_> getRightParent() {
        return this.parentBridgeB;
    }
}

