/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.neighborhood.stream.enumerating.common;

import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.common.UniqueRandomSequence;
import ai.timefold.solver.core.impl.util.ListEntry;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class DefaultUniqueRandomSequence<T>
implements UniqueRandomSequence<T> {
    private static final DefaultUniqueRandomSequence<?> EMPTY = new DefaultUniqueRandomSequence(Collections.emptyList());
    private final List<ListEntry<T>> originalList;
    private final int length;
    private final BitSet removed;
    private int removedCount;
    private int leftmostIndex;
    private int rightmostIndex;

    public static <T> DefaultUniqueRandomSequence<T> empty() {
        return EMPTY;
    }

    DefaultUniqueRandomSequence(List<? extends ListEntry<T>> listOfUniqueItems) {
        this.originalList = Collections.unmodifiableList(listOfUniqueItems);
        this.length = listOfUniqueItems.size();
        this.removed = new BitSet(this.length);
        this.removedCount = 0;
        this.leftmostIndex = 0;
        this.rightmostIndex = this.length - 1;
    }

    @Override
    public UniqueRandomSequence.SequenceElement<T> pick(Random workingRandom) {
        int randomIndex = this.pickIndex(workingRandom);
        return new UniqueRandomSequence.SequenceElement<T>(this.originalList.get(randomIndex).getElement(), randomIndex);
    }

    private int pickIndex(Random workingRandom) {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int randomIndex = workingRandom.nextInt(this.leftmostIndex, this.rightmostIndex + 1);
        return this.pickIndex(workingRandom, randomIndex);
    }

    int pickIndex(Random workingRandom, int index) {
        if (this.removed.get(index) && ((index = this.determineActiveIndex(workingRandom, index)) < 0 || index >= this.length)) {
            throw new NoSuchElementException();
        }
        return index;
    }

    private int determineActiveIndex(Random workingRandom, int randomIndex) {
        int previousIndexDistance;
        int nextClearIndex = this.removed.nextClearBit(randomIndex);
        int previousClearIndex = this.removed.previousClearBit(randomIndex);
        int nextIndexDistance = nextClearIndex >= this.length ? Integer.MAX_VALUE : nextClearIndex - randomIndex;
        int n = previousIndexDistance = previousClearIndex == -1 ? Integer.MAX_VALUE : randomIndex - previousClearIndex;
        if (nextIndexDistance == previousIndexDistance) {
            return workingRandom.nextBoolean() ? nextClearIndex : previousClearIndex;
        }
        return nextIndexDistance < previousIndexDistance ? nextClearIndex : previousClearIndex;
    }

    @Override
    public T remove(Random workingRandom) {
        return this.remove(this.pickIndex(workingRandom));
    }

    public T remove(int index) {
        if (this.removed.get(index)) {
            throw new IllegalArgumentException("The index (%s) has already been removed.".formatted(index));
        }
        this.removed.set(index);
        ++this.removedCount;
        if (index == this.leftmostIndex) {
            this.leftmostIndex = this.removed.nextClearBit(this.leftmostIndex);
        }
        if (index == this.rightmostIndex) {
            this.rightmostIndex = this.removed.previousClearBit(this.rightmostIndex);
        }
        return this.originalList.get(index).getElement();
    }

    @Override
    public boolean isEmpty() {
        return this.removedCount >= this.length;
    }
}

