/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.neighborhood.stream.enumerating;

import ai.timefold.solver.core.impl.bavet.NodeNetwork;
import ai.timefold.solver.core.impl.bavet.common.AbstractNode;
import ai.timefold.solver.core.impl.bavet.common.AbstractNodeBuildHelper;
import ai.timefold.solver.core.impl.bavet.uni.AbstractForEachUniNode;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.DatasetSession;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.EnumeratingStreamFactory;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.common.AbstractDataset;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.common.AbstractDatasetInstance;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.common.AbstractEnumeratingStream;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.common.DataNodeBuildHelper;
import ai.timefold.solver.core.impl.score.director.SessionContext;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class DatasetSessionFactory<Solution_> {
    private final EnumeratingStreamFactory<Solution_> enumeratingStreamFactory;

    public DatasetSessionFactory(EnumeratingStreamFactory<Solution_> enumeratingStreamFactory) {
        this.enumeratingStreamFactory = enumeratingStreamFactory;
    }

    public DatasetSession<Solution_> buildSession(SessionContext<Solution_> context) {
        LinkedHashSet activeEnumeratingStreamSet = new LinkedHashSet();
        List<AbstractDataset<Solution_>> datasets = this.enumeratingStreamFactory.getDatasets();
        for (AbstractDataset dataset : datasets) {
            dataset.collectActiveEnumeratingStreams(activeEnumeratingStreamSet);
        }
        DataNodeBuildHelper<Solution_> buildHelper = new DataNodeBuildHelper<Solution_>(context, activeEnumeratingStreamSet);
        DatasetSession<Solution_> session = new DatasetSession<Solution_>(this.buildNodeNetwork(activeEnumeratingStreamSet, buildHelper, null));
        for (AbstractDatasetInstance<Solution_, ?> datasetInstance : buildHelper.getDatasetInstanceList()) {
            session.registerDatasetInstance(datasetInstance.getParent(), datasetInstance);
        }
        return session;
    }

    private NodeNetwork buildNodeNetwork(Set<AbstractEnumeratingStream<Solution_>> enumeratingStreamSet, DataNodeBuildHelper<Solution_> buildHelper, @Nullable Consumer<String> nodeNetworkVisualizationConsumer) {
        LinkedHashMap declaredClassToNodeMap = new LinkedHashMap();
        List<AbstractNode> nodeList = buildHelper.buildNodeList(enumeratingStreamSet, buildHelper, AbstractEnumeratingStream::buildNode, node -> {
            if (!(node instanceof AbstractForEachUniNode)) {
                return;
            }
            AbstractForEachUniNode forEachUniNode = (AbstractForEachUniNode)node;
            Class forEachClass = forEachUniNode.getForEachClass();
            List forEachUniNodeList = declaredClassToNodeMap.computeIfAbsent(forEachClass, k -> new ArrayList(2));
            if (forEachUniNodeList.size() == 2) {
                throw new IllegalStateException("Impossible state: For class (%s) there are already 2 nodes (%s), not adding another (%s).".formatted(forEachClass, forEachUniNodeList, forEachUniNode));
            }
            forEachUniNodeList.add(forEachUniNode);
        });
        if (nodeNetworkVisualizationConsumer != null) {
            throw new UnsupportedOperationException("Not implemented yet");
        }
        return AbstractNodeBuildHelper.buildNodeNetwork(nodeList, declaredClassToNodeMap);
    }
}

