/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.neighborhood.move;

import ai.timefold.solver.core.impl.neighborhood.maybeapi.NeighborhoodSession;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.move.BiMoveConstructor;
import ai.timefold.solver.core.impl.neighborhood.move.BiMoveStreamContext;
import ai.timefold.solver.core.impl.neighborhood.move.BiOriginalMoveIterator;
import ai.timefold.solver.core.impl.neighborhood.move.BiRandomMoveIterator;
import ai.timefold.solver.core.impl.neighborhood.move.InnerMoveStream;
import ai.timefold.solver.core.impl.neighborhood.move.MoveIterable;
import ai.timefold.solver.core.impl.neighborhood.stream.DefaultNeighborhoodSession;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.uni.UniLeftDataset;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.uni.UniRightDataset;
import ai.timefold.solver.core.preview.api.move.Move;
import java.util.Iterator;
import java.util.Objects;
import java.util.Random;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class BiMoveStream<Solution_, A, B>
implements InnerMoveStream<Solution_> {
    private final UniLeftDataset<Solution_, A> leftDataset;
    private final UniRightDataset<Solution_, A, B> rightDataset;
    private final BiMoveConstructor<Solution_, A, B> moveConstructor;

    public BiMoveStream(UniLeftDataset<Solution_, A> leftDataset, UniRightDataset<Solution_, A, B> rightDataset, BiMoveConstructor<Solution_, A, B> moveConstructor) {
        this.leftDataset = Objects.requireNonNull(leftDataset);
        this.rightDataset = Objects.requireNonNull(rightDataset);
        this.moveConstructor = Objects.requireNonNull(moveConstructor);
    }

    @Override
    public MoveIterable<Solution_> getMoveIterable(NeighborhoodSession neighborhoodSession) {
        BiMoveStreamContext<Solution_, A, B> context = new BiMoveStreamContext<Solution_, A, B>((DefaultNeighborhoodSession)neighborhoodSession, this.leftDataset, this.rightDataset, this.moveConstructor);
        return new BiMoveIterable<Solution_, A, B>(context);
    }

    private record BiMoveIterable<Solution_, A, B>(BiMoveStreamContext<Solution_, A, B> context) implements MoveIterable<Solution_>
    {
        private BiMoveIterable(BiMoveStreamContext<Solution_, A, B> context) {
            this.context = Objects.requireNonNull(context);
        }

        @Override
        public Iterator<Move<Solution_>> iterator() {
            return new BiOriginalMoveIterator<Solution_, A, B>(this.context);
        }

        @Override
        public Iterator<Move<Solution_>> iterator(Random random) {
            return new BiRandomMoveIterator<Solution_, A, B>(this.context, random);
        }
    }
}

