/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.neighborhood.maybeapi.move;

import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.DefaultPlanningSolutionMetaModel;
import ai.timefold.solver.core.impl.domain.solution.descriptor.DefaultPlanningVariableMetaModel;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.MoveDefinition;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.MoveStream;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.MoveStreamFactory;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.move.BiMoveConstructor;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.move.Moves;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.stream.enumerating.EnumeratingJoiners;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.stream.enumerating.UniEnumeratingStream;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningEntityMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.VariableMetaModel;
import ai.timefold.solver.core.preview.api.move.Move;
import ai.timefold.solver.core.preview.api.move.SolutionView;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class SwapMoveDefinition<Solution_, Entity_>
implements MoveDefinition<Solution_> {
    private final PlanningEntityMetaModel<Solution_, Entity_> entityMetaModel;
    private final List<PlanningVariableMetaModel<Solution_, Entity_, Object>> variableMetaModelList;
    private final @Nullable Function<Entity_, Comparable> planningIdGetter;

    public SwapMoveDefinition(PlanningEntityMetaModel<Solution_, Entity_> entityMetaModel) {
        this.entityMetaModel = Objects.requireNonNull(entityMetaModel);
        this.variableMetaModelList = entityMetaModel.variables().stream().flatMap(v -> {
            if (v instanceof PlanningVariableMetaModel) {
                PlanningVariableMetaModel planningVariableMetaModel = (PlanningVariableMetaModel)v;
                return Stream.of(planningVariableMetaModel);
            }
            return Stream.empty();
        }).toList();
        if (this.variableMetaModelList.isEmpty()) {
            throw new IllegalArgumentException("The entityClass (%s) has no basic planning variables.".formatted(entityMetaModel.type().getCanonicalName()));
        }
        this.planningIdGetter = SwapMoveDefinition.getPlanningIdGetter(entityMetaModel);
    }

    static <Solution_, Entity_> @Nullable Function<Entity_, Comparable> getPlanningIdGetter(PlanningEntityMetaModel<Solution_, Entity_> metaModel) {
        SolutionDescriptor solutionDescriptor = ((DefaultPlanningSolutionMetaModel)metaModel.solution()).solutionDescriptor();
        MemberAccessor planningIdMemberAccessor = solutionDescriptor.getPlanningIdAccessor(metaModel.type());
        if (planningIdMemberAccessor == null) {
            return null;
        }
        return planningIdMemberAccessor.getGetterFunction();
    }

    public SwapMoveDefinition(List<PlanningVariableMetaModel<Solution_, Entity_, Object>> variableMetaModelList) {
        this.variableMetaModelList = Objects.requireNonNull(variableMetaModelList);
        List<PlanningEntityMetaModel> entityMetaModels = variableMetaModelList.stream().map(VariableMetaModel::entity).distinct().toList();
        switch (entityMetaModels.size()) {
            case 0: {
                throw new IllegalArgumentException("The variableMetaModelList (%s) is empty.".formatted(variableMetaModelList));
            }
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("The variableMetaModelList (%s) contains variables from multiple entity classes.".formatted(variableMetaModelList));
            }
        }
        this.entityMetaModel = entityMetaModels.get(0);
        this.planningIdGetter = SwapMoveDefinition.getPlanningIdGetter(this.entityMetaModel);
    }

    @Override
    public MoveStream<Solution_> build(MoveStreamFactory<Solution_> moveStreamFactory) {
        Class<Entity_> entityType = this.entityMetaModel.type();
        UniEnumeratingStream<Solution_, Entity_> entityStream = moveStreamFactory.forEach(entityType, false);
        BiMoveConstructor moveConstructor = this::buildMove;
        if (this.planningIdGetter == null) {
            return moveStreamFactory.pick(entityStream).pick(entityStream, EnumeratingJoiners.filtering(this::isValidSwap)).asMove(moveConstructor);
        }
        return moveStreamFactory.pick(entityStream).pick(entityStream, EnumeratingJoiners.lessThan(this.planningIdGetter), EnumeratingJoiners.filtering(this::isValidSwap)).asMove(moveConstructor);
    }

    private Move<Solution_> buildMove(SolutionView<Solution_> solutionView, Entity_ a, Entity_ b) {
        return Moves.swap(this.variableMetaModelList, a, b);
    }

    private boolean isValidSwap(SolutionView<Solution_> solutionView, Entity_ leftEntity, Entity_ rightEntity) {
        if (leftEntity == rightEntity) {
            return false;
        }
        boolean change = false;
        for (PlanningVariableMetaModel<Solution_, Entity_, Object> variableMetaModel : this.variableMetaModelList) {
            Object oldRightValue;
            DefaultPlanningVariableMetaModel defaultVariableMetaModel = (DefaultPlanningVariableMetaModel)variableMetaModel;
            GenuineVariableDescriptor variableDescriptor = defaultVariableMetaModel.variableDescriptor();
            Object oldLeftValue = variableDescriptor.getValue(leftEntity);
            if (Objects.equals(oldLeftValue, oldRightValue = variableDescriptor.getValue(rightEntity))) continue;
            if (solutionView.isValueInRange(variableMetaModel, leftEntity, oldRightValue) && solutionView.isValueInRange(variableMetaModel, rightEntity, oldLeftValue)) {
                change = true;
                continue;
            }
            return false;
        }
        return change;
    }
}

