/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.neighborhood.maybeapi.move;

import ai.timefold.solver.core.impl.neighborhood.maybeapi.MoveDefinition;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.MoveStream;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.MoveStreamFactory;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.move.Moves;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.stream.enumerating.EnumeratingJoiners;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.stream.enumerating.UniEnumeratingStream;
import ai.timefold.solver.core.preview.api.domain.metamodel.ElementPosition;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningListVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PositionInList;
import ai.timefold.solver.core.preview.api.domain.metamodel.UnassignedElement;
import ai.timefold.solver.core.preview.api.move.SolutionView;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ListChangeMoveDefinition<Solution_, Entity_, Value_>
implements MoveDefinition<Solution_> {
    private final PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel;

    public ListChangeMoveDefinition(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel) {
        this.variableMetaModel = Objects.requireNonNull(variableMetaModel);
    }

    @Override
    public MoveStream<Solution_> build(MoveStreamFactory<Solution_> moveStreamFactory) {
        UniEnumeratingStream<Solution_, ElementPosition> entityValuePairs = moveStreamFactory.forEachAssignablePosition(this.variableMetaModel);
        UniEnumeratingStream availableValues = moveStreamFactory.forEach(this.variableMetaModel.type(), false);
        return moveStreamFactory.pick(entityValuePairs).pick(availableValues, EnumeratingJoiners.filtering(this::isValidChange)).asMove((solutionView, targetPosition, value) -> {
            ElementPosition currentPosition = solutionView.getPositionOf(this.variableMetaModel, Objects.requireNonNull(value));
            if (targetPosition instanceof UnassignedElement) {
                PositionInList currentElementPosition = currentPosition.ensureAssigned();
                return Moves.unassign(this.variableMetaModel, currentElementPosition);
            }
            PositionInList targetElementPosition = Objects.requireNonNull(targetPosition).ensureAssigned();
            if (currentPosition instanceof UnassignedElement) {
                return Moves.assign(this.variableMetaModel, value, targetElementPosition);
            }
            PositionInList currentElementPosition = currentPosition.ensureAssigned();
            return Moves.change(this.variableMetaModel, currentElementPosition, targetElementPosition);
        });
    }

    private boolean isValidChange(SolutionView<Solution_> solutionView, ElementPosition targetPosition, Value_ value) {
        ElementPosition currentPosition = solutionView.getPositionOf(this.variableMetaModel, value);
        if (currentPosition.equals(targetPosition)) {
            return false;
        }
        if (currentPosition instanceof UnassignedElement) {
            PositionInList targetPositionInList = targetPosition.ensureAssigned();
            return solutionView.isValueInRange(this.variableMetaModel, targetPositionInList.entity(), value);
        }
        if (!(targetPosition instanceof PositionInList)) {
            return true;
        }
        PositionInList targetPositionInList = (PositionInList)targetPosition;
        PositionInList currentPositionInList = currentPosition.ensureAssigned();
        if (currentPositionInList.entity() == targetPositionInList.entity()) {
            int valueCount = solutionView.countValues(this.variableMetaModel, currentPositionInList.entity());
            if (valueCount == 1) {
                return false;
            }
            if (targetPositionInList.index() == valueCount) {
                return false;
            }
            return currentPositionInList.index() != targetPositionInList.index();
        }
        return solutionView.isValueInRange(this.variableMetaModel, targetPositionInList.entity(), value);
    }
}

