/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.neighborhood;

import ai.timefold.solver.core.impl.neighborhood.move.MoveIterable;
import ai.timefold.solver.core.preview.api.move.Move;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.stream.Collectors;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class RandomOrderNeighborhoodIterator<Solution_>
implements Iterator<Move<Solution_>> {
    private final List<Iterator<Move<Solution_>>> unexhaustedMoveIteratorList;
    private final Random workingRandom;
    private @Nullable Iterator<Move<Solution_>> currentMoveIterator;
    private boolean hasNext = true;

    public RandomOrderNeighborhoodIterator(List<MoveIterable<Solution_>> moveIterableList, Random workingRandom) {
        this.unexhaustedMoveIteratorList = moveIterableList.stream().map(m -> m.iterator(workingRandom)).collect(Collectors.toList());
        this.workingRandom = workingRandom;
    }

    @Override
    public boolean hasNext() {
        if (!this.hasNext) {
            return false;
        }
        while (!this.unexhaustedMoveIteratorList.isEmpty()) {
            int randomIndex = this.workingRandom.nextInt(this.unexhaustedMoveIteratorList.size());
            this.currentMoveIterator = this.unexhaustedMoveIteratorList.get(randomIndex);
            if (this.currentMoveIterator.hasNext()) {
                this.hasNext = true;
                return true;
            }
            this.unexhaustedMoveIteratorList.remove(randomIndex);
        }
        this.hasNext = false;
        return false;
    }

    @Override
    public Move<Solution_> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.currentMoveIterator.next();
    }
}

