/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.neighborhood;

import ai.timefold.solver.core.impl.neighborhood.move.MoveIterable;
import ai.timefold.solver.core.preview.api.move.Move;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class OriginalOrderNeighborhoodIterator<Solution_>
implements Iterator<Move<Solution_>> {
    private final Queue<MoveIterable<Solution_>> availableIteratorQueue;
    private @Nullable Iterator<Move<Solution_>> currentMoveIterator = null;

    public OriginalOrderNeighborhoodIterator(List<MoveIterable<Solution_>> moveIterables) {
        this.availableIteratorQueue = new ArrayDeque<MoveIterable<Solution_>>(moveIterables);
    }

    @Override
    public boolean hasNext() {
        if (this.currentMoveIterator != null && this.currentMoveIterator.hasNext()) {
            return true;
        }
        while (!this.availableIteratorQueue.isEmpty()) {
            MoveIterable<Solution_> nextIterable = this.availableIteratorQueue.poll();
            this.currentMoveIterator = nextIterable.iterator();
            if (!this.currentMoveIterator.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Move<Solution_> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.currentMoveIterator.next();
    }
}

