/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.localsearch.decider;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.impl.heuristic.move.MoveAdapters;
import ai.timefold.solver.core.impl.localsearch.decider.acceptor.Acceptor;
import ai.timefold.solver.core.impl.localsearch.decider.forager.LocalSearchForager;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchMoveScope;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchPhaseScope;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchStepScope;
import ai.timefold.solver.core.impl.move.director.MoveDirector;
import ai.timefold.solver.core.impl.neighborhood.MoveRepository;
import ai.timefold.solver.core.impl.phase.scope.SolverLifecyclePoint;
import ai.timefold.solver.core.impl.score.director.InnerScore;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.solver.termination.PhaseTermination;
import ai.timefold.solver.core.impl.solver.termination.Termination;
import ai.timefold.solver.core.preview.api.move.Move;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSearchDecider<Solution_> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final String logIndentation;
    protected final PhaseTermination<Solution_> termination;
    protected final MoveRepository<Solution_> moveRepository;
    protected final Acceptor<Solution_> acceptor;
    protected final LocalSearchForager<Solution_> forager;
    protected boolean assertMoveScoreFromScratch = false;
    protected boolean assertExpectedUndoMoveScore = false;

    public LocalSearchDecider(String logIndentation, PhaseTermination<Solution_> termination, MoveRepository<Solution_> moveRepository, Acceptor<Solution_> acceptor, LocalSearchForager<Solution_> forager) {
        this.logIndentation = logIndentation;
        this.termination = termination;
        this.moveRepository = moveRepository;
        this.acceptor = acceptor;
        this.forager = forager;
    }

    public Termination<Solution_> getTermination() {
        return this.termination;
    }

    public MoveRepository<Solution_> getMoveRepository() {
        return this.moveRepository;
    }

    public Acceptor<Solution_> getAcceptor() {
        return this.acceptor;
    }

    public LocalSearchForager<Solution_> getForager() {
        return this.forager;
    }

    public void enableAssertions(EnvironmentMode environmentMode) {
        this.assertMoveScoreFromScratch = environmentMode.isFullyAsserted();
        this.assertExpectedUndoMoveScore = environmentMode.isIntrusivelyAsserted();
    }

    public void solvingStarted(SolverScope<Solution_> solverScope) {
        this.moveRepository.solvingStarted(solverScope);
        this.acceptor.solvingStarted(solverScope);
        this.forager.solvingStarted(solverScope);
    }

    public void phaseStarted(LocalSearchPhaseScope<Solution_> phaseScope) {
        this.moveRepository.phaseStarted(phaseScope);
        this.acceptor.phaseStarted(phaseScope);
        this.forager.phaseStarted(phaseScope);
    }

    public void stepStarted(LocalSearchStepScope<Solution_> stepScope) {
        this.moveRepository.stepStarted(stepScope);
        this.acceptor.stepStarted(stepScope);
        this.forager.stepStarted(stepScope);
    }

    public void decideNextStep(LocalSearchStepScope<Solution_> stepScope) {
        InnerScoreDirector scoreDirector = stepScope.getScoreDirector();
        scoreDirector.setAllChangesWillBeUndoneBeforeStepEnds(true);
        int moveIndex = 0;
        for (Move move : this.moveRepository) {
            LocalSearchMoveScope<Solution_> moveScope = new LocalSearchMoveScope<Solution_>(stepScope, moveIndex, move);
            ++moveIndex;
            this.doMove(moveScope);
            if (this.forager.isQuitEarly()) break;
            stepScope.getPhaseScope().getSolverScope().checkYielding();
            if (!this.termination.isPhaseTerminated(stepScope.getPhaseScope())) continue;
            break;
        }
        scoreDirector.setAllChangesWillBeUndoneBeforeStepEnds(false);
        this.pickMove(stepScope);
    }

    protected <Score_ extends Score<Score_>> void doMove(LocalSearchMoveScope<Solution_> moveScope) {
        Move move;
        InnerScoreDirector scoreDirector = moveScope.getScoreDirector();
        MoveDirector moveDirector = moveScope.getStepScope().getMoveDirector();
        if (!MoveAdapters.isDoable(moveDirector, move = moveScope.getMove())) {
            throw new IllegalStateException("Impossible state: Local search move selector (%s) provided a non-doable move (%s).".formatted(this.moveRepository, move));
        }
        InnerScore score = scoreDirector.executeTemporaryMove(moveScope.getMove(), this.assertMoveScoreFromScratch);
        moveScope.setScore(score);
        moveScope.setAccepted(this.acceptor.isAccepted(moveScope));
        this.forager.addMove(moveScope);
        if (this.assertExpectedUndoMoveScore) {
            scoreDirector.assertExpectedUndoMoveScore(moveScope.getMove(), ((LocalSearchPhaseScope)((LocalSearchStepScope)moveScope.getStepScope()).getPhaseScope()).getLastCompletedStepScope().getScore(), SolverLifecyclePoint.of(moveScope));
        }
        this.logger.trace("{}        Move index ({}), score ({}), accepted ({}), move ({}).", new Object[]{this.logIndentation, moveScope.getMoveIndex(), moveScope.getScore().raw(), moveScope.getAccepted(), moveScope.getMove()});
    }

    protected void pickMove(LocalSearchStepScope<Solution_> stepScope) {
        LocalSearchMoveScope<Solution_> pickedMoveScope = this.forager.pickMove(stepScope);
        if (pickedMoveScope != null) {
            Move step = pickedMoveScope.getMove();
            stepScope.setStep(step);
            if (this.logger.isDebugEnabled()) {
                stepScope.setStepString(step.toString());
            }
            stepScope.setScore(pickedMoveScope.getScore());
        }
    }

    public void stepEnded(LocalSearchStepScope<Solution_> stepScope) {
        this.moveRepository.stepEnded(stepScope);
        this.acceptor.stepEnded(stepScope);
        this.forager.stepEnded(stepScope);
    }

    public void phaseEnded(LocalSearchPhaseScope<Solution_> phaseScope) {
        this.moveRepository.phaseEnded(phaseScope);
        this.acceptor.phaseEnded(phaseScope);
        this.forager.phaseEnded(phaseScope);
    }

    public void solvingEnded(SolverScope<Solution_> solverScope) {
        this.moveRepository.solvingEnded(solverScope);
        this.acceptor.solvingEnded(solverScope);
        this.forager.solvingEnded(solverScope);
    }

    public void solvingError(SolverScope<Solution_> solverScope, Exception exception) {
    }
}

