/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.localsearch;

import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.move.MoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.NearbyAutoConfigurationEnabled;
import ai.timefold.solver.core.config.heuristic.selector.move.composite.UnionMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.ChangeMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.SwapMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.chained.TailChainSwapMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.list.ListChangeMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.list.ListSwapMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.list.kopt.KOptListMoveSelectorConfig;
import ai.timefold.solver.core.config.localsearch.LocalSearchPhaseConfig;
import ai.timefold.solver.core.config.localsearch.LocalSearchType;
import ai.timefold.solver.core.config.localsearch.decider.acceptor.AcceptorType;
import ai.timefold.solver.core.config.localsearch.decider.acceptor.LocalSearchAcceptorConfig;
import ai.timefold.solver.core.config.localsearch.decider.forager.LocalSearchForagerConfig;
import ai.timefold.solver.core.config.localsearch.decider.forager.LocalSearchPickEarlyType;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.config.solver.PreviewFeature;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.enterprise.TimefoldSolverEnterpriseService;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.BasicVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.selector.move.AbstractMoveSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.composite.UnionMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.composite.UnionMoveSelectorFactory;
import ai.timefold.solver.core.impl.localsearch.DefaultLocalSearchPhase;
import ai.timefold.solver.core.impl.localsearch.LocalSearchPhase;
import ai.timefold.solver.core.impl.localsearch.decider.LocalSearchDecider;
import ai.timefold.solver.core.impl.localsearch.decider.acceptor.Acceptor;
import ai.timefold.solver.core.impl.localsearch.decider.acceptor.AcceptorFactory;
import ai.timefold.solver.core.impl.localsearch.decider.forager.LocalSearchForager;
import ai.timefold.solver.core.impl.localsearch.decider.forager.LocalSearchForagerFactory;
import ai.timefold.solver.core.impl.neighborhood.MoveRepository;
import ai.timefold.solver.core.impl.neighborhood.MoveSelectorBasedMoveRepository;
import ai.timefold.solver.core.impl.neighborhood.NeighborhoodsBasedMoveRepository;
import ai.timefold.solver.core.impl.neighborhood.NeighborhoodsMoveSelector;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.NeighborhoodProvider;
import ai.timefold.solver.core.impl.neighborhood.stream.DefaultMoveStreamFactory;
import ai.timefold.solver.core.impl.neighborhood.stream.DefaultNeighborhood;
import ai.timefold.solver.core.impl.neighborhood.stream.DefaultNeighborhoodBuilder;
import ai.timefold.solver.core.impl.phase.AbstractPhaseFactory;
import ai.timefold.solver.core.impl.solver.recaller.BestSolutionRecaller;
import ai.timefold.solver.core.impl.solver.termination.PhaseTermination;
import ai.timefold.solver.core.impl.solver.termination.SolverTermination;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningEntityMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningSolutionMetaModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class DefaultLocalSearchPhaseFactory<Solution_>
extends AbstractPhaseFactory<Solution_, LocalSearchPhaseConfig> {
    public DefaultLocalSearchPhaseFactory(LocalSearchPhaseConfig phaseConfig) {
        super(phaseConfig);
    }

    @Override
    public LocalSearchPhase<Solution_> buildPhase(int phaseIndex, boolean lastInitializingPhase, HeuristicConfigPolicy<Solution_> solverConfigPolicy, BestSolutionRecaller<Solution_> bestSolutionRecaller, SolverTermination<Solution_> solverTermination) {
        HeuristicConfigPolicy<Solution_> phaseConfigPolicy = solverConfigPolicy.createPhaseConfigPolicy();
        PhaseTermination<Solution_> phaseTermination = this.buildPhaseTermination(phaseConfigPolicy, solverTermination);
        LocalSearchDecider<Solution_> decider = this.buildDecider(phaseConfigPolicy, phaseTermination);
        return ((DefaultLocalSearchPhase.Builder)new DefaultLocalSearchPhase.Builder<Solution_>(phaseIndex, solverConfigPolicy.getLogIndentation(), phaseTermination, decider).enableAssertions(phaseConfigPolicy.getEnvironmentMode())).build();
    }

    private LocalSearchDecider<Solution_> buildDecider(HeuristicConfigPolicy<Solution_> phaseConfigPolicy, PhaseTermination<Solution_> phaseTermination) {
        MoveSelectorConfig moveSelectorConfig;
        boolean moveSelectorsEnabled;
        boolean neighborhoodsEnabled;
        Class neighborhoodProviderClass = ((LocalSearchPhaseConfig)this.phaseConfig).getNeighborhoodProviderClass();
        boolean bl = neighborhoodsEnabled = neighborhoodProviderClass != null;
        if (neighborhoodsEnabled) {
            phaseConfigPolicy.ensurePreviewFeature(PreviewFeature.NEIGHBORHOODS);
        }
        boolean bl2 = moveSelectorsEnabled = (moveSelectorConfig = ((LocalSearchPhaseConfig)this.phaseConfig).getMoveSelectorConfig()) != null;
        if (moveSelectorsEnabled) {
            if (!neighborhoodsEnabled) {
                return this.buildMoveSelectorBasedDecider(phaseConfigPolicy, phaseTermination);
            }
            return this.buildMixedDecider(phaseConfigPolicy, phaseTermination, neighborhoodProviderClass);
        }
        if (neighborhoodsEnabled) {
            return this.buildNeighborhoodsBasedDecider(phaseConfigPolicy, phaseTermination, neighborhoodProviderClass);
        }
        return this.buildMoveSelectorBasedDecider(phaseConfigPolicy, phaseTermination);
    }

    private LocalSearchDecider<Solution_> buildMoveSelectorBasedDecider(HeuristicConfigPolicy<Solution_> configPolicy, PhaseTermination<Solution_> termination) {
        MoveSelectorBasedMoveRepository<Solution_> moveRepository = new MoveSelectorBasedMoveRepository<Solution_>(this.buildMoveSelector(configPolicy));
        return this.buildDecider(moveRepository, configPolicy, termination);
    }

    private LocalSearchDecider<Solution_> buildNeighborhoodsBasedDecider(HeuristicConfigPolicy<Solution_> configPolicy, PhaseTermination<Solution_> termination, Class<? extends NeighborhoodProvider<Solution_>> neighborhoodProviderClass) {
        return this.buildDecider(this.buildNeighborhoodsBasedMoveRepository(configPolicy, neighborhoodProviderClass), configPolicy, termination);
    }

    private NeighborhoodsBasedMoveRepository<Solution_> buildNeighborhoodsBasedMoveRepository(HeuristicConfigPolicy<Solution_> configPolicy, Class<? extends NeighborhoodProvider<Solution_>> neighborhoodProviderClass) {
        SolutionDescriptor<Solution_> solutionDescriptor = configPolicy.getSolutionDescriptor();
        PlanningSolutionMetaModel<Solution_> solutionMetaModel = solutionDescriptor.getMetaModel();
        if (solutionMetaModel.genuineEntities().size() > 1) {
            throw new UnsupportedOperationException("Neighborhoods API currently only supports solutions with a single entity class, not multiple.");
        }
        PlanningEntityMetaModel<Solution_, ?> entityMetaModel = solutionMetaModel.genuineEntities().get(0);
        if (entityMetaModel.genuineVariables().size() > 1) {
            throw new UnsupportedOperationException("Neighborhoods API currently only supports solutions with a single variable class, not multiple.");
        }
        if (!NeighborhoodProvider.class.isAssignableFrom(neighborhoodProviderClass)) {
            throw new IllegalArgumentException("The neighborhoodProviderClass (%s) does not implement %s.".formatted(neighborhoodProviderClass, NeighborhoodProvider.class.getSimpleName()));
        }
        NeighborhoodProvider<Solution_> neighborhoodProvider = ConfigUtils.newInstance(LocalSearchPhaseConfig.class::getSimpleName, "neighborhoodProviderClass", neighborhoodProviderClass);
        DefaultNeighborhoodBuilder<Solution_> neighborhoodBuilder = new DefaultNeighborhoodBuilder<Solution_>(solutionMetaModel);
        DefaultMoveStreamFactory<Solution_> moveStreamFactory = new DefaultMoveStreamFactory<Solution_>(solutionDescriptor, configPolicy.getEnvironmentMode());
        List moveDefinitionList = ((DefaultNeighborhood)neighborhoodProvider.defineNeighborhood(neighborhoodBuilder)).getMoveDefinitionList();
        return new NeighborhoodsBasedMoveRepository<Solution_>(moveStreamFactory, moveDefinitionList, this.pickSelectionOrder() == SelectionOrder.RANDOM);
    }

    private LocalSearchDecider<Solution_> buildMixedDecider(HeuristicConfigPolicy<Solution_> configPolicy, PhaseTermination<Solution_> termination, Class<? extends NeighborhoodProvider<Solution_>> neighborhoodProviderClass) {
        NeighborhoodsMoveSelector<Solution_> neighborhoodsMoveSelector = new NeighborhoodsMoveSelector<Solution_>(this.buildNeighborhoodsBasedMoveRepository(configPolicy, neighborhoodProviderClass));
        MoveSelector<Solution_> legacyMoveSelector = this.buildMoveSelector(configPolicy);
        if (legacyMoveSelector instanceof UnionMoveSelector) {
            UnionMoveSelector unionMoveSelector = (UnionMoveSelector)legacyMoveSelector;
            if (unionMoveSelector.getSelectorProbabilityWeightFactory() != null) {
                throw new UnsupportedOperationException("Probability-weighted move selectors are not supported together with the Neighborhoods API.");
            }
            ArrayList moveSelectorList = new ArrayList(unionMoveSelector.getChildMoveSelectorList());
            moveSelectorList.add(neighborhoodsMoveSelector);
            UnionMoveSelector finalMoveSelector = new UnionMoveSelector(moveSelectorList, this.pickSelectionOrder() == SelectionOrder.RANDOM);
            MoveSelectorBasedMoveRepository moveRepository = new MoveSelectorBasedMoveRepository(finalMoveSelector);
            return this.buildDecider(moveRepository, configPolicy, termination);
        }
        UnionMoveSelector<Solution_> unionMoveSelector = new UnionMoveSelector<Solution_>(List.of(neighborhoodsMoveSelector, legacyMoveSelector), this.pickSelectionOrder() == SelectionOrder.RANDOM);
        MoveSelectorBasedMoveRepository<Solution_> moveRepository = new MoveSelectorBasedMoveRepository<Solution_>(unionMoveSelector);
        return this.buildDecider(moveRepository, configPolicy, termination);
    }

    private LocalSearchDecider<Solution_> buildDecider(MoveRepository<Solution_> moveRepository, HeuristicConfigPolicy<Solution_> configPolicy, PhaseTermination<Solution_> termination) {
        Acceptor<Solution_> acceptor = this.buildAcceptor(configPolicy, moveRepository instanceof NeighborhoodsBasedMoveRepository);
        LocalSearchForager<Solution_> forager = this.buildForager(configPolicy);
        if (moveRepository.isNeverEnding() && !forager.supportsNeverEndingMoveSelector()) {
            throw new IllegalStateException("The move repository (%s) is neverEnding (%s), but the forager (%s) does not support it.\nMaybe configure the <forager> with an <acceptedCountLimit>.".formatted(moveRepository, moveRepository.isNeverEnding(), forager));
        }
        Integer moveThreadCount = configPolicy.getMoveThreadCount();
        EnvironmentMode environmentMode = configPolicy.getEnvironmentMode();
        LocalSearchDecider<Solution_> decider = moveThreadCount == null ? new LocalSearchDecider<Solution_>(configPolicy.getLogIndentation(), termination, moveRepository, acceptor, forager) : TimefoldSolverEnterpriseService.loadOrFail(TimefoldSolverEnterpriseService.Feature.MULTITHREADED_SOLVING).buildLocalSearch(moveThreadCount, termination, moveRepository, acceptor, forager, environmentMode, configPolicy);
        decider.enableAssertions(environmentMode);
        return decider;
    }

    protected Acceptor<Solution_> buildAcceptor(HeuristicConfigPolicy<Solution_> configPolicy, boolean neighborhoodsEnabled) {
        AcceptorType acceptorType;
        LocalSearchAcceptorConfig acceptorConfig = ((LocalSearchPhaseConfig)this.phaseConfig).getAcceptorConfig();
        LocalSearchType localSearchType = ((LocalSearchPhaseConfig)this.phaseConfig).getLocalSearchType();
        if (acceptorConfig != null) {
            if (localSearchType != null) {
                throw new IllegalArgumentException("The localSearchType (%s) must not be configured if the acceptorConfig (%s) is explicitly configured.".formatted(new Object[]{localSearchType, acceptorConfig}));
            }
            return this.buildAcceptor(acceptorConfig, configPolicy);
        }
        LocalSearchType localSearchType_ = Objects.requireNonNullElse(localSearchType, LocalSearchType.LATE_ACCEPTANCE);
        LocalSearchAcceptorConfig acceptorConfig_ = new LocalSearchAcceptorConfig();
        if (neighborhoodsEnabled && localSearchType_ == LocalSearchType.VARIABLE_NEIGHBORHOOD_DESCENT) {
            throw new UnsupportedOperationException("Variable Neighborhood descent is not yet supported with the Neighborhoods API.");
        }
        switch (localSearchType_) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case HILL_CLIMBING: 
            case VARIABLE_NEIGHBORHOOD_DESCENT: {
                AcceptorType acceptorType2 = AcceptorType.HILL_CLIMBING;
                break;
            }
            case TABU_SEARCH: {
                AcceptorType acceptorType2 = AcceptorType.ENTITY_TABU;
                break;
            }
            case SIMULATED_ANNEALING: {
                AcceptorType acceptorType2 = AcceptorType.SIMULATED_ANNEALING;
                break;
            }
            case LATE_ACCEPTANCE: {
                AcceptorType acceptorType2 = AcceptorType.LATE_ACCEPTANCE;
                break;
            }
            case DIVERSIFIED_LATE_ACCEPTANCE: {
                AcceptorType acceptorType2 = AcceptorType.DIVERSIFIED_LATE_ACCEPTANCE;
                break;
            }
            case GREAT_DELUGE: {
                AcceptorType acceptorType2 = acceptorType = AcceptorType.GREAT_DELUGE;
            }
        }
        if (neighborhoodsEnabled && acceptorType.isTabu()) {
            throw new UnsupportedOperationException("Tabu search is not yet supported with the Neighborhoods API.");
        }
        acceptorConfig_.setAcceptorTypeList(Collections.singletonList(acceptorType));
        return this.buildAcceptor(acceptorConfig_, configPolicy);
    }

    private Acceptor<Solution_> buildAcceptor(LocalSearchAcceptorConfig acceptorConfig, HeuristicConfigPolicy<Solution_> configPolicy) {
        return AcceptorFactory.create(acceptorConfig).buildAcceptor(configPolicy);
    }

    protected LocalSearchForager<Solution_> buildForager(HeuristicConfigPolicy<Solution_> configPolicy) {
        LocalSearchForagerConfig foragerConfig_;
        if (((LocalSearchPhaseConfig)this.phaseConfig).getForagerConfig() != null) {
            if (((LocalSearchPhaseConfig)this.phaseConfig).getLocalSearchType() != null) {
                throw new IllegalArgumentException("The localSearchType (%s) must not be configured if the foragerConfig (%s) is explicitly configured.".formatted(new Object[]{((LocalSearchPhaseConfig)this.phaseConfig).getLocalSearchType(), ((LocalSearchPhaseConfig)this.phaseConfig).getForagerConfig()}));
            }
            foragerConfig_ = ((LocalSearchPhaseConfig)this.phaseConfig).getForagerConfig();
        } else {
            LocalSearchType localSearchType_ = Objects.requireNonNullElse(((LocalSearchPhaseConfig)this.phaseConfig).getLocalSearchType(), LocalSearchType.LATE_ACCEPTANCE);
            foragerConfig_ = new LocalSearchForagerConfig();
            switch (localSearchType_) {
                case HILL_CLIMBING: {
                    foragerConfig_.setAcceptedCountLimit(1);
                    break;
                }
                case TABU_SEARCH: {
                    foragerConfig_.setAcceptedCountLimit(1000);
                    break;
                }
                case SIMULATED_ANNEALING: 
                case LATE_ACCEPTANCE: 
                case DIVERSIFIED_LATE_ACCEPTANCE: 
                case GREAT_DELUGE: {
                    foragerConfig_.setAcceptedCountLimit(1);
                    break;
                }
                case VARIABLE_NEIGHBORHOOD_DESCENT: {
                    foragerConfig_.setPickEarlyType(LocalSearchPickEarlyType.FIRST_LAST_STEP_SCORE_IMPROVING);
                    break;
                }
                default: {
                    throw new IllegalStateException("The localSearchType (%s) is not implemented.".formatted(new Object[]{localSearchType_}));
                }
            }
        }
        return LocalSearchForagerFactory.create(foragerConfig_).buildForager();
    }

    private MoveSelector<Solution_> buildMoveSelector(HeuristicConfigPolicy<Solution_> configPolicy) {
        MoveSelector<Solution_> moveSelector;
        SelectionCacheType defaultCacheType = SelectionCacheType.JUST_IN_TIME;
        SelectionOrder defaultSelectionOrder = this.pickSelectionOrder();
        MoveSelectorConfig moveSelectorConfig = ((LocalSearchPhaseConfig)this.phaseConfig).getMoveSelectorConfig();
        if (moveSelectorConfig == null) {
            moveSelector = new UnionMoveSelectorFactory<Solution_>(this.determineDefaultMoveSelectorConfig(configPolicy)).buildMoveSelector(configPolicy, defaultCacheType, defaultSelectionOrder, true);
        } else {
            AbstractMoveSelectorFactory<Solution_, Object> moveSelectorFactory = MoveSelectorFactory.create(moveSelectorConfig);
            if (configPolicy.getNearbyDistanceMeterClass() != null && NearbyAutoConfigurationEnabled.class.isAssignableFrom(moveSelectorConfig.getClass()) && !UnionMoveSelectorConfig.class.isAssignableFrom(moveSelectorConfig.getClass())) {
                MoveSelectorConfig moveSelectorCopy = (MoveSelectorConfig)moveSelectorConfig.copyConfig();
                UnionMoveSelectorConfig updatedConfig = new UnionMoveSelectorConfig().withMoveSelectors(moveSelectorCopy);
                moveSelectorFactory = MoveSelectorFactory.create(updatedConfig);
            }
            moveSelector = moveSelectorFactory.buildMoveSelector(configPolicy, defaultCacheType, defaultSelectionOrder, true);
        }
        return moveSelector;
    }

    private SelectionOrder pickSelectionOrder() {
        return ((LocalSearchPhaseConfig)this.phaseConfig).getLocalSearchType() == LocalSearchType.VARIABLE_NEIGHBORHOOD_DESCENT ? SelectionOrder.ORIGINAL : SelectionOrder.RANDOM;
    }

    private UnionMoveSelectorConfig determineDefaultMoveSelectorConfig(HeuristicConfigPolicy<Solution_> configPolicy) {
        SolutionDescriptor<Solution_> solutionDescriptor = configPolicy.getSolutionDescriptor();
        if (solutionDescriptor.hasBothBasicAndListVariables()) {
            ArrayList<MoveSelectorConfig> moveSelectorList = new ArrayList<MoveSelectorConfig>();
            moveSelectorList.addAll(List.of(new ChangeMoveSelectorConfig(), new SwapMoveSelectorConfig()));
            moveSelectorList.addAll(List.of(new ListChangeMoveSelectorConfig(), new ListSwapMoveSelectorConfig(), new KOptListMoveSelectorConfig()));
            return new UnionMoveSelectorConfig().withMoveSelectorList(moveSelectorList);
        }
        if (solutionDescriptor.hasListVariable()) {
            return new UnionMoveSelectorConfig().withMoveSelectors(new ListChangeMoveSelectorConfig(), new ListSwapMoveSelectorConfig(), new KOptListMoveSelectorConfig());
        }
        List<BasicVariableDescriptor<Solution_>> basicVariableDescriptorList = solutionDescriptor.getBasicVariableDescriptorList();
        if (solutionDescriptor.hasChainedVariable() && basicVariableDescriptorList.size() == 1) {
            return new UnionMoveSelectorConfig().withMoveSelectors(new ChangeMoveSelectorConfig(), new SwapMoveSelectorConfig(), new TailChainSwapMoveSelectorConfig());
        }
        return new UnionMoveSelectorConfig().withMoveSelectors(new ChangeMoveSelectorConfig(), new SwapMoveSelectorConfig());
    }
}

