/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.value.decorator;

import ai.timefold.solver.core.api.domain.valuerange.CountableValueRange;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.AbstractDemandEnabledSelector;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.value.FromEntityPropertyValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.IterableValueSelector;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import java.util.Iterator;

public final class IterableFromEntityPropertyValueSelector<Solution_>
extends AbstractDemandEnabledSelector<Solution_>
implements IterableValueSelector<Solution_> {
    private final FromEntityPropertyValueSelector<Solution_> childValueSelector;
    private final SelectionCacheType minimumCacheType;
    private final boolean randomSelection;
    private final ValueRangeDescriptor<Solution_> valueRangeDescriptor;
    private InnerScoreDirector<Solution_, ?> innerScoreDirector = null;

    public IterableFromEntityPropertyValueSelector(FromEntityPropertyValueSelector<Solution_> childValueSelector, boolean randomSelection) {
        this(childValueSelector, SelectionCacheType.JUST_IN_TIME, randomSelection);
    }

    public IterableFromEntityPropertyValueSelector(FromEntityPropertyValueSelector<Solution_> childValueSelector, SelectionCacheType minimumCacheType, boolean randomSelection) {
        this.childValueSelector = childValueSelector;
        this.minimumCacheType = minimumCacheType;
        this.randomSelection = randomSelection;
        this.valueRangeDescriptor = childValueSelector.getVariableDescriptor().getValueRangeDescriptor();
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        this.childValueSelector.solvingStarted(solverScope);
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        this.childValueSelector.solvingEnded(solverScope);
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.childValueSelector.phaseStarted(phaseScope);
        this.innerScoreDirector = phaseScope.getScoreDirector();
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.childValueSelector.phaseEnded(phaseScope);
        this.innerScoreDirector = null;
    }

    public FromEntityPropertyValueSelector<Solution_> getChildValueSelector() {
        return this.childValueSelector;
    }

    @Override
    public SelectionSorter<Solution_, Object> getSelectionSorter() {
        return this.childValueSelector.getSelectionSorter();
    }

    @Override
    public SelectionCacheType getCacheType() {
        return this.minimumCacheType;
    }

    @Override
    public GenuineVariableDescriptor<Solution_> getVariableDescriptor() {
        return this.childValueSelector.getVariableDescriptor();
    }

    @Override
    public long getSize(Object entity) {
        return this.childValueSelector.getSize(entity);
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        return this.childValueSelector.iterator(entity);
    }

    @Override
    public Iterator<Object> endingIterator(Object entity) {
        return this.childValueSelector.endingIterator(entity);
    }

    @Override
    public boolean isCountable() {
        return this.valueRangeDescriptor.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || !this.isCountable();
    }

    @Override
    public long getSize() {
        return this.innerScoreDirector.getValueRangeManager().countOnSolution(this.valueRangeDescriptor, this.innerScoreDirector.getWorkingSolution());
    }

    @Override
    public Iterator<Object> iterator() {
        CountableValueRange<Object> valueRange = this.innerScoreDirector.getValueRangeManager().getFromSolution(this.valueRangeDescriptor, this.innerScoreDirector.getWorkingSolution(), this.childValueSelector.getSelectionSorter());
        if (this.randomSelection) {
            return valueRange.createRandomIterator(this.workingRandom);
        }
        return valueRange.createOriginalIterator();
    }

    @Override
    public boolean equals(Object other) {
        return this.childValueSelector.equals(other);
    }

    @Override
    public int hashCode() {
        return this.childValueSelector.hashCode();
    }
}

