/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.value.decorator;

import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.impl.domain.variable.ListVariableStateSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.AbstractDemandEnabledSelector;
import ai.timefold.solver.core.impl.heuristic.selector.common.ReachableValues;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.value.IterableValueSelector;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.preview.api.domain.metamodel.ElementPosition;
import ai.timefold.solver.core.preview.api.domain.metamodel.PositionInList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

public final class FilteringValueRangeSelector<Solution_>
extends AbstractDemandEnabledSelector<Solution_>
implements IterableValueSelector<Solution_> {
    private final IterableValueSelector<Solution_> nonReplayingValueSelector;
    private final IterableValueSelector<Solution_> replayingValueSelector;
    private final SelectionSorter<Solution_, Object> selectionSorter;
    private final boolean randomSelection;
    private Object replayedValue = null;
    private long valuesSize;
    private ListVariableStateSupply<Solution_, Object, Object> listVariableStateSupply;
    private ReachableValues<Object, Object> reachableValues;
    private final boolean checkSourceAndDestination;

    public FilteringValueRangeSelector(IterableValueSelector<Solution_> nonReplayingValueSelector, IterableValueSelector<Solution_> replayingValueSelector, boolean randomSelection, boolean checkSourceAndDestination) {
        this.nonReplayingValueSelector = nonReplayingValueSelector;
        this.replayingValueSelector = replayingValueSelector;
        this.selectionSorter = nonReplayingValueSelector.getSelectionSorter();
        this.randomSelection = randomSelection;
        this.checkSourceAndDestination = checkSourceAndDestination;
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        this.nonReplayingValueSelector.solvingStarted(solverScope);
        this.replayingValueSelector.solvingStarted(solverScope);
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.listVariableStateSupply = phaseScope.getSolverScope().getScoreDirector().getListVariableStateSupply((ListVariableDescriptor)this.nonReplayingValueSelector.getVariableDescriptor());
        this.nonReplayingValueSelector.phaseStarted(phaseScope);
        this.replayingValueSelector.phaseStarted(phaseScope);
        this.reachableValues = phaseScope.getScoreDirector().getValueRangeManager().getReachableValues((GenuineVariableDescriptor<Solution_>)this.listVariableStateSupply.getSourceVariableDescriptor(), this.selectionSorter);
        this.valuesSize = this.reachableValues.getSize();
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.nonReplayingValueSelector.phaseEnded(phaseScope);
        this.replayingValueSelector.phaseEnded(phaseScope);
        this.replayedValue = null;
        this.reachableValues = null;
        this.listVariableStateSupply = null;
    }

    public IterableValueSelector<Solution_> getChildValueSelector() {
        return this.nonReplayingValueSelector;
    }

    @Override
    public <T> SelectionSorter<Solution_, T> getSelectionSorter() {
        return this.nonReplayingValueSelector.getSelectionSorter();
    }

    @Override
    public SelectionCacheType getCacheType() {
        return this.nonReplayingValueSelector.getCacheType();
    }

    @Override
    public GenuineVariableDescriptor<Solution_> getVariableDescriptor() {
        return this.nonReplayingValueSelector.getVariableDescriptor();
    }

    @Override
    public boolean isCountable() {
        return this.nonReplayingValueSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.nonReplayingValueSelector.isNeverEnding();
    }

    @Override
    public long getSize(Object entity) {
        return this.getSize();
    }

    @Override
    public long getSize() {
        return this.valuesSize;
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        return this.iterator();
    }

    private Object selectReplayedValue() {
        Iterator iterator = this.replayingValueSelector.iterator();
        if (iterator.hasNext()) {
            this.replayedValue = iterator.next();
        }
        return this.replayedValue;
    }

    @Override
    public Iterator<Object> iterator() {
        if (this.randomSelection) {
            return new RandomFilteringValueRangeIterator<Object, Object>(this::selectReplayedValue, this.reachableValues, this.listVariableStateSupply, this.workingRandom, this.checkSourceAndDestination);
        }
        return new OriginalFilteringValueRangeIterator<Object, Object>(this::selectReplayedValue, this.reachableValues, this.listVariableStateSupply, this.checkSourceAndDestination);
    }

    @Override
    public Iterator<Object> endingIterator(Object entity) {
        return new OriginalFilteringValueRangeIterator<Object, Object>(this::selectReplayedValue, this.reachableValues, this.listVariableStateSupply, this.checkSourceAndDestination);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (!(other instanceof FilteringValueRangeSelector)) return false;
        FilteringValueRangeSelector that = (FilteringValueRangeSelector)other;
        if (!Objects.equals(this.nonReplayingValueSelector, that.nonReplayingValueSelector)) return false;
        if (!Objects.equals(this.replayingValueSelector, that.replayingValueSelector)) return false;
        if (!Objects.equals(this.selectionSorter, that.selectionSorter)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.nonReplayingValueSelector, this.replayingValueSelector, this.selectionSorter);
    }

    private class RandomFilteringValueRangeIterator<Entity_, Value_>
    extends AbstractFilteringValueRangeIterator<Entity_, Value_> {
        private final Random workingRandom;
        private int maxBailoutSize;
        private Value_ replayedValue;
        private List<Value_> reachableValueList;

        private RandomFilteringValueRangeIterator(Supplier<Value_> upcomingValueSupplier, ReachableValues<Entity_, Value_> reachableValues, ListVariableStateSupply<Solution_, Entity_, Value_> listVariableStateSupply, Random workingRandom, boolean checkSourceAndDestination) {
            super(upcomingValueSupplier, reachableValues, listVariableStateSupply, checkSourceAndDestination);
            this.reachableValueList = null;
            this.workingRandom = workingRandom;
        }

        @Override
        void processUpcomingValue(Value_ upcomingValue, List<Value_> upcomingList) {
            this.replayedValue = upcomingValue;
            this.reachableValueList = Objects.requireNonNull(upcomingList);
            this.maxBailoutSize = this.reachableValueList.size();
        }

        @Override
        public boolean hasNext() {
            this.checkUpcomingValue();
            return FilteringValueRangeSelector.this.reachableValues != null && !this.reachableValueList.isEmpty();
        }

        @Override
        public Value_ next() {
            if (this.hasNoData()) {
                throw new NoSuchElementException();
            }
            int bailoutSize = this.maxBailoutSize;
            do {
                --bailoutSize;
                int index = this.workingRandom.nextInt(this.reachableValueList.size());
                Value_ next = this.reachableValueList.get(index);
                if (!this.isReachable(next)) continue;
                return next;
            } while (bailoutSize > 0);
            return this.replayedValue;
        }
    }

    private class OriginalFilteringValueRangeIterator<Entity_, Value_>
    extends AbstractFilteringValueRangeIterator<Entity_, Value_> {
        private Iterator<Value_> reachableValueIterator;
        private Value_ selected;

        private OriginalFilteringValueRangeIterator(Supplier<Value_> upcomingValueSupplier, ReachableValues<Entity_, Value_> reachableValues, ListVariableStateSupply<Solution_, Entity_, Value_> listVariableStateSupply, boolean checkSourceAndDestination) {
            super(upcomingValueSupplier, reachableValues, listVariableStateSupply, checkSourceAndDestination);
            this.selected = null;
        }

        @Override
        void processUpcomingValue(Value_ upcomingValue, List<Value_> upcomingList) {
            this.reachableValueIterator = Objects.requireNonNull(upcomingList).iterator();
            this.selected = null;
        }

        @Override
        public boolean hasNext() {
            this.selected = this.pickNext();
            return this.selected != null;
        }

        private Value_ pickNext() {
            if (this.selected != null) {
                throw new IllegalStateException("The next value has already been picked.");
            }
            this.initialize();
            this.selected = null;
            while (this.reachableValueIterator.hasNext()) {
                Value_ value = this.reachableValueIterator.next();
                if (!this.isReachable(value)) continue;
                return value;
            }
            return null;
        }

        @Override
        public Value_ next() {
            if (this.selected == null) {
                throw new NoSuchElementException();
            }
            Value_ result = this.selected;
            this.selected = null;
            return result;
        }
    }

    @NullMarked
    private abstract class AbstractFilteringValueRangeIterator<Entity_, Value_>
    implements Iterator<Value_> {
        private final Supplier<Value_> upcomingValueSupplier;
        private final ListVariableStateSupply<Solution_, Entity_, Value_> listVariableStateSupply;
        private final ReachableValues<Entity_, Value_> reachableValues;
        private final boolean checkSourceAndDestination;
        private boolean initialized = false;
        private boolean hasData = false;
        private @Nullable Value_ currentUpcomingValue;
        private @Nullable Entity_ currentUpcomingEntity;
        private @Nullable List<Value_> currentUpcomingValueList;

        AbstractFilteringValueRangeIterator(Supplier<Value_> upcomingValueSupplier, ReachableValues<Entity_, Value_> reachableValues, ListVariableStateSupply<Solution_, Entity_, Value_> listVariableStateSupply, boolean checkSourceAndDestination) {
            this.upcomingValueSupplier = upcomingValueSupplier;
            this.reachableValues = Objects.requireNonNull(reachableValues);
            this.listVariableStateSupply = listVariableStateSupply;
            this.checkSourceAndDestination = checkSourceAndDestination;
        }

        void initialize() {
            if (this.initialized) {
                return;
            }
            this.checkUpcomingValue();
        }

        void checkUpcomingValue() {
            if (this.currentUpcomingValue != null) {
                Value_ updatedUpcomingValue = this.upcomingValueSupplier.get();
                if (updatedUpcomingValue != this.currentUpcomingValue) {
                    this.loadValues(updatedUpcomingValue);
                }
            } else {
                this.loadValues(this.upcomingValueSupplier.get());
            }
        }

        private void loadValues(@Nullable Value_ upcomingValue) {
            ElementPosition position;
            if (upcomingValue == null) {
                this.noData();
                return;
            }
            if (upcomingValue == this.currentUpcomingValue) {
                return;
            }
            this.currentUpcomingValue = upcomingValue;
            this.currentUpcomingEntity = null;
            this.currentUpcomingValueList = null;
            if (this.checkSourceAndDestination && (position = this.listVariableStateSupply.getElementPosition(this.currentUpcomingValue)) instanceof PositionInList) {
                PositionInList positionInList = (PositionInList)position;
                this.currentUpcomingEntity = positionInList.entity();
            }
            this.currentUpcomingValueList = this.reachableValues.extractValuesAsList(this.currentUpcomingValue);
            this.processUpcomingValue(this.currentUpcomingValue, this.currentUpcomingValueList);
            this.hasData = !this.currentUpcomingValueList.isEmpty();
            this.initialized = true;
        }

        abstract void processUpcomingValue(Value_ var1, List<Value_> var2);

        boolean hasNoData() {
            return !this.hasData;
        }

        private void noData() {
            this.currentUpcomingEntity = null;
            this.hasData = false;
            this.initialized = true;
            this.currentUpcomingValueList = Collections.emptyList();
        }

        boolean isReachable(Value_ destinationValue) {
            Object destinationEntity = null;
            ElementPosition assignedDestinationPosition = this.listVariableStateSupply.getElementPosition(destinationValue);
            if (assignedDestinationPosition instanceof PositionInList) {
                PositionInList elementPosition = (PositionInList)assignedDestinationPosition;
                destinationEntity = elementPosition.entity();
            }
            if (this.checkSourceAndDestination) {
                return this.reachableValues.isEntityReachable(Objects.requireNonNull(this.currentUpcomingValue), destinationEntity) && this.reachableValues.isEntityReachable(Objects.requireNonNull(destinationValue), this.currentUpcomingEntity);
            }
            return this.reachableValues.isEntityReachable(Objects.requireNonNull(this.currentUpcomingValue), destinationEntity);
        }
    }
}

