/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.ruin;

import ai.timefold.solver.core.impl.domain.variable.ListVariableStateSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.CountSupplier;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.RuinRecreateConstructionHeuristicPhaseBuilder;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.ruin.ListRuinRecreateMoveIterator;
import ai.timefold.solver.core.impl.heuristic.selector.value.IterableValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.decorator.FilteringValueSelector;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import java.util.Iterator;
import java.util.Objects;
import org.apache.commons.math3.util.CombinatoricsUtils;

final class ListRuinRecreateMoveSelector<Solution_>
extends GenericMoveSelector<Solution_> {
    private final IterableValueSelector<Solution_> valueSelector;
    private final ListVariableDescriptor<Solution_> listVariableDescriptor;
    private final RuinRecreateConstructionHeuristicPhaseBuilder<Solution_> constructionHeuristicPhaseBuilder;
    private final CountSupplier minimumSelectedCountSupplier;
    private final CountSupplier maximumSelectedCountSupplier;
    private SolverScope<Solution_> solverScope;
    private ListVariableStateSupply<Solution_, Object, Object> listVariableStateSupply;

    public ListRuinRecreateMoveSelector(IterableValueSelector<Solution_> valueSelector, ListVariableDescriptor<Solution_> listVariableDescriptor, RuinRecreateConstructionHeuristicPhaseBuilder<Solution_> constructionHeuristicPhaseBuilder, CountSupplier minimumSelectedCountSupplier, CountSupplier maximumSelectedCountSupplier) {
        this.valueSelector = FilteringValueSelector.ofAssigned(valueSelector, this::getListVariableStateSupply);
        this.listVariableDescriptor = listVariableDescriptor;
        this.constructionHeuristicPhaseBuilder = constructionHeuristicPhaseBuilder;
        this.minimumSelectedCountSupplier = minimumSelectedCountSupplier;
        this.maximumSelectedCountSupplier = maximumSelectedCountSupplier;
        this.phaseLifecycleSupport.addEventListener(this.valueSelector);
    }

    private ListVariableStateSupply<Solution_, Object, Object> getListVariableStateSupply() {
        return Objects.requireNonNull(this.listVariableStateSupply, "Impossible state: The listVariableStateSupply is not initialized yet.");
    }

    @Override
    public long getSize() {
        long totalSize = 0L;
        long valueCount = this.valueSelector.getSize();
        int minimumSelectedCount = this.minimumSelectedCountSupplier.applyAsInt(valueCount);
        int maximumSelectedCount = this.maximumSelectedCountSupplier.applyAsInt(valueCount);
        for (int selectedCount = minimumSelectedCount; selectedCount <= maximumSelectedCount; ++selectedCount) {
            totalSize += CombinatoricsUtils.factorial((int)((int)valueCount)) / CombinatoricsUtils.factorial((int)selectedCount);
        }
        return totalSize;
    }

    @Override
    public boolean isCountable() {
        return this.valueSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.valueSelector.isNeverEnding();
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        this.solverScope = solverScope;
        this.listVariableStateSupply = (ListVariableStateSupply)solverScope.getScoreDirector().getSupplyManager().demand(this.listVariableDescriptor.getStateDemand());
        this.workingRandom = solverScope.getWorkingRandom();
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        this.listVariableStateSupply = null;
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.solverScope = null;
        this.workingRandom = null;
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        long valueSelectorSize = this.valueSelector.getSize();
        return new ListRuinRecreateMoveIterator<Solution_>(this.valueSelector, this.constructionHeuristicPhaseBuilder, this.solverScope, this.listVariableStateSupply, this.minimumSelectedCountSupplier.applyAsInt(valueSelectorSize), this.maximumSelectedCountSupplier.applyAsInt(valueSelectorSize), this.workingRandom);
    }
}

