/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move;

import ai.timefold.solver.core.api.domain.common.ComparatorFactory;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.common.decorator.SelectionSorterOrder;
import ai.timefold.solver.core.config.heuristic.selector.move.MoveSelectorConfig;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.selector.AbstractSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.ComparatorFactorySelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.ComparatorSelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionProbabilityWeightFactory;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.DoableMoveSelectionFilter;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.decorator.CachingMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.decorator.FilteringMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.decorator.ProbabilityMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.decorator.SelectedCountLimitMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.decorator.ShufflingMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.decorator.SortingMoveSelector;
import java.util.Comparator;

public abstract class AbstractMoveSelectorFactory<Solution_, MoveSelectorConfig_ extends MoveSelectorConfig<MoveSelectorConfig_>>
extends AbstractSelectorFactory<Solution_, MoveSelectorConfig_>
implements MoveSelectorFactory<Solution_> {
    public AbstractMoveSelectorFactory(MoveSelectorConfig_ moveSelectorConfig) {
        super(moveSelectorConfig);
    }

    protected abstract MoveSelector<Solution_> buildBaseMoveSelector(HeuristicConfigPolicy<Solution_> var1, SelectionCacheType var2, boolean var3);

    @Override
    public MoveSelector<Solution_> buildMoveSelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder, boolean skipNonDoableMoves) {
        MoveSelectorConfig<?> unfoldedMoveSelectorConfig = this.buildUnfoldedMoveSelectorConfig(configPolicy);
        if (unfoldedMoveSelectorConfig != null) {
            return MoveSelectorFactory.create(unfoldedMoveSelectorConfig).buildMoveSelector(configPolicy, minimumCacheType, inheritedSelectionOrder, skipNonDoableMoves);
        }
        SelectionCacheType resolvedCacheType = SelectionCacheType.resolve(((MoveSelectorConfig)this.config).getCacheType(), minimumCacheType);
        SelectionOrder resolvedSelectionOrder = SelectionOrder.resolve(((MoveSelectorConfig)this.config).getSelectionOrder(), inheritedSelectionOrder);
        this.validateCacheTypeVersusSelectionOrder(resolvedCacheType, resolvedSelectionOrder, false);
        this.validateSorting(resolvedSelectionOrder);
        this.validateProbability(resolvedSelectionOrder);
        this.validateSelectedLimit(minimumCacheType);
        boolean randomMoveSelection = this.determineBaseRandomSelection(resolvedCacheType, resolvedSelectionOrder);
        SelectionCacheType selectionCacheType = SelectionCacheType.max(minimumCacheType, resolvedCacheType);
        MoveSelector<Solution_> moveSelector = this.buildBaseMoveSelector(configPolicy, selectionCacheType, randomMoveSelection);
        this.validateResolvedCacheType(resolvedCacheType, moveSelector);
        moveSelector = this.applyFiltering(moveSelector, skipNonDoableMoves);
        moveSelector = this.applySorting(resolvedCacheType, resolvedSelectionOrder, moveSelector);
        moveSelector = this.applyProbability(resolvedCacheType, resolvedSelectionOrder, moveSelector);
        moveSelector = this.applyShuffling(resolvedCacheType, resolvedSelectionOrder, moveSelector);
        moveSelector = this.applyCaching(resolvedCacheType, resolvedSelectionOrder, moveSelector);
        moveSelector = this.applySelectedLimit(moveSelector);
        return moveSelector;
    }

    protected MoveSelectorConfig<?> buildUnfoldedMoveSelectorConfig(HeuristicConfigPolicy<Solution_> configPolicy) {
        return null;
    }

    protected static <T> T checkUnfolded(String configPropertyName, T configProperty) {
        if (configProperty == null) {
            throw new IllegalStateException("The %s (%s) should haven been initialized during unfolding.".formatted(configPropertyName, configProperty));
        }
        return configProperty;
    }

    private void validateResolvedCacheType(SelectionCacheType resolvedCacheType, MoveSelector<Solution_> moveSelector) {
        if (!moveSelector.supportsPhaseAndSolverCaching() && resolvedCacheType.compareTo(SelectionCacheType.PHASE) >= 0) {
            throw new IllegalArgumentException("The moveSelectorConfig (" + String.valueOf(this.config) + ") has a resolvedCacheType (" + String.valueOf((Object)resolvedCacheType) + ") that is not supported.\nMaybe don't use a <cacheType> on this type of moveSelector.");
        }
    }

    protected boolean determineBaseRandomSelection(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder) {
        return switch (resolvedSelectionOrder) {
            case SelectionOrder.ORIGINAL, SelectionOrder.SORTED, SelectionOrder.SHUFFLED, SelectionOrder.PROBABILISTIC -> false;
            case SelectionOrder.RANDOM -> {
                if (resolvedCacheType.isNotCached() || this.isBaseInherentlyCached() && ((MoveSelectorConfig)this.config).getFilterClass() == null) {
                    yield true;
                }
                yield false;
            }
            default -> throw new IllegalStateException("The selectionOrder (" + String.valueOf((Object)resolvedSelectionOrder) + ") is not implemented.");
        };
    }

    private String determineComparatorPropertyName(MoveSelectorConfig_ moveSelectorConfig) {
        Class<Comparator> sorterComparatorClass = ((MoveSelectorConfig)moveSelectorConfig).getSorterComparatorClass();
        Class<Comparator> comparatorClass = ((MoveSelectorConfig)moveSelectorConfig).getComparatorClass();
        if (sorterComparatorClass != null && comparatorClass != null) {
            throw new IllegalArgumentException("The moveSelectorConfig (%s) cannot have a %s (%s) and %s (%s) at the same time.".formatted(moveSelectorConfig, "sorterComparatorClass", sorterComparatorClass, "comparatorClass", comparatorClass));
        }
        return sorterComparatorClass != null ? "sorterComparatorClass" : "comparatorClass";
    }

    private Class<? extends Comparator> determineComparatorClass(MoveSelectorConfig_ moveSelectorConfig) {
        String propertyName = this.determineComparatorPropertyName(moveSelectorConfig);
        if (propertyName.equals("sorterComparatorClass")) {
            return ((MoveSelectorConfig)moveSelectorConfig).getSorterComparatorClass();
        }
        return ((MoveSelectorConfig)moveSelectorConfig).getComparatorClass();
    }

    private String determineComparatorFactoryPropertyName(MoveSelectorConfig_ moveSelectorConfig) {
        Class<SelectionSorterWeightFactory> weightFactoryClass = ((MoveSelectorConfig)moveSelectorConfig).getSorterWeightFactoryClass();
        Class<ComparatorFactory> comparatorFactoryClass = ((MoveSelectorConfig)moveSelectorConfig).getComparatorFactoryClass();
        if (weightFactoryClass != null && comparatorFactoryClass != null) {
            throw new IllegalArgumentException("The moveSelectorConfig (%s) cannot have a %s (%s) and %s (%s) at the same time.".formatted(moveSelectorConfig, "sorterWeightFactoryClass", weightFactoryClass, "comparatorFactoryClass", comparatorFactoryClass));
        }
        return weightFactoryClass != null ? "sorterWeightFactoryClass" : "comparatorFactoryClass";
    }

    private Class<? extends ComparatorFactory> determineComparatorFactoryClass(MoveSelectorConfig_ moveSelectorConfig) {
        String propertyName = this.determineComparatorFactoryPropertyName(moveSelectorConfig);
        if (propertyName.equals("sorterWeightFactoryClass")) {
            return ((MoveSelectorConfig)moveSelectorConfig).getSorterWeightFactoryClass();
        }
        return ((MoveSelectorConfig)moveSelectorConfig).getComparatorFactoryClass();
    }

    protected boolean isBaseInherentlyCached() {
        return false;
    }

    private MoveSelector<Solution_> applyFiltering(MoveSelector<Solution_> moveSelector, boolean skipNonDoableMoves) {
        SelectionFilter baseFilter = skipNonDoableMoves ? DoableMoveSelectionFilter.INSTANCE : null;
        Class<SelectionFilter> filterClass = ((MoveSelectorConfig)this.config).getFilterClass();
        if (filterClass != null) {
            SelectionFilter selectionFilter = ConfigUtils.newInstance(this.config, "filterClass", filterClass);
            SelectionFilter finalFilter = baseFilter == null ? selectionFilter : SelectionFilter.compose(baseFilter, selectionFilter);
            return FilteringMoveSelector.of(moveSelector, finalFilter);
        }
        if (baseFilter != null) {
            return FilteringMoveSelector.of(moveSelector, baseFilter);
        }
        return moveSelector;
    }

    protected void validateSorting(SelectionOrder resolvedSelectionOrder) {
        Class<Comparator> comparatorClass = this.determineComparatorClass((MoveSelectorConfig)this.config);
        Class<ComparatorFactory> comparatorFactoryClass = this.determineComparatorFactoryClass((MoveSelectorConfig)this.config);
        if ((comparatorClass != null || comparatorFactoryClass != null || ((MoveSelectorConfig)this.config).getSorterOrder() != null || ((MoveSelectorConfig)this.config).getSorterClass() != null) && resolvedSelectionOrder != SelectionOrder.SORTED) {
            throw new IllegalArgumentException("The moveSelectorConfig (%s) with %s (%s) and %s (%s) and sorterOrder (%s) and sorterClass (%s) has a resolvedSelectionOrder (%s) that is not %s.".formatted(new Object[]{this.config, this.determineComparatorPropertyName((MoveSelectorConfig)this.config), comparatorClass, this.determineComparatorFactoryPropertyName((MoveSelectorConfig)this.config), comparatorFactoryClass, ((MoveSelectorConfig)this.config).getSorterOrder(), ((MoveSelectorConfig)this.config).getSorterClass(), resolvedSelectionOrder, SelectionOrder.SORTED}));
        }
        if (comparatorClass != null && comparatorFactoryClass != null) {
            throw new IllegalArgumentException("The moveSelectorConfig (%s) has both a %s (%s) and a %s (%s).".formatted(this.config, this.determineComparatorPropertyName((MoveSelectorConfig)this.config), comparatorClass, this.determineComparatorFactoryPropertyName((MoveSelectorConfig)this.config), comparatorFactoryClass));
        }
        if (comparatorClass != null && ((MoveSelectorConfig)this.config).getSorterClass() != null) {
            throw new IllegalArgumentException("The moveSelectorConfig (%s) has both a %s (%s) and a sorterClass (%s).".formatted(this.config, this.determineComparatorPropertyName((MoveSelectorConfig)this.config), comparatorClass, ((MoveSelectorConfig)this.config).getSorterClass()));
        }
        if (comparatorFactoryClass != null && ((MoveSelectorConfig)this.config).getSorterClass() != null) {
            throw new IllegalArgumentException("The moveSelectorConfig (%s) has both a %s (%s) and a sorterClass (%s).".formatted(this.config, this.determineComparatorFactoryPropertyName((MoveSelectorConfig)this.config), comparatorFactoryClass, ((MoveSelectorConfig)this.config).getSorterClass()));
        }
        if (((MoveSelectorConfig)this.config).getSorterClass() != null && ((MoveSelectorConfig)this.config).getSorterOrder() != null) {
            throw new IllegalArgumentException("The moveSelectorConfig (%s) with sorterClass (%s) has a non-null sorterOrder (%s).".formatted(new Object[]{this.config, ((MoveSelectorConfig)this.config).getSorterClass(), ((MoveSelectorConfig)this.config).getSorterOrder()}));
        }
    }

    protected MoveSelector<Solution_> applySorting(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, MoveSelector<Solution_> moveSelector) {
        if (resolvedSelectionOrder == SelectionOrder.SORTED) {
            SelectionSorter sorter;
            Class<Comparator> comparatorClass = this.determineComparatorClass((MoveSelectorConfig)this.config);
            Class<ComparatorFactory> comparatorFactoryClass = this.determineComparatorFactoryClass((MoveSelectorConfig)this.config);
            Class<SelectionSorter> sorterClass = ((MoveSelectorConfig)this.config).getSorterClass();
            if (comparatorClass != null) {
                Comparator sorterComparator = ConfigUtils.newInstance(this.config, this.determineComparatorPropertyName((MoveSelectorConfig)this.config), comparatorClass);
                sorter = new ComparatorSelectionSorter(sorterComparator, SelectionSorterOrder.resolve(((MoveSelectorConfig)this.config).getSorterOrder()));
            } else if (comparatorFactoryClass != null) {
                ComparatorFactory comparatorFactory = ConfigUtils.newInstance(this.config, this.determineComparatorFactoryPropertyName((MoveSelectorConfig)this.config), comparatorFactoryClass);
                sorter = new ComparatorFactorySelectionSorter(comparatorFactory, SelectionSorterOrder.resolve(((MoveSelectorConfig)this.config).getSorterOrder()));
            } else if (sorterClass != null) {
                sorter = ConfigUtils.newInstance(this.config, "sorterClass", sorterClass);
            } else {
                throw new IllegalArgumentException("The moveSelectorConfig (%s) with resolvedSelectionOrder (%s) needs a %s (%s) or a %s (%s) or a sorterClass (%s).".formatted(new Object[]{this.config, resolvedSelectionOrder, this.determineComparatorPropertyName((MoveSelectorConfig)this.config), comparatorClass, this.determineComparatorFactoryPropertyName((MoveSelectorConfig)this.config), comparatorFactoryClass, sorterClass}));
            }
            moveSelector = new SortingMoveSelector<Solution_>(moveSelector, resolvedCacheType, sorter);
        }
        return moveSelector;
    }

    private void validateProbability(SelectionOrder resolvedSelectionOrder) {
        Class<SelectionProbabilityWeightFactory> probabilityWeightFactoryClass = ((MoveSelectorConfig)this.config).getProbabilityWeightFactoryClass();
        if (probabilityWeightFactoryClass != null && resolvedSelectionOrder != SelectionOrder.PROBABILISTIC) {
            throw new IllegalArgumentException("The moveSelectorConfig (%s) with probabilityWeightFactoryClass (%s) has a resolvedSelectionOrder (%s) that is not %s.".formatted(new Object[]{this.config, probabilityWeightFactoryClass, resolvedSelectionOrder, SelectionOrder.PROBABILISTIC}));
        }
    }

    private MoveSelector<Solution_> applyProbability(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, MoveSelector<Solution_> moveSelector) {
        if (resolvedSelectionOrder == SelectionOrder.PROBABILISTIC) {
            Class<SelectionProbabilityWeightFactory> probabilityWeightFactoryClass = ((MoveSelectorConfig)this.config).getProbabilityWeightFactoryClass();
            if (probabilityWeightFactoryClass == null) {
                throw new IllegalArgumentException("The moveSelectorConfig (%s) with resolvedSelectionOrder (%s) needs a probabilityWeightFactoryClass (%s).".formatted(new Object[]{this.config, resolvedSelectionOrder, probabilityWeightFactoryClass}));
            }
            SelectionProbabilityWeightFactory probabilityWeightFactory = ConfigUtils.newInstance(this.config, "probabilityWeightFactoryClass", probabilityWeightFactoryClass);
            moveSelector = new ProbabilityMoveSelector<Solution_>(moveSelector, resolvedCacheType, probabilityWeightFactory);
        }
        return moveSelector;
    }

    private MoveSelector<Solution_> applyShuffling(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, MoveSelector<Solution_> moveSelector) {
        if (resolvedSelectionOrder == SelectionOrder.SHUFFLED) {
            moveSelector = new ShufflingMoveSelector<Solution_>(moveSelector, resolvedCacheType);
        }
        return moveSelector;
    }

    private MoveSelector<Solution_> applyCaching(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, MoveSelector<Solution_> moveSelector) {
        if (resolvedCacheType.isCached() && resolvedCacheType.compareTo(moveSelector.getCacheType()) > 0) {
            moveSelector = new CachingMoveSelector<Solution_>(moveSelector, resolvedCacheType, resolvedSelectionOrder.toRandomSelectionBoolean());
        }
        return moveSelector;
    }

    private void validateSelectedLimit(SelectionCacheType minimumCacheType) {
        if (((MoveSelectorConfig)this.config).getSelectedCountLimit() != null && minimumCacheType.compareTo(SelectionCacheType.JUST_IN_TIME) > 0) {
            throw new IllegalArgumentException("The moveSelectorConfig (" + String.valueOf(this.config) + ") with selectedCountLimit (" + ((MoveSelectorConfig)this.config).getSelectedCountLimit() + ") has a minimumCacheType (" + String.valueOf((Object)minimumCacheType) + ") that is higher than " + String.valueOf((Object)SelectionCacheType.JUST_IN_TIME) + ".");
        }
    }

    private MoveSelector<Solution_> applySelectedLimit(MoveSelector<Solution_> moveSelector) {
        if (((MoveSelectorConfig)this.config).getSelectedCountLimit() != null) {
            moveSelector = new SelectedCountLimitMoveSelector<Solution_>(moveSelector, ((MoveSelectorConfig)this.config).getSelectedCountLimit());
        }
        return moveSelector;
    }
}

