/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.common.decorator;

import ai.timefold.solver.core.api.domain.common.ComparatorFactory;
import ai.timefold.solver.core.config.heuristic.selector.common.decorator.SelectionSorterOrder;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class ComparatorFactorySelectionSorter<Solution_, T>
implements SelectionSorter<Solution_, T> {
    private final ComparatorFactory<Solution_, T> selectionComparatorFactory;
    private final SelectionSorterOrder selectionSorterOrder;

    public ComparatorFactorySelectionSorter(ComparatorFactory<Solution_, T> selectionComparatorFactory, SelectionSorterOrder selectionSorterOrder) {
        this.selectionComparatorFactory = selectionComparatorFactory;
        this.selectionSorterOrder = selectionSorterOrder;
    }

    private Comparator<T> getAppliedComparator(Comparator<T> comparator) {
        return switch (this.selectionSorterOrder) {
            default -> throw new IncompatibleClassChangeError();
            case SelectionSorterOrder.ASCENDING -> comparator;
            case SelectionSorterOrder.DESCENDING -> Collections.reverseOrder(comparator);
        };
    }

    @Override
    public void sort(Solution_ solution, List<T> selectionList) {
        Comparator<T> appliedComparator = this.getAppliedComparator(this.selectionComparatorFactory.createComparator(solution));
        selectionList.sort(appliedComparator);
    }

    @Override
    public SortedSet<T> sort(Solution_ solution, Set<T> selectionSet) {
        TreeSet<T> treeSet = new TreeSet<T>(this.getAppliedComparator(this.selectionComparatorFactory.createComparator(solution)));
        treeSet.addAll(selectionSet);
        return Collections.unmodifiableSortedSet(treeSet);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ComparatorFactorySelectionSorter)) {
            return false;
        }
        ComparatorFactorySelectionSorter that = (ComparatorFactorySelectionSorter)o;
        return Objects.equals(this.selectionComparatorFactory, that.selectionComparatorFactory) && this.selectionSorterOrder == that.selectionSorterOrder;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.selectionComparatorFactory, this.selectionSorterOrder});
    }
}

