/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector;

import ai.timefold.solver.core.config.heuristic.selector.SelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.impl.AbstractFromConfigFactory;

public abstract class AbstractSelectorFactory<Solution_, SelectorConfig_ extends SelectorConfig<SelectorConfig_>>
extends AbstractFromConfigFactory<Solution_, SelectorConfig_> {
    protected AbstractSelectorFactory(SelectorConfig_ selectorConfig) {
        super(selectorConfig);
    }

    protected void validateCacheTypeVersusSelectionOrder(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, boolean hasEntityRange) {
        switch (resolvedSelectionOrder) {
            case INHERIT: {
                throw new IllegalArgumentException("The moveSelectorConfig (%s) has a resolvedSelectionOrder (%s) which should have been resolved by now.".formatted(new Object[]{this.config, resolvedSelectionOrder}));
            }
            case ORIGINAL: 
            case RANDOM: {
                break;
            }
            case SORTED: {
                if (resolvedCacheType.isNotCached()) {
                    throw new IllegalArgumentException("The moveSelectorConfig (%s) has a resolvedSelectionOrder (%s) which does not support the resolvedCacheType (%s).".formatted(new Object[]{this.config, resolvedSelectionOrder, resolvedCacheType}));
                }
                if (!hasEntityRange || resolvedCacheType == SelectionCacheType.STEP) break;
                throw new IllegalArgumentException("The moveSelectorConfig (%s) has a resolvedSelectionOrder (%s) which does not support the resolvedCacheType (%s).\nMaybe set the \"cacheType\" to STEP.".formatted(new Object[]{this.config, resolvedSelectionOrder, resolvedCacheType}));
            }
            case SHUFFLED: 
            case PROBABILISTIC: {
                if (!resolvedCacheType.isNotCached()) break;
                throw new IllegalArgumentException("The moveSelectorConfig (%s) has a resolvedSelectionOrder (%s) which does not support the resolvedCacheType (%s).".formatted(new Object[]{this.config, resolvedSelectionOrder, resolvedCacheType}));
            }
            default: {
                throw new IllegalStateException("The resolvedSelectionOrder (%s) is not implemented.".formatted(new Object[]{resolvedSelectionOrder}));
            }
        }
    }
}

