/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.valuerange.descriptor;

import ai.timefold.solver.core.api.domain.valuerange.ValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.AbstractCountableValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.buildin.bigdecimal.BigDecimalValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.buildin.composite.CompositeCountableValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.buildin.primdouble.DoubleValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.AbstractValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class CompositeValueRangeDescriptor<Solution_>
extends AbstractValueRangeDescriptor<Solution_> {
    private final boolean canExtractValueRangeFromSolution;
    private final List<ValueRangeDescriptor<Solution_>> childValueRangeDescriptorList;
    private final boolean isGenericTypeImmutable;

    public CompositeValueRangeDescriptor(int ordinal, GenuineVariableDescriptor<Solution_> variableDescriptor, List<ValueRangeDescriptor<Solution_>> childValueRangeDescriptorList) {
        super(ordinal, variableDescriptor);
        this.childValueRangeDescriptorList = childValueRangeDescriptorList;
        boolean canExtractFromSolution = true;
        boolean isImmutable = true;
        for (ValueRangeDescriptor<Solution_> valueRangeDescriptor : childValueRangeDescriptorList) {
            if (!valueRangeDescriptor.isCountable()) {
                throw new IllegalStateException("The valueRange (%s) has a childValueRange (%s) which is not countable.\nMaybe replace %s with %s?".formatted(this, valueRangeDescriptor, DoubleValueRange.class.getSimpleName(), BigDecimalValueRange.class.getSimpleName()));
            }
            canExtractFromSolution = canExtractFromSolution && valueRangeDescriptor.canExtractValueRangeFromSolution();
            isImmutable = isImmutable && valueRangeDescriptor.isGenericTypeImmutable();
        }
        this.canExtractValueRangeFromSolution = canExtractFromSolution;
        this.isGenericTypeImmutable = isImmutable;
    }

    @Override
    public boolean isGenericTypeImmutable() {
        return this.isGenericTypeImmutable;
    }

    public int getValueRangeCount() {
        return this.childValueRangeDescriptorList.size();
    }

    @Override
    public boolean canExtractValueRangeFromSolution() {
        return this.canExtractValueRangeFromSolution;
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public <T> ValueRange<T> extractAllValues(Solution_ solution) {
        ArrayList<AbstractCountableValueRange> childValueRangeList = new ArrayList<AbstractCountableValueRange>(this.childValueRangeDescriptorList.size());
        for (ValueRangeDescriptor<Solution_> valueRangeDescriptor : this.childValueRangeDescriptorList) {
            childValueRangeList.add((AbstractCountableValueRange)valueRangeDescriptor.extractAllValues(solution));
        }
        return new CompositeCountableValueRange(childValueRangeList);
    }

    @Override
    public <T> ValueRange<T> extractValuesFromEntity(Solution_ solution, Object entity) {
        ArrayList<AbstractCountableValueRange> childValueRangeList = new ArrayList<AbstractCountableValueRange>(this.childValueRangeDescriptorList.size());
        for (ValueRangeDescriptor<Solution_> valueRangeDescriptor : this.childValueRangeDescriptorList) {
            childValueRangeList.add((AbstractCountableValueRange)valueRangeDescriptor.extractValuesFromEntity(solution, entity));
        }
        return new CompositeCountableValueRange(childValueRangeList);
    }
}

