/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.valuerange.buildin.temporal;

import ai.timefold.solver.core.impl.domain.valuerange.AbstractCountableValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.util.ValueRangeIterator;
import ai.timefold.solver.core.impl.solver.random.RandomUtils;
import java.time.DateTimeException;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import org.jspecify.annotations.NonNull;

public final class TemporalValueRange<Temporal_ extends Temporal & Comparable<? super Temporal_>>
extends AbstractCountableValueRange<Temporal_> {
    private final Temporal_ from;
    private final Temporal_ to;
    private final long incrementUnitAmount;
    private final TemporalUnit incrementUnitType;
    private final long size;

    public TemporalValueRange(Temporal_ from, Temporal_ to, long incrementUnitAmount, TemporalUnit incrementUnitType) {
        this.from = from;
        this.to = to;
        this.incrementUnitAmount = incrementUnitAmount;
        this.incrementUnitType = incrementUnitType;
        if (from == null || to == null || incrementUnitType == null) {
            throw new IllegalArgumentException("The " + this.getClass().getSimpleName() + " must have a from (" + String.valueOf(from) + "), to (" + String.valueOf(to) + ") and incrementUnitType (" + String.valueOf(incrementUnitType) + ") that are not null.");
        }
        if (incrementUnitAmount <= 0L) {
            throw new IllegalArgumentException("The " + this.getClass().getSimpleName() + " must have strictly positive incrementUnitAmount (" + incrementUnitAmount + ").");
        }
        if (!from.isSupported(incrementUnitType) || !to.isSupported(incrementUnitType)) {
            throw new IllegalArgumentException("The " + this.getClass().getSimpleName() + " must have an incrementUnitType (" + String.valueOf(incrementUnitType) + ") that is supported by its from (" + String.valueOf(from) + ") class (" + from.getClass().getSimpleName() + ") and to (" + String.valueOf(to) + ") class (" + to.getClass().getSimpleName() + ").");
        }
        if (((Comparable)from).compareTo(to) > 0) {
            throw new IllegalArgumentException("The " + this.getClass().getSimpleName() + " cannot have a from (" + String.valueOf(from) + ") which is strictly higher than its to (" + String.valueOf(to) + ").");
        }
        long space = from.until((Temporal)to, incrementUnitType);
        Temporal expectedTo = from.plus(space, incrementUnitType);
        if (!to.equals(expectedTo)) {
            Temporal roundedExpectedTo;
            ++space;
            try {
                roundedExpectedTo = from.plus(space, incrementUnitType);
            }
            catch (DateTimeException e) {
                throw new IllegalArgumentException("The " + this.getClass().getSimpleName() + "'s incrementUnitType (" + String.valueOf(incrementUnitType) + ") must fit an integer number of times in the space (" + space + ") between from (" + String.valueOf(from) + ") and to (" + String.valueOf(to) + ").\nThe to (" + String.valueOf(to) + ") is not the expectedTo (" + String.valueOf(expectedTo) + ").", e);
            }
            if (!to.equals(roundedExpectedTo)) {
                throw new IllegalArgumentException("The " + this.getClass().getSimpleName() + "'s incrementUnitType (" + String.valueOf(incrementUnitType) + ") must fit an integer number of times in the space (" + space + ") between from (" + String.valueOf(from) + ") and to (" + String.valueOf(to) + ").\nThe to (" + String.valueOf(to) + ") is not the expectedTo (" + String.valueOf(expectedTo) + ") nor the roundedExpectedTo (" + String.valueOf(roundedExpectedTo) + ").");
            }
        }
        if (space % incrementUnitAmount > 0L) {
            throw new IllegalArgumentException("The " + this.getClass().getSimpleName() + "'s incrementUnitAmount (" + incrementUnitAmount + ") must fit an integer number of times in the space (" + space + ") between from (" + String.valueOf(from) + ") and to (" + String.valueOf(to) + ").");
        }
        this.size = space / incrementUnitAmount;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public Temporal_ get(long index) {
        if (index >= this.size || index < 0L) {
            throw new IndexOutOfBoundsException();
        }
        return (Temporal_)this.from.plus(index * this.incrementUnitAmount, this.incrementUnitType);
    }

    @Override
    public boolean contains(Temporal_ value) {
        if (value == null || !value.isSupported(this.incrementUnitType)) {
            return false;
        }
        if (((Comparable)value).compareTo(this.from) < 0 || ((Comparable)value).compareTo(this.to) >= 0) {
            return false;
        }
        long fromSpace = this.from.until((Temporal)value, this.incrementUnitType);
        if (value.equals(this.from.plus(fromSpace + 1L, this.incrementUnitType))) {
            ++fromSpace;
        }
        return fromSpace % this.incrementUnitAmount == 0L && value.equals(this.from.plus(fromSpace, this.incrementUnitType));
    }

    @Override
    public @NonNull Iterator<Temporal_> createOriginalIterator() {
        return new OriginalTemporalValueRangeIterator();
    }

    @Override
    public @NonNull Iterator<Temporal_> createRandomIterator(@NonNull Random workingRandom) {
        return new RandomTemporalValueRangeIterator(workingRandom);
    }

    public boolean equals(Object o) {
        if (!(o instanceof TemporalValueRange)) {
            return false;
        }
        TemporalValueRange that = (TemporalValueRange)o;
        return this.incrementUnitAmount == that.incrementUnitAmount && Objects.equals(this.incrementUnitType, that.incrementUnitType) && Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Long.hashCode(this.incrementUnitAmount);
        hash = 31 * hash + Objects.hashCode(this.incrementUnitType);
        hash = 31 * hash + Objects.hashCode(this.from);
        hash = 31 * hash + Objects.hashCode(this.to);
        return hash;
    }

    public String toString() {
        return "[" + String.valueOf(this.from) + "-" + String.valueOf(this.to) + ")";
    }

    private class OriginalTemporalValueRangeIterator
    extends ValueRangeIterator<Temporal_> {
        private long index = 0L;

        private OriginalTemporalValueRangeIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < TemporalValueRange.this.size;
        }

        @Override
        public Temporal_ next() {
            if (this.index >= TemporalValueRange.this.size) {
                throw new NoSuchElementException();
            }
            Object next = TemporalValueRange.this.get(this.index);
            ++this.index;
            return next;
        }
    }

    private class RandomTemporalValueRangeIterator
    extends ValueRangeIterator<Temporal_> {
        private final Random workingRandom;

        public RandomTemporalValueRangeIterator(Random workingRandom) {
            this.workingRandom = workingRandom;
        }

        @Override
        public boolean hasNext() {
            return TemporalValueRange.this.size > 0L;
        }

        @Override
        public Temporal_ next() {
            long index = RandomUtils.nextLong(this.workingRandom, TemporalValueRange.this.size);
            return TemporalValueRange.this.get(index);
        }
    }
}

