/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.valuerange.buildin.collection;

import ai.timefold.solver.core.api.domain.valuerange.ValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.AbstractCountableValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.ValueRangeCache;
import ai.timefold.solver.core.impl.domain.valuerange.sort.ValueRangeSorter;
import java.util.Iterator;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class SetValueRange<T>
extends AbstractCountableValueRange<T> {
    private static final int VALUES_TO_LIST_IN_TO_STRING = 3;
    private static final String VALUE_DELIMITER = ", ";
    private final boolean isValueImmutable;
    private final Set<T> set;
    private @Nullable ValueRangeCache<T> cache;

    public SetValueRange(Set<T> set) {
        this(set, false);
    }

    public SetValueRange(Set<T> set, boolean isValueImmutable) {
        this.isValueImmutable = isValueImmutable;
        this.set = set;
    }

    @Override
    public boolean isValueImmutable() {
        return this.isValueImmutable;
    }

    @Override
    public long getSize() {
        return this.set.size();
    }

    @Override
    public @Nullable T get(long index) {
        return this.getCache().get((int)index);
    }

    private ValueRangeCache<T> getCache() {
        if (this.cache == null) {
            ValueRangeCache.Builder cacheBuilder = this.isValueImmutable ? ValueRangeCache.Builder.FOR_TRUSTED_VALUES : ValueRangeCache.Builder.FOR_USER_VALUES;
            this.cache = cacheBuilder.buildCache(this.set);
        }
        return this.cache;
    }

    @Override
    public boolean contains(@Nullable T value) {
        return this.set.contains(value);
    }

    @Override
    public ValueRange<T> sort(ValueRangeSorter<T> sorter) {
        SortedSet<T> sortedSet = sorter.sort(this.set);
        return new SetValueRange<T>(sortedSet);
    }

    @Override
    public Iterator<T> createOriginalIterator() {
        return this.set.iterator();
    }

    @Override
    public Iterator<T> createRandomIterator(Random workingRandom) {
        return this.getCache().iterator(workingRandom);
    }

    public boolean equals(Object o) {
        if (!(o instanceof SetValueRange)) {
            return false;
        }
        SetValueRange that = (SetValueRange)o;
        return this.isValueImmutable == that.isValueImmutable && Objects.equals(this.set, that.set);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Boolean.hashCode(this.isValueImmutable);
        hash = 31 * hash + Objects.hashCode(this.set);
        return hash;
    }

    public String toString() {
        String suffix = this.set.size() > 3 ? ", ...}" : "}";
        return this.set.isEmpty() ? "{}" : this.set.stream().limit(3L).map(Object::toString).collect(Collectors.joining(VALUE_DELIMITER, "{", suffix));
    }
}

