/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.solution.cloner.gizmo;

import ai.timefold.solver.core.api.domain.solution.cloner.SolutionCloner;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoClassLoader;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoMemberDescriptor;
import ai.timefold.solver.core.impl.domain.solution.cloner.DeepCloningUtils;
import ai.timefold.solver.core.impl.domain.solution.cloner.FieldAccessingSolutionCloner;
import ai.timefold.solver.core.impl.domain.solution.cloner.PlanningCloneable;
import ai.timefold.solver.core.impl.domain.solution.cloner.gizmo.GizmoCloningUtils;
import ai.timefold.solver.core.impl.domain.solution.cloner.gizmo.GizmoSolutionCloner;
import ai.timefold.solver.core.impl.domain.solution.cloner.gizmo.GizmoSolutionClonerClassOutput;
import ai.timefold.solver.core.impl.domain.solution.cloner.gizmo.GizmoSolutionClonerFactory;
import ai.timefold.solver.core.impl.domain.solution.cloner.gizmo.GizmoSolutionOrEntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import io.quarkus.gizmo2.Assignable;
import io.quarkus.gizmo2.ClassOutput;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.Gizmo;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.ParamVar;
import io.quarkus.gizmo2.StaticFieldVar;
import io.quarkus.gizmo2.Var;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ClassCreator;
import io.quarkus.gizmo2.desc.ClassMethodDesc;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import java.lang.constant.ClassDesc;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class GizmoSolutionClonerImplementor {
    private static final String FALLBACK_CLONER = "fallbackCloner";
    public static final boolean DEBUG = false;

    public static Comparator<Class<?>> getInstanceOfComparator(Set<Class<?>> deepClonedClassSet) {
        HashMap classToSubclassLevel = new HashMap();
        deepClonedClassSet.forEach(clazz -> {
            if (deepClonedClassSet.stream().allMatch(otherClazz -> clazz.isAssignableFrom((Class<?>)otherClazz) || !otherClazz.isAssignableFrom((Class<?>)clazz))) {
                classToSubclassLevel.put(clazz, 0);
            }
        });
        boolean isChanged = true;
        while (isChanged) {
            isChanged = false;
            for (Class<?> clazz2 : deepClonedClassSet) {
                isChanged |= classToSubclassLevel.keySet().stream().filter(otherClazz -> otherClazz != clazz2 && otherClazz.isAssignableFrom(clazz2)).map(classToSubclassLevel::get).max(Integer::compare).map(subclassLevel -> {
                    int oldVal = classToSubclassLevel.getOrDefault(clazz2, -1);
                    int newVal = subclassLevel + 1;
                    if (newVal > oldVal) {
                        classToSubclassLevel.put(clazz2, newVal);
                        return true;
                    }
                    return false;
                }).orElse(false).booleanValue();
            }
        }
        return Comparator.comparing(classToSubclassLevel::get).thenComparing(Class::getName).reversed();
    }

    protected ClonerDescriptor withFallbackClonerField(ClonerDescriptor clonerDescriptor) {
        return clonerDescriptor.withFallbackClonerField(clonerDescriptor.classCreator.staticField(FALLBACK_CLONER, field -> {
            field.private_();
            field.setType(FieldAccessingSolutionCloner.class);
        }));
    }

    public static void defineClonerFor(ClassCreator classCreator, SolutionDescriptor<?> solutionDescriptor, Set<Class<?>> solutionClassSet, Map<Class<?>, GizmoSolutionOrEntityDescriptor> memoizedSolutionOrEntityDescriptorMap, Set<Class<?>> deepClonedClassSet) {
        GizmoSolutionClonerImplementor.defineClonerFor(GizmoSolutionClonerImplementor::new, classCreator, solutionDescriptor, solutionClassSet, memoizedSolutionOrEntityDescriptorMap, deepClonedClassSet);
    }

    public static boolean isCloneableClass(Class<?> clazz) {
        return !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers());
    }

    public static void defineClonerFor(Supplier<GizmoSolutionClonerImplementor> implementorSupplier, ClassCreator classCreator, SolutionDescriptor<?> solutionDescriptor, Set<Class<?>> solutionClassSet, Map<Class<?>, GizmoSolutionOrEntityDescriptor> memoizedSolutionOrEntityDescriptorMap, Set<Class<?>> deepClonedClassSet) {
        GizmoSolutionClonerImplementor implementor = implementorSupplier.get();
        Set deepCloneClassesThatAreNotSolutionSet = deepClonedClassSet.stream().filter(clazz -> !solutionClassSet.contains(clazz) && !clazz.isArray()).filter(GizmoSolutionClonerImplementor::isCloneableClass).collect(Collectors.toSet());
        Comparator<Class<?>> instanceOfComparator = GizmoSolutionClonerImplementor.getInstanceOfComparator(deepClonedClassSet);
        TreeSet deepCloneClassesThatAreNotSolutionSortedSet = new TreeSet(instanceOfComparator);
        deepCloneClassesThatAreNotSolutionSortedSet.addAll(deepCloneClassesThatAreNotSolutionSet);
        ClonerDescriptor clonerDescriptor = new ClonerDescriptor(solutionDescriptor, memoizedSolutionOrEntityDescriptorMap, deepCloneClassesThatAreNotSolutionSortedSet, classCreator, null);
        classCreator.defaultConstructor();
        clonerDescriptor = implementor.withFallbackClonerField(clonerDescriptor);
        implementor.createSetSolutionDescriptor(clonerDescriptor);
        GizmoSolutionClonerImplementor.createCloneSolutionRun(clonerDescriptor, solutionClassSet, instanceOfComparator);
        GizmoSolutionClonerImplementor.createCloneSolution(clonerDescriptor);
        for (Class<?> deepClonedClass : deepCloneClassesThatAreNotSolutionSortedSet) {
            implementor.createDeepCloneHelperMethod(clonerDescriptor, deepClonedClass);
        }
        Set abstractDeepCloneClassSet = deepClonedClassSet.stream().filter(clazz -> !solutionClassSet.contains(clazz) && !clazz.isArray()).filter(Predicate.not(GizmoSolutionClonerImplementor::isCloneableClass)).collect(Collectors.toSet());
        for (Class abstractDeepClonedClass : abstractDeepCloneClassSet) {
            implementor.createAbstractDeepCloneHelperMethod(clonerDescriptor, abstractDeepClonedClass);
        }
    }

    public static ClassOutput createClassOutputWithDebuggingCapability(Map<String, byte[]> classBytecodeHolder) {
        return new GizmoSolutionClonerClassOutput(classBytecodeHolder);
    }

    static <T> SolutionCloner<T> createClonerFor(SolutionDescriptor<T> solutionDescriptor, GizmoClassLoader gizmoClassLoader) {
        GizmoSolutionClonerImplementor implementor = new GizmoSolutionClonerImplementor();
        String className = GizmoSolutionClonerFactory.getGeneratedClassName(solutionDescriptor);
        if (gizmoClassLoader.hasBytecodeFor(className)) {
            return implementor.createInstance(className, gizmoClassLoader, solutionDescriptor);
        }
        HashMap<String, byte[]> classBytecodeHolder = new HashMap<String, byte[]>();
        Gizmo gizmo = Gizmo.create((ClassOutput)GizmoSolutionClonerImplementor.createClassOutputWithDebuggingCapability(classBytecodeHolder));
        gizmo.class_(className, classCreator -> {
            classCreator.implements_(GizmoSolutionCloner.class);
            classCreator.extends_(Object.class);
            classCreator.final_();
            Set<Class<?>> deepClonedClassSet = GizmoCloningUtils.getDeepClonedClasses(solutionDescriptor, Collections.emptyList());
            GizmoSolutionClonerImplementor.defineClonerFor(() -> implementor, classCreator, solutionDescriptor, Collections.singleton(solutionDescriptor.getSolutionClass()), new HashMap(), deepClonedClassSet);
        });
        for (Map.Entry<String, byte[]> bytecodeEntry : classBytecodeHolder.entrySet()) {
            gizmoClassLoader.storeBytecode(bytecodeEntry.getKey(), bytecodeEntry.getValue());
        }
        return implementor.createInstance(className, gizmoClassLoader, solutionDescriptor);
    }

    private <T> SolutionCloner<T> createInstance(String className, ClassLoader gizmoClassLoader, SolutionDescriptor<T> solutionDescriptor) {
        try {
            Class<?> outClass = gizmoClassLoader.loadClass(className);
            GizmoSolutionCloner out = (GizmoSolutionCloner)outClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            out.setSolutionDescriptor(solutionDescriptor);
            return out;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void createSetSolutionDescriptor(ClonerDescriptor clonerDescriptor) {
        clonerDescriptor.classCreator.method("setSolutionDescriptor", methodCreator -> {
            methodCreator.public_();
            methodCreator.returning(Void.TYPE);
            ParamVar solutionDescriptor = methodCreator.parameter("solutionDescriptor", SolutionDescriptor.class);
            methodCreator.body(blockCreator -> {
                blockCreator.set((Assignable)clonerDescriptor.fallbackClonerField, blockCreator.new_(FieldAccessingSolutionCloner.class, (Expr)solutionDescriptor));
                blockCreator.return_();
            });
        });
    }

    private static void createCloneSolution(ClonerDescriptor clonerDescriptor) {
        Class<?> solutionClass = clonerDescriptor.solutionDescriptor.getSolutionClass();
        clonerDescriptor.classCreator.method("cloneSolution", methodCreator -> {
            methodCreator.returning(Object.class);
            ParamVar original = methodCreator.parameter("original", Object.class);
            methodCreator.body(blockCreator -> {
                Expr clone = blockCreator.invokeStatic((MethodDesc)ClassMethodDesc.of((ClassDesc)ClassDesc.of(GizmoSolutionClonerFactory.getGeneratedClassName(clonerDescriptor.solutionDescriptor)), (String)"cloneSolutionRun", (Class)solutionClass, (Class[])new Class[]{solutionClass, Map.class}), (Expr)original, blockCreator.new_(IdentityHashMap.class));
                blockCreator.return_(clone);
            });
        });
    }

    private static void createCloneSolutionRun(ClonerDescriptor clonerDescriptor, Set<Class<?>> solutionClassSet, Comparator<Class<?>> instanceOfComparator) {
        Class<?> solutionClass = clonerDescriptor.solutionDescriptor.getSolutionClass();
        clonerDescriptor.classCreator.staticMethod("cloneSolutionRun", methodCreator -> {
            methodCreator.public_();
            methodCreator.returning(solutionClass);
            ParamVar thisObj = methodCreator.parameter("original", solutionClass);
            ParamVar createdCloneMap = methodCreator.parameter("cloneMap", Map.class);
            methodCreator.body(blockCreator -> {
                blockCreator.ifNull((Expr)thisObj, BlockCreator::returnNull);
                LocalVar maybeClone = blockCreator.localVar("existingClone", solutionClass, blockCreator.withMap((Expr)createdCloneMap).get((Expr)thisObj));
                blockCreator.ifNotNull((Expr)maybeClone, hasCloneBranch -> hasCloneBranch.return_((Expr)maybeClone));
                ArrayList sortedSolutionClassList = new ArrayList(solutionClassSet);
                sortedSolutionClassList.sort(instanceOfComparator);
                LocalVar thisObjClass = blockCreator.localVar("clonedObjectClass", blockCreator.withObject((Expr)thisObj).getClass_());
                for (Class solutionSubclass : sortedSolutionClassList) {
                    Const solutionSubclassConst = Const.of((Class)solutionSubclass);
                    Expr isSubclass = blockCreator.objEquals((Expr)solutionSubclassConst, (Expr)thisObjClass);
                    blockCreator.if_(isSubclass, isExactMatchBranch -> isExactMatchBranch.ifInstanceOf((Expr)thisObj, solutionSubclass, (isExactMatchWithCastBranch, castedSolution) -> {
                        GizmoSolutionOrEntityDescriptor solutionSubclassDescriptor = clonerDescriptor.memoizedSolutionOrEntityDescriptorMap.computeIfAbsent(solutionSubclass, key -> new GizmoSolutionOrEntityDescriptor(clonerDescriptor.solutionDescriptor, solutionSubclass));
                        LocalVar clone = isExactMatchWithCastBranch.localVar("newClone", solutionSubclass, (Expr)Const.ofNull((Class)solutionSubclass));
                        if (PlanningCloneable.class.isAssignableFrom(solutionSubclass)) {
                            Expr newInstance = isExactMatchWithCastBranch.invokeInterface(MethodDesc.of(PlanningCloneable.class, (String)"createNewInstance", Object.class, (Class[])new Class[0]), (Expr)castedSolution);
                            isExactMatchWithCastBranch.set((Assignable)clone, newInstance);
                        } else {
                            isExactMatchWithCastBranch.set((Assignable)clone, isExactMatchWithCastBranch.new_(ConstructorDesc.of((Class)solutionSubclass, (Class[])new Class[0])));
                        }
                        isExactMatchWithCastBranch.withMap((Expr)createdCloneMap).put((Expr)castedSolution, (Expr)clone);
                        GizmoSolutionClonerImplementor.cloneShallowlyClonedFieldsOfObject(solutionSubclassDescriptor, clonerDescriptor, new ClonerMethodDescriptor(solutionSubclassDescriptor, (BlockCreator)isExactMatchWithCastBranch, (Var)createdCloneMap, true, (Var)isExactMatchWithCastBranch.localVar("cloneQueue", isExactMatchWithCastBranch.new_(ConstructorDesc.of(ArrayDeque.class, (Class[])new Class[0])))), (Var)castedSolution, (Var)clone);
                        GizmoSolutionClonerImplementor.cloneDeepClonedFieldsOfSolution(clonerDescriptor, solutionSubclassDescriptor, isExactMatchWithCastBranch, (Var)castedSolution, (Var)createdCloneMap, (Var)clone);
                        isExactMatchWithCastBranch.return_((Expr)clone);
                    }));
                }
                LocalVar errorBuilder = blockCreator.localVar("errorMessageBuilder", blockCreator.new_(ConstructorDesc.of(StringBuilder.class, (Class[])new Class[]{String.class}), (Expr)Const.of((String)"Failed to create clone: encountered (")));
                String errorTemplate = "which is not a known subclass of the solution class (%s).\nThe known subclasses are: %s.\nMaybe use DomainAccessType.REFLECTION?\n".formatted(clonerDescriptor.solutionDescriptor.getSolutionClass(), solutionClassSet.stream().map(Class::getName).collect(Collectors.joining(", ", "[", "]")));
                MethodDesc APPEND = MethodDesc.of(StringBuilder.class, (String)"append", StringBuilder.class, (Class[])new Class[]{Object.class});
                blockCreator.invokeVirtual(APPEND, (Expr)errorBuilder, (Expr)thisObjClass);
                blockCreator.invokeVirtual(APPEND, (Expr)errorBuilder, (Expr)Const.of((String)(") " + errorTemplate)));
                Expr errorMsg = blockCreator.invokeVirtual(MethodDesc.of(Object.class, (String)"toString", String.class, (Class[])new Class[0]), (Expr)errorBuilder);
                Expr error = blockCreator.new_(ConstructorDesc.of(IllegalArgumentException.class, (Class[])new Class[]{String.class}), errorMsg);
                blockCreator.throw_(error);
            });
        });
    }

    private static void cloneDeepClonedFieldsOfSolution(ClonerDescriptor clonerDescriptor, GizmoSolutionOrEntityDescriptor solutionSubclassDescriptor, BlockCreator isSubclassBranch, Var thisObj, Var createdCloneMap, Var clone) {
        for (Field deeplyClonedField : solutionSubclassDescriptor.getDeepClonedFields()) {
            GizmoMemberDescriptor gizmoMemberDescriptor = solutionSubclassDescriptor.getMemberDescriptorForField(deeplyClonedField);
            LocalVar fieldValue = isSubclassBranch.localVar(deeplyClonedField.getName() + "$Value", gizmoMemberDescriptor.readMemberValue(isSubclassBranch, (Expr)thisObj));
            LocalVar cloneValue = isSubclassBranch.localVar(deeplyClonedField.getName() + "$Clone", deeplyClonedField.getType(), (Expr)Const.ofNull(deeplyClonedField.getType()));
            GizmoSolutionClonerImplementor.writeDeepCloneInstructions(clonerDescriptor, new ClonerMethodDescriptor(solutionSubclassDescriptor, isSubclassBranch, createdCloneMap, true, (Var)isSubclassBranch.localVar(deeplyClonedField.getName() + "$Queue", isSubclassBranch.new_(ArrayDeque.class))), deeplyClonedField, gizmoMemberDescriptor, (Var)fieldValue, (Var)cloneValue);
            if (gizmoMemberDescriptor.writeMemberValue(isSubclassBranch, (Expr)clone, (Expr)cloneValue)) continue;
            throw new IllegalStateException("The member (%s) of class (%s) does not have a setter.".formatted(gizmoMemberDescriptor.getName(), gizmoMemberDescriptor.getDeclaringClassName()));
        }
    }

    private static void cloneShallowlyClonedFieldsOfObject(GizmoSolutionOrEntityDescriptor solutionSubclassDescriptor, ClonerDescriptor clonerDescriptor, ClonerMethodDescriptor solutionSubclassDescriptor1, Var thisObj, Var clone) {
        for (GizmoMemberDescriptor shallowlyClonedField : solutionSubclassDescriptor.getShallowClonedMemberDescriptors()) {
            GizmoSolutionClonerImplementor.writeShallowCloneInstructions(clonerDescriptor, solutionSubclassDescriptor1, shallowlyClonedField, thisObj, clone);
        }
    }

    private static void writeShallowCloneInstructions(ClonerDescriptor clonerDescriptor, ClonerMethodDescriptor clonerMethodDescriptor, GizmoMemberDescriptor shallowlyClonedField, Var thisObj, Var clone) {
        try {
            boolean isArray = shallowlyClonedField.getTypeName().endsWith("[]");
            Class<?> type = null;
            if (shallowlyClonedField.getType() instanceof Class) {
                type = (Class<?>)shallowlyClonedField.getType();
            }
            List<Object> entitySubclasses = Collections.emptyList();
            if (type == null && !isArray) {
                type = Class.forName(shallowlyClonedField.getTypeName().replace('/', '.'), false, Thread.currentThread().getContextClassLoader());
            }
            if (type != null && !isArray) {
                entitySubclasses = clonerDescriptor.deepClonedClassesSortedSet.stream().filter(type::isAssignableFrom).toList();
            }
            LocalVar fieldValue = clonerMethodDescriptor.blockCreator.localVar(shallowlyClonedField.getName() + "$Value", shallowlyClonedField.readMemberValue(clonerMethodDescriptor.blockCreator, (Expr)thisObj));
            if (!entitySubclasses.isEmpty()) {
                LocalVar cloneResultHolder = clonerMethodDescriptor.blockCreator.localVar(shallowlyClonedField.getName() + "$Clone", type, (Expr)Const.ofNull(type));
                GizmoSolutionClonerImplementor.writeDeepCloneEntityOrFactInstructions(clonerDescriptor, clonerMethodDescriptor, type, (Var)fieldValue, (Var)cloneResultHolder, UnhandledCloneType.SHALLOW);
                fieldValue = cloneResultHolder;
            }
            if (!shallowlyClonedField.writeMemberValue(clonerMethodDescriptor.blockCreator, (Expr)clone, (Expr)fieldValue)) {
                throw new IllegalStateException("Field (%s) of class (%s) does not have a setter.".formatted(shallowlyClonedField.getName(), shallowlyClonedField.getDeclaringClassName()));
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Error creating Gizmo Solution Cloner", e);
        }
    }

    private static void writeDeepCloneInstructions(ClonerDescriptor clonerDescriptor, ClonerMethodDescriptor clonerMethodDescriptor, Field deeplyClonedField, GizmoMemberDescriptor gizmoMemberDescriptor, Var toClone, Var cloneResultHolder) {
        BlockCreator blockCreator = clonerMethodDescriptor.blockCreator;
        blockCreator.ifNull((Expr)toClone, isNullBranch -> isNullBranch.set((Assignable)cloneResultHolder, Const.ofNull((ClassDesc)cloneResultHolder.type())));
        blockCreator.ifNotNull((Expr)toClone, isNotNullBranch -> {
            Class<?> deeplyClonedFieldClass = deeplyClonedField.getType();
            Type type = gizmoMemberDescriptor.getType();
            if (clonerMethodDescriptor.entityDescriptor.getSolutionDescriptor().getSolutionClass().isAssignableFrom(deeplyClonedFieldClass)) {
                GizmoSolutionClonerImplementor.writeDeepCloneSolutionInstructions(clonerMethodDescriptor.withBlockCreator((BlockCreator)isNotNullBranch), toClone, cloneResultHolder);
            } else if (Collection.class.isAssignableFrom(deeplyClonedFieldClass)) {
                GizmoSolutionClonerImplementor.writeDeepCloneCollectionInstructions(clonerDescriptor, clonerMethodDescriptor.withBlockCreator((BlockCreator)isNotNullBranch), deeplyClonedFieldClass, type, toClone, cloneResultHolder);
            } else if (Map.class.isAssignableFrom(deeplyClonedFieldClass)) {
                GizmoSolutionClonerImplementor.writeDeepCloneMapInstructions(clonerDescriptor, clonerMethodDescriptor.withBlockCreator((BlockCreator)isNotNullBranch), deeplyClonedFieldClass, type, toClone, cloneResultHolder);
            } else if (deeplyClonedFieldClass.isArray()) {
                GizmoSolutionClonerImplementor.writeDeepCloneArrayInstructions(clonerDescriptor, clonerMethodDescriptor.withBlockCreator((BlockCreator)isNotNullBranch), deeplyClonedFieldClass, toClone, cloneResultHolder);
            } else {
                UnhandledCloneType unknownClassCloneType = DeepCloningUtils.isFieldDeepCloned(clonerMethodDescriptor.entityDescriptor.solutionDescriptor, deeplyClonedField, deeplyClonedField.getDeclaringClass()) ? UnhandledCloneType.DEEP : UnhandledCloneType.SHALLOW;
                GizmoSolutionClonerImplementor.writeDeepCloneEntityOrFactInstructions(clonerDescriptor, clonerMethodDescriptor.withBlockCreator((BlockCreator)isNotNullBranch), deeplyClonedFieldClass, toClone, cloneResultHolder, unknownClassCloneType);
            }
        });
    }

    private static void writeDeepCloneInstructions(ClonerDescriptor clonerDescriptor, ClonerMethodDescriptor clonerMethodDescriptor, Class<?> deeplyClonedFieldClass, Type type, Var toClone, Var cloneResultHolder) {
        BlockCreator blockCreator = clonerMethodDescriptor.blockCreator;
        blockCreator.ifNull((Expr)toClone, ifNullBranch -> ifNullBranch.set((Assignable)cloneResultHolder, Const.ofNull((ClassDesc)cloneResultHolder.type())));
        blockCreator.ifNotNull((Expr)toClone, isNotNullBranch -> {
            if (clonerMethodDescriptor.entityDescriptor.getSolutionDescriptor().getSolutionClass().isAssignableFrom(deeplyClonedFieldClass)) {
                GizmoSolutionClonerImplementor.writeDeepCloneSolutionInstructions(clonerMethodDescriptor, toClone, cloneResultHolder);
            } else if (Collection.class.isAssignableFrom(deeplyClonedFieldClass)) {
                GizmoSolutionClonerImplementor.writeDeepCloneCollectionInstructions(clonerDescriptor, clonerMethodDescriptor.withBlockCreator((BlockCreator)isNotNullBranch), deeplyClonedFieldClass, type, toClone, cloneResultHolder);
            } else if (Map.class.isAssignableFrom(deeplyClonedFieldClass)) {
                GizmoSolutionClonerImplementor.writeDeepCloneMapInstructions(clonerDescriptor, clonerMethodDescriptor.withBlockCreator((BlockCreator)isNotNullBranch), deeplyClonedFieldClass, type, toClone, cloneResultHolder);
            } else if (deeplyClonedFieldClass.isArray()) {
                GizmoSolutionClonerImplementor.writeDeepCloneArrayInstructions(clonerDescriptor, clonerMethodDescriptor.withBlockCreator((BlockCreator)isNotNullBranch), deeplyClonedFieldClass, toClone, cloneResultHolder);
            } else {
                UnhandledCloneType unknownClassCloneType = DeepCloningUtils.isClassDeepCloned(clonerMethodDescriptor.entityDescriptor.solutionDescriptor, deeplyClonedFieldClass) ? UnhandledCloneType.DEEP : UnhandledCloneType.SHALLOW;
                GizmoSolutionClonerImplementor.writeDeepCloneEntityOrFactInstructions(clonerDescriptor, clonerMethodDescriptor.withBlockCreator((BlockCreator)isNotNullBranch), deeplyClonedFieldClass, toClone, cloneResultHolder, unknownClassCloneType);
            }
        });
    }

    private static void writeDeepCloneSolutionInstructions(ClonerMethodDescriptor clonerMethodDescriptor, Var toClone, Var cloneResultHolder) {
        clonerMethodDescriptor.blockCreator.ifNull((Expr)toClone, isNullBranch -> isNullBranch.set((Assignable)cloneResultHolder, Const.ofNull((ClassDesc)cloneResultHolder.type())));
        clonerMethodDescriptor.blockCreator.ifNotNull((Expr)toClone, isNotNullBranch -> {
            Expr clone = isNotNullBranch.invokeStatic((MethodDesc)ClassMethodDesc.of((ClassDesc)ClassDesc.of(GizmoSolutionClonerFactory.getGeneratedClassName(clonerMethodDescriptor.entityDescriptor.getSolutionDescriptor())), (String)"cloneSolutionRun", clonerMethodDescriptor.entityDescriptor.getSolutionDescriptor().getSolutionClass(), (Class[])new Class[]{clonerMethodDescriptor.entityDescriptor.getSolutionDescriptor().getSolutionClass(), Map.class}), (Expr)toClone, (Expr)clonerMethodDescriptor.createdCloneMap);
            isNotNullBranch.set((Assignable)cloneResultHolder, clone);
        });
    }

    private static void writeDeepCloneCollectionInstructions(ClonerDescriptor clonerDescriptor, ClonerMethodDescriptor clonerMethodDescriptor, Class<?> deeplyClonedFieldClass, Type type, Var toClone, Var cloneResultHolder) {
        BlockCreator blockCreator = clonerMethodDescriptor.blockCreator;
        LocalVar constructedCollection = blockCreator.localVar(toClone.name() + "$ConstructedCollection", blockCreator.invokeStatic(MethodDesc.of(FieldAccessingSolutionCloner.class, (String)"constructCloneCollection", Collection.class, (Class[])new Class[]{Collection.class}), (Expr)toClone));
        GizmoSolutionClonerImplementor.checkCastAndAssign(blockCreator, deeplyClonedFieldClass, cloneResultHolder, (Var)constructedCollection);
        LocalVar iterator = blockCreator.localVar(toClone.name() + "$Iterator", blockCreator.withCollection((Expr)toClone).iterator());
        blockCreator.while_(condition -> condition.yield(condition.withIterator((Expr)iterator).hasNext()), whileLoopBlock -> {
            Class elementClass;
            if (!(type instanceof ParameterizedType)) throw new IllegalStateException("Cannot infer element type for Collection type (%s).".formatted(type));
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type elementClassType = parameterizedType.getActualTypeArguments()[0];
            if (elementClassType instanceof Class) {
                Class class1;
                elementClass = class1 = (Class)elementClassType;
            } else if (elementClassType instanceof ParameterizedType) {
                ParameterizedType parameterizedElementClassType = (ParameterizedType)elementClassType;
                elementClass = (Class)parameterizedElementClassType.getRawType();
            } else {
                if (!(elementClassType instanceof WildcardType)) throw new IllegalStateException("Unhandled type (%s).".formatted(elementClassType));
                WildcardType wildcardType = (WildcardType)elementClassType;
                elementClass = (Class)wildcardType.getUpperBounds()[0];
            }
            LocalVar next = whileLoopBlock.localVar(toClone.name() + "$Item", whileLoopBlock.withIterator((Expr)iterator).next());
            LocalVar clonedElement = whileLoopBlock.localVar(cloneResultHolder.name() + "$Item", elementClass, (Expr)Const.ofNull((Class)elementClass));
            GizmoSolutionClonerImplementor.writeDeepCloneInstructions(clonerDescriptor, clonerMethodDescriptor.withBlockCreator((BlockCreator)whileLoopBlock), elementClass, elementClassType, (Var)next, (Var)clonedElement);
            whileLoopBlock.withCollection((Expr)cloneResultHolder).add((Expr)clonedElement);
        });
    }

    private static void checkCastAndAssign(BlockCreator blockCreator, Class<?> deeplyClonedFieldClass, Var cloneResultHolder, Var constructedCollection) {
        blockCreator.ifInstanceOfElse((Expr)constructedCollection, deeplyClonedFieldClass, (isInstanceCreator, casted) -> isInstanceCreator.set((Assignable)cloneResultHolder, (Expr)casted), isNotInstanceCreator -> {
            try {
                LocalVar baseMessage = isNotInstanceCreator.localVar("message", (Expr)Const.of((String)"Constructed type (%s) is not assignable to field type (%s)."));
                Expr formattedMessage = isNotInstanceCreator.invokeVirtual(MethodDesc.of((Method)String.class.getMethod("formatted", Object[].class)), (Expr)baseMessage, isNotInstanceCreator.newArray(String.class, new Expr[]{isNotInstanceCreator.withClass(isNotInstanceCreator.withObject((Expr)constructedCollection).getClass_()).getName(), Const.of((String)deeplyClonedFieldClass.getName())}));
                isNotInstanceCreator.throw_(isNotInstanceCreator.new_(IllegalStateException.class, formattedMessage));
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static void writeDeepCloneMapInstructions(ClonerDescriptor clonerDescriptor, ClonerMethodDescriptor clonerMethodDescriptor, Class<?> deeplyClonedFieldClass, Type type, Var toClone, Var cloneResultHolder) {
        BlockCreator blockCreator = clonerMethodDescriptor.blockCreator;
        LocalVar constructedMap = blockCreator.localVar(toClone.name() + "$ConstructedMap", blockCreator.invokeStatic(MethodDesc.of(FieldAccessingSolutionCloner.class, (String)"constructCloneMap", Map.class, (Class[])new Class[]{Map.class}), (Expr)toClone));
        GizmoSolutionClonerImplementor.checkCastAndAssign(blockCreator, deeplyClonedFieldClass, cloneResultHolder, (Var)constructedMap);
        Expr entrySet = blockCreator.withMap((Expr)toClone).entrySet();
        LocalVar iterator = blockCreator.localVar(toClone.name() + "$EntrySet$Iterator", blockCreator.withCollection(entrySet).iterator());
        blockCreator.while_(condition -> condition.yield(condition.withIterator((Expr)iterator).hasNext()), whileLoopBlock -> {
            Class keyClass;
            Class elementClass;
            if (!(type instanceof ParameterizedType)) throw new IllegalStateException("Cannot infer element type for Map type (%s).".formatted(type));
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type keyType = parameterizedType.getActualTypeArguments()[0];
            Type elementClassType = parameterizedType.getActualTypeArguments()[1];
            if (elementClassType instanceof Class) {
                Class class1;
                elementClass = class1 = (Class)elementClassType;
            } else {
                if (!(elementClassType instanceof ParameterizedType)) throw new IllegalStateException("Unhandled type (%s).".formatted(elementClassType));
                ParameterizedType parameterizedElementClassType = (ParameterizedType)elementClassType;
                elementClass = (Class)parameterizedElementClassType.getRawType();
            }
            if (keyType instanceof Class) {
                Class class1;
                keyClass = class1 = (Class)keyType;
            } else {
                if (!(keyType instanceof ParameterizedType)) throw new IllegalStateException("Unhandled type (%s).".formatted(keyType));
                ParameterizedType parameterizedElementClassType = (ParameterizedType)keyType;
                keyClass = (Class)parameterizedElementClassType.getRawType();
            }
            List<Class> entitySubclasses = clonerDescriptor.deepClonedClassesSortedSet.stream().filter(keyClass::isAssignableFrom).toList();
            LocalVar entry = whileLoopBlock.localVar(toClone.name() + "$Entry", whileLoopBlock.withIterator((Expr)iterator).next());
            LocalVar toCloneValue = whileLoopBlock.localVar(toClone.name() + "$Value", whileLoopBlock.invokeInterface(MethodDesc.of(Map.Entry.class, (String)"getValue", Object.class, (Class[])new Class[0]), (Expr)entry));
            LocalVar clonedElement = whileLoopBlock.localVar(cloneResultHolder.name() + "$Element", elementClass, (Expr)Const.ofNull((Class)elementClass));
            GizmoSolutionClonerImplementor.writeDeepCloneInstructions(clonerDescriptor, clonerMethodDescriptor.withBlockCreator((BlockCreator)whileLoopBlock), elementClass, elementClassType, (Var)toCloneValue, (Var)clonedElement);
            LocalVar key = whileLoopBlock.localVar(toClone.name() + "$Key", whileLoopBlock.invokeInterface(MethodDesc.of(Map.Entry.class, (String)"getKey", Object.class, (Class[])new Class[0]), (Expr)entry));
            if (!entitySubclasses.isEmpty()) {
                LocalVar keyCloneResultHolder = whileLoopBlock.localVar(cloneResultHolder.name() + "$Key", keyClass, (Expr)Const.ofNull((Class)keyClass));
                GizmoSolutionClonerImplementor.writeDeepCloneEntityOrFactInstructions(clonerDescriptor, clonerMethodDescriptor.withBlockCreator((BlockCreator)whileLoopBlock), keyClass, (Var)key, (Var)keyCloneResultHolder, UnhandledCloneType.DEEP);
                whileLoopBlock.withMap((Expr)cloneResultHolder).put((Expr)keyCloneResultHolder, (Expr)clonedElement);
                return;
            } else {
                whileLoopBlock.withMap((Expr)cloneResultHolder).put((Expr)key, (Expr)clonedElement);
            }
        });
    }

    private static void writeDeepCloneArrayInstructions(ClonerDescriptor clonerDescriptor, ClonerMethodDescriptor clonerMethodDescriptor, Class<?> deeplyClonedFieldClass, Var toClone, Var cloneResultHolder) {
        BlockCreator blockCreator = clonerMethodDescriptor.blockCreator;
        Class<?> arrayComponent = deeplyClonedFieldClass.getComponentType();
        Expr arrayLength = toClone.length();
        blockCreator.set((Assignable)cloneResultHolder, blockCreator.newEmptyArray(arrayComponent, arrayLength));
        LocalVar iterations = blockCreator.localVar("i", (Expr)Const.of((int)0));
        blockCreator.while_(condition -> condition.yield(condition.lt((Expr)iterations, arrayLength)), whileLoopBlock -> {
            LocalVar toCloneElement = whileLoopBlock.localVar(toClone.name() + "$Element", (Expr)toClone.elem((Expr)iterations));
            LocalVar clonedElement = whileLoopBlock.localVar(cloneResultHolder.name() + "$Element", arrayComponent, (Expr)Const.ofNull((Class)arrayComponent));
            GizmoSolutionClonerImplementor.writeDeepCloneInstructions(clonerDescriptor, clonerMethodDescriptor.withBlockCreator((BlockCreator)whileLoopBlock), arrayComponent, arrayComponent, (Var)toCloneElement, (Var)clonedElement);
            whileLoopBlock.set(cloneResultHolder.elem((Expr)iterations), (Expr)clonedElement);
            whileLoopBlock.inc((Assignable)iterations);
        });
    }

    private static void writeDeepCloneEntityOrFactInstructions(ClonerDescriptor clonerDescriptor, ClonerMethodDescriptor clonerMethodDescriptor, Class<?> deeplyClonedFieldClass, Var toClone, Var cloneResultHolder, UnhandledCloneType unhandledCloneType) {
        List<Class> deepClonedSubclasses = clonerDescriptor.deepClonedClassesSortedSet.stream().filter(deeplyClonedFieldClass::isAssignableFrom).filter(type -> DeepCloningUtils.isClassDeepCloned(clonerMethodDescriptor.entityDescriptor.getSolutionDescriptor(), type)).toList();
        BlockCreator currentBranch = clonerMethodDescriptor.blockCreator;
        LocalVar isHandled = currentBranch.localVar(cloneResultHolder.name() + "$IsHandled", (Expr)Const.of((boolean)false));
        for (Class deepClonedSubclass : deepClonedSubclasses) {
            currentBranch.ifNot((Expr)isHandled, notHandledBranch -> notHandledBranch.ifInstanceOf((Expr)toClone, deepClonedSubclass, (isInstanceBranch, castedToClone) -> {
                Expr cloneObj = isInstanceBranch.invokeStatic((MethodDesc)ClassMethodDesc.of((ClassDesc)ClassDesc.of(GizmoSolutionClonerFactory.getGeneratedClassName(clonerMethodDescriptor.entityDescriptor.getSolutionDescriptor())), (String)GizmoSolutionClonerImplementor.getEntityHelperMethodName(deepClonedSubclass), (Class)deepClonedSubclass, (Class[])new Class[]{deepClonedSubclass, Map.class, Boolean.TYPE, ArrayDeque.class}), new Expr[]{castedToClone, clonerMethodDescriptor.createdCloneMap, Const.of((boolean)clonerMethodDescriptor.isBottom), clonerMethodDescriptor.cloneQueue});
                isInstanceBranch.set((Assignable)cloneResultHolder, cloneObj);
                isInstanceBranch.set((Assignable)isHandled, Const.of((boolean)true));
            }));
        }
        currentBranch.ifNot((Expr)isHandled, notHandledBranch -> {
            switch (unhandledCloneType) {
                case SHALLOW: {
                    notHandledBranch.set((Assignable)cloneResultHolder, (Expr)toClone);
                    break;
                }
                case DEEP: {
                    Expr cloneObj = notHandledBranch.invokeStatic((MethodDesc)ClassMethodDesc.of((ClassDesc)ClassDesc.of(GizmoSolutionClonerFactory.getGeneratedClassName(clonerMethodDescriptor.entityDescriptor.getSolutionDescriptor())), (String)GizmoSolutionClonerImplementor.getEntityHelperMethodName(deeplyClonedFieldClass), (Class)deeplyClonedFieldClass, (Class[])new Class[]{deeplyClonedFieldClass, Map.class, Boolean.TYPE, ArrayDeque.class}), new Expr[]{toClone, clonerMethodDescriptor.createdCloneMap, Const.of((boolean)clonerMethodDescriptor.isBottom), clonerMethodDescriptor.cloneQueue});
                    notHandledBranch.set((Assignable)cloneResultHolder, cloneObj);
                }
            }
        });
    }

    protected static String getEntityHelperMethodName(Class<?> entityClass) {
        return "$clone" + entityClass.getName().replace('.', '_');
    }

    protected void handleUnknownClass(ClonerDescriptor clonerDescriptor, ClonerMethodDescriptor clonerMethodDescriptor, Class<?> entityClass, Var toClone, Consumer<BlockCreator> knownClassHandler) {
        Expr actualClass = clonerMethodDescriptor.blockCreator.withObject((Expr)toClone).getClass_();
        LocalVar isClassReferenceNotEqual = clonerMethodDescriptor.blockCreator.localVar("isUnknownClass", clonerMethodDescriptor.blockCreator.ne(actualClass, (Expr)Const.of(entityClass)));
        clonerMethodDescriptor.blockCreator.if_((Expr)isClassReferenceNotEqual, currentBranch -> {
            StaticFieldVar fallbackCloner = clonerDescriptor.fallbackClonerField;
            Expr cloneObj = currentBranch.invokeVirtual(MethodDesc.of(FieldAccessingSolutionCloner.class, (String)"gizmoFallbackDeepClone", Object.class, (Class[])new Class[]{Object.class, Map.class}), (Expr)fallbackCloner, (Expr)toClone, (Expr)clonerMethodDescriptor.createdCloneMap);
            currentBranch.return_(cloneObj);
        });
        knownClassHandler.accept(clonerMethodDescriptor.blockCreator);
    }

    private void createDeepCloneHelperMethod(ClonerDescriptor clonerDescriptor, Class<?> entityClass) {
        clonerDescriptor.classCreator.staticMethod(GizmoSolutionClonerImplementor.getEntityHelperMethodName(entityClass), methodCreator -> {
            ParamVar toClone = methodCreator.parameter("toClone", entityClass);
            ParamVar cloneMap = methodCreator.parameter("cloneMap", Map.class);
            ParamVar isBottom = methodCreator.parameter("isBottom", Boolean.TYPE);
            ParamVar cloneQueue = methodCreator.parameter("cloneQueue", ArrayDeque.class);
            methodCreator.returning(entityClass);
            methodCreator.public_();
            methodCreator.body(blockCreator -> {
                GizmoSolutionOrEntityDescriptor entityDescriptor = clonerDescriptor.memoizedSolutionOrEntityDescriptorMap.computeIfAbsent(entityClass, key -> new GizmoSolutionOrEntityDescriptor(clonerDescriptor.solutionDescriptor, entityClass));
                LocalVar maybeClone = blockCreator.localVar("existingClone", blockCreator.withMap((Expr)cloneMap).get((Expr)toClone));
                blockCreator.ifNotNull((Expr)maybeClone, hasCloneBranch -> hasCloneBranch.return_((Expr)maybeClone));
                this.handleUnknownClass(clonerDescriptor, new ClonerMethodDescriptor(entityDescriptor, (BlockCreator)blockCreator, (Var)cloneMap, false, (Var)cloneQueue), entityClass, (Var)toClone, newNoCloneBranch -> {
                    LocalVar cloneObj = newNoCloneBranch.localVar("clonedObject", entityClass, (Expr)Const.ofNull((Class)entityClass));
                    if (PlanningCloneable.class.isAssignableFrom(entityClass)) {
                        newNoCloneBranch.set((Assignable)cloneObj, newNoCloneBranch.invokeInterface(MethodDesc.of(PlanningCloneable.class, (String)"createNewInstance", Object.class, (Class[])new Class[0]), (Expr)toClone));
                    } else {
                        newNoCloneBranch.set((Assignable)cloneObj, newNoCloneBranch.new_(entityClass));
                    }
                    newNoCloneBranch.withMap((Expr)cloneMap).put((Expr)toClone, (Expr)cloneObj);
                    ClonerMethodDescriptor clonerMethodDescriptor = new ClonerMethodDescriptor(entityDescriptor, (BlockCreator)newNoCloneBranch, (Var)cloneMap, false, (Var)cloneQueue);
                    GizmoSolutionClonerImplementor.cloneShallowlyClonedFieldsOfObject(entityDescriptor, clonerDescriptor, clonerMethodDescriptor, (Var)toClone, (Var)cloneObj);
                    for (Field deeplyClonedField : entityDescriptor.getDeepClonedFields()) {
                        GizmoSolutionClonerImplementor.addDeepCloneFieldInitializerToQueue(clonerDescriptor, clonerMethodDescriptor, deeplyClonedField, (Var)toClone, (Var)cloneObj);
                    }
                    newNoCloneBranch.if_((Expr)isBottom, bottomObjectBranch -> bottomObjectBranch.while_(condition -> condition.yield(condition.logicalNot(condition.invokeVirtual(MethodDesc.of(ArrayDeque.class, (String)"isEmpty", Boolean.TYPE, (Class[])new Class[0]), (Expr)cloneQueue))), queueNotEmptyBlock -> {
                        Expr next = queueNotEmptyBlock.invokeVirtual(MethodDesc.of(ArrayDeque.class, (String)"pop", Object.class, (Class[])new Class[0]), (Expr)cloneQueue);
                        queueNotEmptyBlock.invokeInterface(MethodDesc.of(BiConsumer.class, (String)"accept", Void.TYPE, (Class[])new Class[]{Object.class, Object.class}), next, (Expr)cloneMap, (Expr)cloneQueue);
                    }));
                    newNoCloneBranch.return_((Expr)cloneObj);
                });
            });
        });
    }

    private static void addDeepCloneFieldInitializerToQueue(ClonerDescriptor clonerDescriptor, ClonerMethodDescriptor clonerMethodDescriptor, Field deeplyClonedField, Var toClone, Var cloneObj) {
        GizmoSolutionOrEntityDescriptor entityDescriptor = clonerMethodDescriptor.entityDescriptor;
        BlockCreator blockCreator = clonerMethodDescriptor.blockCreator;
        Var cloneQueue = clonerMethodDescriptor.cloneQueue;
        GizmoMemberDescriptor gizmoMemberDescriptor = entityDescriptor.getMemberDescriptorForField(deeplyClonedField);
        Expr consumer = blockCreator.newAnonymousClass(BiConsumer.class, consumerClassCreator -> consumerClassCreator.method("accept", consumerMethodCreator -> {
            consumerMethodCreator.returning(Void.TYPE);
            ParamVar innerCloneMapObject = consumerMethodCreator.parameter("cloneMapObject", Object.class);
            ParamVar innerCloneQueueObject = consumerMethodCreator.parameter("cloneQueueObject", Object.class);
            consumerMethodCreator.body(consumerBlockCreator -> {
                LocalVar innerCloneMap = consumerBlockCreator.localVar("cloneMap", (Expr)innerCloneMapObject);
                LocalVar innerCloneQueue = consumerBlockCreator.localVar("cloneQueue", (Expr)innerCloneQueueObject);
                LocalVar subfieldValue = consumerBlockCreator.localVar("toClone", gizmoMemberDescriptor.readMemberValue((BlockCreator)consumerBlockCreator, (Expr)consumerClassCreator.capture(toClone)));
                LocalVar cloneValue = consumerBlockCreator.localVar("clonedValue", deeplyClonedField.getType(), (Expr)Const.ofNull(deeplyClonedField.getType()));
                GizmoSolutionClonerImplementor.writeDeepCloneInstructions(clonerDescriptor, clonerMethodDescriptor.withBlockCreator((BlockCreator)consumerBlockCreator).withCreatedCloneMap((Var)innerCloneMap).withCloneQueue((Var)innerCloneQueue), deeplyClonedField, gizmoMemberDescriptor, (Var)subfieldValue, (Var)cloneValue);
                if (!gizmoMemberDescriptor.writeMemberValue((BlockCreator)consumerBlockCreator, (Expr)consumerClassCreator.capture(cloneObj), (Expr)cloneValue)) {
                    throw new IllegalStateException("The member (%s) of class (%s) does not have a setter.".formatted(gizmoMemberDescriptor.getName(), gizmoMemberDescriptor.getDeclaringClassName()));
                }
                consumerBlockCreator.return_();
            });
        }));
        blockCreator.invokeVirtual(MethodDesc.of(ArrayDeque.class, (String)"push", Void.TYPE, (Class[])new Class[]{Object.class}), (Expr)cloneQueue, consumer);
    }

    protected void createAbstractDeepCloneHelperMethod(ClonerDescriptor clonerDescriptor, Class<?> entityClass) {
        clonerDescriptor.classCreator.staticMethod(GizmoSolutionClonerImplementor.getEntityHelperMethodName(entityClass), methodCreator -> {
            ParamVar toClone = methodCreator.parameter("toClone", entityClass);
            ParamVar cloneMap = methodCreator.parameter("cloneMap", Map.class);
            ParamVar ignoredIsBottom = methodCreator.parameter("isBottom", Boolean.TYPE);
            ParamVar ignoredQueue = methodCreator.parameter("cloneQueue", ArrayDeque.class);
            methodCreator.public_();
            methodCreator.returning(entityClass);
            methodCreator.body(blockCreator -> {
                LocalVar maybeClone = blockCreator.localVar("existingClone", blockCreator.withMap((Expr)cloneMap).get((Expr)toClone));
                blockCreator.ifNotNull((Expr)maybeClone, hasCloneBranch -> hasCloneBranch.return_((Expr)maybeClone));
                StaticFieldVar fallbackCloner = clonerDescriptor.fallbackClonerField;
                Expr cloneObj = blockCreator.invokeVirtual(MethodDesc.of(FieldAccessingSolutionCloner.class, (String)"gizmoFallbackDeepClone", Object.class, (Class[])new Class[]{Object.class, Map.class}), (Expr)fallbackCloner, (Expr)toClone, (Expr)cloneMap);
                blockCreator.return_(cloneObj);
            });
        });
    }

    protected record ClonerDescriptor(SolutionDescriptor<?> solutionDescriptor, Map<Class<?>, GizmoSolutionOrEntityDescriptor> memoizedSolutionOrEntityDescriptorMap, SortedSet<Class<?>> deepClonedClassesSortedSet, ClassCreator classCreator, StaticFieldVar fallbackClonerField) {
        public ClonerDescriptor withFallbackClonerField(StaticFieldVar fallbackClonerField) {
            return new ClonerDescriptor(this.solutionDescriptor, this.memoizedSolutionOrEntityDescriptorMap, this.deepClonedClassesSortedSet, this.classCreator, fallbackClonerField);
        }
    }

    protected record ClonerMethodDescriptor(GizmoSolutionOrEntityDescriptor entityDescriptor, BlockCreator blockCreator, Var createdCloneMap, boolean isBottom, Var cloneQueue) {
        public ClonerMethodDescriptor withBlockCreator(BlockCreator blockCreator) {
            return new ClonerMethodDescriptor(this.entityDescriptor, blockCreator, this.createdCloneMap, this.isBottom, this.cloneQueue);
        }

        public ClonerMethodDescriptor withCreatedCloneMap(Var createdCloneMap) {
            return new ClonerMethodDescriptor(this.entityDescriptor, this.blockCreator, createdCloneMap, this.isBottom, this.cloneQueue);
        }

        public ClonerMethodDescriptor withCloneQueue(Var cloneQueue) {
            return new ClonerMethodDescriptor(this.entityDescriptor, this.blockCreator, this.createdCloneMap, this.isBottom, cloneQueue);
        }
    }

    private static enum UnhandledCloneType {
        SHALLOW,
        DEEP;

    }
}

