/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.entity.descriptor;

import ai.timefold.solver.core.api.domain.common.ComparatorFactory;
import ai.timefold.solver.core.api.domain.entity.PinningFilter;
import ai.timefold.solver.core.api.domain.entity.PlanningEntity;
import ai.timefold.solver.core.api.domain.entity.PlanningPin;
import ai.timefold.solver.core.api.domain.entity.PlanningPinToIndex;
import ai.timefold.solver.core.api.domain.valuerange.ValueRangeProvider;
import ai.timefold.solver.core.api.domain.variable.AnchorShadowVariable;
import ai.timefold.solver.core.api.domain.variable.CascadingUpdateShadowVariable;
import ai.timefold.solver.core.api.domain.variable.CustomShadowVariable;
import ai.timefold.solver.core.api.domain.variable.IndexShadowVariable;
import ai.timefold.solver.core.api.domain.variable.InverseRelationShadowVariable;
import ai.timefold.solver.core.api.domain.variable.NextElementShadowVariable;
import ai.timefold.solver.core.api.domain.variable.PiggybackShadowVariable;
import ai.timefold.solver.core.api.domain.variable.PlanningListVariable;
import ai.timefold.solver.core.api.domain.variable.PlanningVariable;
import ai.timefold.solver.core.api.domain.variable.PreviousElementShadowVariable;
import ai.timefold.solver.core.api.domain.variable.ShadowVariable;
import ai.timefold.solver.core.api.domain.variable.ShadowVariablesInconsistent;
import ai.timefold.solver.core.config.heuristic.selector.common.decorator.SelectionSorterOrder;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.common.ReflectionHelper;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessorFactory;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptorValidator;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityForEachFilter;
import ai.timefold.solver.core.impl.domain.entity.descriptor.MovableFilter;
import ai.timefold.solver.core.impl.domain.entity.descriptor.PinEntityFilter;
import ai.timefold.solver.core.impl.domain.entity.descriptor.PlanningPinToIndexReader;
import ai.timefold.solver.core.impl.domain.policy.DescriptorPolicy;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.CompositeValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.variable.anchor.AnchorShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.cascade.CascadingUpdateShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.custom.CustomShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.custom.LegacyCustomShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.custom.PiggybackShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.declarative.DeclarativeShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.declarative.ShadowVariablesInconsistentVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.BasicVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.index.IndexShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.InverseRelationShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.nextprev.NextElementShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.nextprev.PreviousElementShadowVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.ComparatorFactorySelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.ComparatorSelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import ai.timefold.solver.core.impl.move.director.MoveDirector;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.stream.enumerating.function.UniEnumeratingFilter;
import ai.timefold.solver.core.impl.util.CollectionUtils;
import ai.timefold.solver.core.impl.util.MutableInt;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningEntityMetaModel;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityDescriptor<Solution_> {
    protected static final Class[] VARIABLE_ANNOTATION_CLASSES = new Class[]{PlanningVariable.class, PlanningListVariable.class, InverseRelationShadowVariable.class, AnchorShadowVariable.class, IndexShadowVariable.class, PreviousElementShadowVariable.class, NextElementShadowVariable.class, ShadowVariable.class, ShadowVariable.List.class, PiggybackShadowVariable.class, CustomShadowVariable.class, CascadingUpdateShadowVariable.class, ShadowVariablesInconsistent.class};
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityDescriptor.class);
    private final int ordinal;
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final Class<?> entityClass;
    private final List<Class<?>> declaredInheritedEntityClassList = new ArrayList();
    private final Predicate<Object> isInitializedPredicate;
    private final List<MemberAccessor> declaredPlanningPinIndexMemberAccessorList = new ArrayList<MemberAccessor>();
    private @Nullable ShadowVariablesInconsistentVariableDescriptor<Solution_> shadowVariablesInconsistentDescriptor;
    private MovableFilter<Solution_> declaredMovableEntityFilter;
    private SelectionSorter<Solution_, Object> descendingSorter;
    private Map<String, GenuineVariableDescriptor<Solution_>> declaredGenuineVariableDescriptorMap;
    private Map<String, ShadowVariableDescriptor<Solution_>> declaredShadowVariableDescriptorMap;
    private Map<String, CascadingUpdateShadowVariableDescriptor<Solution_>> declaredCascadingUpdateShadowVariableDecriptorMap;
    private List<MovableFilter<Solution_>> declaredPinEntityFilterList;
    private List<EntityDescriptor<Solution_>> effectiveInheritedEntityDescriptorList;
    private MovableFilter<Solution_> effectiveMovableEntityFilter;
    private PlanningPinToIndexReader effectivePlanningPinToIndexReader;
    private Map<String, GenuineVariableDescriptor<Solution_>> effectiveGenuineVariableDescriptorMap;
    private Map<String, ShadowVariableDescriptor<Solution_>> effectiveShadowVariableDescriptorMap;
    private Map<String, VariableDescriptor<Solution_>> effectiveVariableDescriptorMap;
    private List<GenuineVariableDescriptor<Solution_>> effectiveGenuineVariableDescriptorList;
    private List<ListVariableDescriptor<Solution_>> effectiveGenuineListVariableDescriptorList;
    private final UniEnumeratingFilter<Solution_, Object> entityMovablePredicate = (solutionView, entity) -> {
        MoveDirector moveDirector = (MoveDirector)solutionView;
        return !moveDirector.isPinned(this, entity);
    };
    private PlanningEntityMetaModel<Solution_, ?> entityMetaModel = null;
    private EntityForEachFilter entityForEachFilter = null;

    public EntityDescriptor(int ordinal, SolutionDescriptor<Solution_> solutionDescriptor, Class<?> entityClass) {
        this.ordinal = ordinal;
        SolutionDescriptor.assertMutable(entityClass, "entityClass");
        this.solutionDescriptor = solutionDescriptor;
        this.entityClass = entityClass;
        this.declaredInheritedEntityClassList.addAll(EntityDescriptor.extractInheritedClasses(entityClass));
        this.isInitializedPredicate = this::isInitialized;
        if (entityClass.getPackage() == null) {
            LOGGER.warn("The entityClass ({}) should be in a proper java package.", entityClass);
        }
    }

    public static Collection<Class<? extends Annotation>> getVariableAnnotationClasses() {
        return List.of(VARIABLE_ANNOTATION_CLASSES);
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    @Deprecated(forRemoval=true)
    public Predicate<Object> getIsInitializedPredicate() {
        return this.isInitializedPredicate;
    }

    public EntityForEachFilter getEntityForEachFilter() {
        if (this.entityForEachFilter == null) {
            this.entityForEachFilter = new EntityForEachFilter(this);
        }
        return this.entityForEachFilter;
    }

    public void processAnnotations(DescriptorPolicy descriptorPolicy) {
        this.processEntityAnnotations();
        this.declaredGenuineVariableDescriptorMap = new LinkedHashMap<String, GenuineVariableDescriptor<Solution_>>();
        this.declaredShadowVariableDescriptorMap = new LinkedHashMap<String, ShadowVariableDescriptor<Solution_>>();
        this.declaredCascadingUpdateShadowVariableDecriptorMap = new HashMap<String, CascadingUpdateShadowVariableDescriptor<Solution_>>();
        this.declaredPinEntityFilterList = new ArrayList<MovableFilter<Solution_>>(2);
        List<Member> memberList = ConfigUtils.getDeclaredMembers(this.entityClass);
        MutableInt variableDescriptorCounter = new MutableInt(0);
        for (Member member : memberList) {
            this.processValueRangeProviderAnnotation(descriptorPolicy, member);
            this.processPlanningVariableAnnotation(variableDescriptorCounter, descriptorPolicy, member);
            this.processPlanningPinAnnotation(descriptorPolicy, member);
        }
        if (this.declaredGenuineVariableDescriptorMap.isEmpty() && this.declaredShadowVariableDescriptorMap.isEmpty() && this.declaredInheritedEntityClassList.isEmpty()) {
            throw new IllegalStateException("The entityClass (%s) should have at least 1 getter method or 1 field with a %s annotation or a shadow variable annotation.".formatted(this.entityClass, PlanningVariable.class.getSimpleName()));
        }
        this.processVariableAnnotations(descriptorPolicy);
    }

    private void processEntityAnnotations() {
        EntityDescriptorValidator.assertNotMixedInheritance(this.entityClass, this.declaredInheritedEntityClassList);
        EntityDescriptorValidator.assertSingleInheritance(this.entityClass, this.declaredInheritedEntityClassList);
        EntityDescriptorValidator.assertValidPlanningVariables(this.entityClass);
        PlanningEntity entityAnnotation = this.entityClass.getAnnotation(PlanningEntity.class);
        if (entityAnnotation == null && this.declaredInheritedEntityClassList.isEmpty()) {
            throw new IllegalStateException("The entityClass (%s) has been specified as a planning entity in the configuration, but does not have a @%s annotation.".formatted(this.entityClass, PlanningEntity.class.getSimpleName()));
        }
        if (entityAnnotation == null) {
            entityAnnotation = this.declaredInheritedEntityClassList.stream().filter(c -> !c.equals(this.entityClass)).findFirst().map(c -> c.getAnnotation(PlanningEntity.class)).orElseThrow(() -> new IllegalStateException("Impossible state as the previous if block would fail first."));
        }
        this.processMovable(entityAnnotation);
        this.processSorting(entityAnnotation);
    }

    @Deprecated(forRemoval=true, since="1.23.0")
    private void processMovable(PlanningEntity entityAnnotation) {
        boolean hasPinningFilter;
        if (entityAnnotation == null) {
            return;
        }
        Class<? extends PinningFilter> pinningFilterClass = entityAnnotation.pinningFilter();
        boolean bl = hasPinningFilter = pinningFilterClass != PlanningEntity.NullPinningFilter.class;
        if (hasPinningFilter) {
            PinningFilter pinningFilter = ConfigUtils.newInstance(this::toString, "pinningFilterClass", pinningFilterClass);
            this.declaredMovableEntityFilter = (solution, selection) -> !pinningFilter.accept(solution, selection);
        }
    }

    private void processSorting(PlanningEntity entityAnnotation) {
        Class<? extends ComparatorFactory> comparatorFactoryClass;
        Class<? extends Comparator> comparatorClass;
        if (entityAnnotation == null) {
            return;
        }
        Class<? extends Comparator> difficultyComparatorClass = entityAnnotation.difficultyComparatorClass();
        if (difficultyComparatorClass != null && PlanningEntity.NullComparator.class.isAssignableFrom(difficultyComparatorClass)) {
            difficultyComparatorClass = null;
        }
        if ((comparatorClass = entityAnnotation.comparatorClass()) != null && PlanningEntity.NullComparator.class.isAssignableFrom(comparatorClass)) {
            comparatorClass = null;
        }
        if (difficultyComparatorClass != null && comparatorClass != null) {
            throw new IllegalStateException("The entityClass (%s) cannot have a %s (%s) and a %s (%s) at the same time.".formatted(this.getEntityClass(), "difficultyComparatorClass", difficultyComparatorClass.getName(), "comparatorClass", comparatorClass.getName()));
        }
        Class<? extends SelectionSorterWeightFactory> difficultyWeightFactoryClass = entityAnnotation.difficultyWeightFactoryClass();
        if (difficultyWeightFactoryClass != null && PlanningEntity.NullComparatorFactory.class.isAssignableFrom(difficultyWeightFactoryClass)) {
            difficultyWeightFactoryClass = null;
        }
        if ((comparatorFactoryClass = entityAnnotation.comparatorFactoryClass()) != null && PlanningEntity.NullComparatorFactory.class.isAssignableFrom(comparatorFactoryClass)) {
            comparatorFactoryClass = null;
        }
        if (difficultyWeightFactoryClass != null && comparatorFactoryClass != null) {
            throw new IllegalStateException("The entityClass (%s) cannot have a %s (%s) and a %s (%s) at the same time.".formatted(this.getEntityClass(), "difficultyWeightFactoryClass", difficultyWeightFactoryClass.getName(), "comparatorFactoryClass", comparatorFactoryClass.getName()));
        }
        String selectedComparatorPropertyName = "comparatorClass";
        Class<? extends Comparator> selectedComparatorClass = comparatorClass;
        String selectedComparatorFactoryPropertyName = "comparatorFactoryClass";
        Class<? extends ComparatorFactory> selectedComparatorFactoryClass = comparatorFactoryClass;
        if (difficultyComparatorClass != null) {
            selectedComparatorPropertyName = "difficultyComparatorClass";
            selectedComparatorClass = difficultyComparatorClass;
        }
        if (difficultyWeightFactoryClass != null) {
            selectedComparatorFactoryPropertyName = "difficultyWeightFactoryClass";
            selectedComparatorFactoryClass = difficultyWeightFactoryClass;
        }
        if (selectedComparatorClass != null && selectedComparatorFactoryClass != null) {
            throw new IllegalStateException("The entityClass (%s) cannot have a %s (%s) and a %s (%s) at the same time.".formatted(this.entityClass, selectedComparatorPropertyName, selectedComparatorClass.getName(), selectedComparatorFactoryPropertyName, selectedComparatorFactoryClass.getName()));
        }
        if (selectedComparatorClass != null) {
            Comparator comparator = ConfigUtils.newInstance(this::toString, selectedComparatorPropertyName, selectedComparatorClass);
            this.descendingSorter = new ComparatorSelectionSorter<Solution_, Object>(comparator, SelectionSorterOrder.DESCENDING);
        } else if (selectedComparatorFactoryClass != null) {
            ComparatorFactory comparator = ConfigUtils.newInstance(this::toString, selectedComparatorFactoryPropertyName, selectedComparatorFactoryClass);
            this.descendingSorter = new ComparatorFactorySelectionSorter<Solution_, Object>(comparator, SelectionSorterOrder.DESCENDING);
        }
    }

    private void processValueRangeProviderAnnotation(DescriptorPolicy descriptorPolicy, Member member) {
        if (((AnnotatedElement)((Object)member)).isAnnotationPresent(ValueRangeProvider.class)) {
            MemberAccessor memberAccessor = descriptorPolicy.getMemberAccessorFactory().buildAndCacheMemberAccessor(member, MemberAccessorFactory.MemberAccessorType.FIELD_OR_READ_METHOD_WITH_OPTIONAL_PARAMETER, ValueRangeProvider.class, descriptorPolicy.getDomainAccessType());
            this.assertGetterParameterType(memberAccessor);
            descriptorPolicy.addFromEntityValueRangeProvider(memberAccessor);
        }
    }

    private void assertGetterParameterType(MemberAccessor memberAccessor) {
        if (memberAccessor.acceptsParameter() && !((Class)memberAccessor.getGetterMethodParameterType()).isAssignableFrom(this.getSolutionDescriptor().getSolutionClass())) {
            throw new IllegalStateException("The parameter type (%s) of the method (%s) must match the solution (%s).".formatted(memberAccessor.getGetterMethodParameterType().getTypeName(), memberAccessor.getName(), this.getSolutionDescriptor().getSolutionClass().getName()));
        }
    }

    private void processPlanningVariableAnnotation(MutableInt variableDescriptorCounter, DescriptorPolicy descriptorPolicy, Member member) {
        Class<? extends Annotation> variableAnnotationClass = ConfigUtils.extractAnnotationClass(member, VARIABLE_ANNOTATION_CLASSES);
        if (variableAnnotationClass != null) {
            Annotation annotation;
            if (member instanceof Field) {
                Field field = (Field)member;
                annotation = field.getAnnotation(variableAnnotationClass);
            } else if (member instanceof Method) {
                Method method = (Method)member;
                annotation = method.getAnnotation(variableAnnotationClass);
            } else {
                throw new IllegalStateException("Member must be a field or a method, but was (%s).".formatted(member.getClass().getSimpleName()));
            }
            if (annotation == null) {
                throw new IllegalStateException("Impossible state: cannot get annotation on a %s-annotated member (%s).".formatted(variableAnnotationClass, member));
            }
            MemberAccessor memberAccessor = descriptorPolicy.getMemberAccessorFactory().buildAndCacheMemberAccessor(member, MemberAccessorFactory.MemberAccessorType.FIELD_OR_GETTER_METHOD_WITH_SETTER, variableAnnotationClass, descriptorPolicy.getDomainAccessType());
            this.registerVariableAccessor(variableDescriptorCounter.intValue(), variableAnnotationClass, memberAccessor);
            variableDescriptorCounter.increment();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerVariableAccessor(int nextVariableDescriptorOrdinal, Class<? extends Annotation> variableAnnotationClass, MemberAccessor memberAccessor) {
        String memberName = memberAccessor.getName();
        if (this.declaredGenuineVariableDescriptorMap.containsKey(memberName) || this.declaredShadowVariableDescriptorMap.containsKey(memberName)) {
            void var5_7;
            VariableDescriptor variableDescriptor = this.declaredGenuineVariableDescriptorMap.get(memberName);
            if (variableDescriptor != null) throw new IllegalStateException("The entityClass (%s) has a @%s annotated member (%s), duplicated by member for variableDescriptor (%s).\nMaybe the annotation is defined on both the field and its getter.".formatted(this.entityClass, variableAnnotationClass.getSimpleName(), memberAccessor, var5_7));
            VariableDescriptor variableDescriptor2 = this.declaredShadowVariableDescriptorMap.get(memberName);
            throw new IllegalStateException("The entityClass (%s) has a @%s annotated member (%s), duplicated by member for variableDescriptor (%s).\nMaybe the annotation is defined on both the field and its getter.".formatted(this.entityClass, variableAnnotationClass.getSimpleName(), memberAccessor, var5_7));
        }
        if (variableAnnotationClass.equals(PlanningVariable.class)) {
            Class<?> clazz = memberAccessor.getType();
            if (clazz.isArray()) {
                throw new IllegalStateException("The entityClass (%s) has a @%s annotated member (%s) that is of an array type.".formatted(this.entityClass, PlanningVariable.class.getSimpleName(), memberAccessor));
            }
            BasicVariableDescriptor variableDescriptor = new BasicVariableDescriptor(nextVariableDescriptorOrdinal, this, memberAccessor);
            this.declaredGenuineVariableDescriptorMap.put(memberName, variableDescriptor);
            return;
        } else if (variableAnnotationClass.equals(PlanningListVariable.class)) {
            if (!List.class.isAssignableFrom(memberAccessor.getType())) throw new IllegalStateException("The entityClass (%s) has a @%s annotated member (%s) that has an unsupported type (%s).\nMaybe use %s.".formatted(this.entityClass, PlanningListVariable.class.getSimpleName(), memberAccessor, memberAccessor.getType(), List.class.getCanonicalName()));
            ListVariableDescriptor listVariableDescriptor = new ListVariableDescriptor(nextVariableDescriptorOrdinal, this, memberAccessor);
            this.declaredGenuineVariableDescriptorMap.put(memberName, listVariableDescriptor);
            return;
        } else if (variableAnnotationClass.equals(InverseRelationShadowVariable.class)) {
            InverseRelationShadowVariableDescriptor inverseRelationShadowVariableDescriptor = new InverseRelationShadowVariableDescriptor(nextVariableDescriptorOrdinal, this, memberAccessor);
            this.declaredShadowVariableDescriptorMap.put(memberName, inverseRelationShadowVariableDescriptor);
            return;
        } else if (variableAnnotationClass.equals(AnchorShadowVariable.class)) {
            AnchorShadowVariableDescriptor anchorShadowVariableDescriptor = new AnchorShadowVariableDescriptor(nextVariableDescriptorOrdinal, this, memberAccessor);
            this.declaredShadowVariableDescriptorMap.put(memberName, anchorShadowVariableDescriptor);
            return;
        } else if (variableAnnotationClass.equals(IndexShadowVariable.class)) {
            IndexShadowVariableDescriptor indexShadowVariableDescriptor = new IndexShadowVariableDescriptor(nextVariableDescriptorOrdinal, this, memberAccessor);
            this.declaredShadowVariableDescriptorMap.put(memberName, indexShadowVariableDescriptor);
            return;
        } else if (variableAnnotationClass.equals(PreviousElementShadowVariable.class)) {
            PreviousElementShadowVariableDescriptor previousElementShadowVariableDescriptor = new PreviousElementShadowVariableDescriptor(nextVariableDescriptorOrdinal, this, memberAccessor);
            this.declaredShadowVariableDescriptorMap.put(memberName, previousElementShadowVariableDescriptor);
            return;
        } else if (variableAnnotationClass.equals(NextElementShadowVariable.class)) {
            NextElementShadowVariableDescriptor nextElementShadowVariableDescriptor = new NextElementShadowVariableDescriptor(nextVariableDescriptorOrdinal, this, memberAccessor);
            this.declaredShadowVariableDescriptorMap.put(memberName, nextElementShadowVariableDescriptor);
            return;
        } else if (variableAnnotationClass.equals(ShadowVariable.class) || variableAnnotationClass.equals(ShadowVariable.List.class)) {
            void var5_17;
            ShadowVariable annotation = memberAccessor.getAnnotation(ShadowVariable.class);
            if (annotation != null && !annotation.supplierName().isEmpty()) {
                DeclarativeShadowVariableDescriptor declarativeShadowVariableDescriptor = new DeclarativeShadowVariableDescriptor(nextVariableDescriptorOrdinal, this, memberAccessor);
            } else {
                CustomShadowVariableDescriptor customShadowVariableDescriptor = new CustomShadowVariableDescriptor(nextVariableDescriptorOrdinal, this, memberAccessor);
            }
            this.declaredShadowVariableDescriptorMap.put(memberName, (ShadowVariableDescriptor<Solution_>)var5_17);
            return;
        } else if (variableAnnotationClass.equals(CascadingUpdateShadowVariable.class)) {
            CascadingUpdateShadowVariableDescriptor cascadingUpdateShadowVariableDescriptor = new CascadingUpdateShadowVariableDescriptor(nextVariableDescriptorOrdinal, this, memberAccessor);
            this.declaredShadowVariableDescriptorMap.put(memberName, cascadingUpdateShadowVariableDescriptor);
            if (this.declaredCascadingUpdateShadowVariableDecriptorMap.containsKey(cascadingUpdateShadowVariableDescriptor.getTargetMethodName())) {
                this.declaredCascadingUpdateShadowVariableDecriptorMap.get(cascadingUpdateShadowVariableDescriptor.getTargetMethodName()).addTargetVariable(this, memberAccessor);
                return;
            } else {
                this.declaredCascadingUpdateShadowVariableDecriptorMap.put(cascadingUpdateShadowVariableDescriptor.getTargetMethodName(), cascadingUpdateShadowVariableDescriptor);
            }
            return;
        } else if (variableAnnotationClass.equals(ShadowVariablesInconsistent.class)) {
            ShadowVariablesInconsistentVariableDescriptor shadowVariablesInconsistentVariableDescriptor = new ShadowVariablesInconsistentVariableDescriptor(nextVariableDescriptorOrdinal, this, memberAccessor);
            this.shadowVariablesInconsistentDescriptor = shadowVariablesInconsistentVariableDescriptor;
            this.declaredShadowVariableDescriptorMap.put(memberName, shadowVariablesInconsistentVariableDescriptor);
            return;
        } else if (variableAnnotationClass.equals(PiggybackShadowVariable.class)) {
            PiggybackShadowVariableDescriptor piggybackShadowVariableDescriptor = new PiggybackShadowVariableDescriptor(nextVariableDescriptorOrdinal, this, memberAccessor);
            this.declaredShadowVariableDescriptorMap.put(memberName, piggybackShadowVariableDescriptor);
            return;
        } else {
            if (!variableAnnotationClass.equals(CustomShadowVariable.class)) throw new IllegalStateException("The variableAnnotationClass (%s) is not implemented.".formatted(variableAnnotationClass));
            LegacyCustomShadowVariableDescriptor legacyCustomShadowVariableDescriptor = new LegacyCustomShadowVariableDescriptor(nextVariableDescriptorOrdinal, this, memberAccessor);
            this.declaredShadowVariableDescriptorMap.put(memberName, legacyCustomShadowVariableDescriptor);
        }
    }

    private void processPlanningPinAnnotation(DescriptorPolicy descriptorPolicy, Member member) {
        AnnotatedElement annotatedMember = (AnnotatedElement)((Object)member);
        if (annotatedMember.isAnnotationPresent(PlanningPin.class)) {
            MemberAccessor memberAccessor = descriptorPolicy.getMemberAccessorFactory().buildAndCacheMemberAccessor(member, MemberAccessorFactory.MemberAccessorType.FIELD_OR_READ_METHOD, PlanningPin.class, descriptorPolicy.getDomainAccessType());
            Class<?> type = memberAccessor.getType();
            if (!Boolean.TYPE.isAssignableFrom(type) && !Boolean.class.isAssignableFrom(type)) {
                throw new IllegalStateException("The entityClass (%s) has a %s annotated member (%s) that is not a boolean or Boolean.".formatted(this.entityClass, PlanningPin.class.getSimpleName(), member));
            }
            this.declaredPinEntityFilterList.add(new PinEntityFilter(memberAccessor));
        }
    }

    private void processPlanningPinIndexAnnotation(DescriptorPolicy descriptorPolicy, Member member) {
        AnnotatedElement annotatedMember = (AnnotatedElement)((Object)member);
        if (annotatedMember.isAnnotationPresent(PlanningPinToIndex.class)) {
            if (!this.hasAnyGenuineListVariables()) {
                throw new IllegalStateException("The entityClass (%s) has a %s annotated member (%s) but no %s annotated member.".formatted(this.entityClass, PlanningPinToIndex.class.getSimpleName(), member, PlanningListVariable.class.getSimpleName()));
            }
            MemberAccessor memberAccessor = descriptorPolicy.getMemberAccessorFactory().buildAndCacheMemberAccessor(member, MemberAccessorFactory.MemberAccessorType.FIELD_OR_READ_METHOD, PlanningPinToIndex.class, descriptorPolicy.getDomainAccessType());
            Class<?> type = memberAccessor.getType();
            if (!Integer.TYPE.isAssignableFrom(type)) {
                throw new IllegalStateException("The entityClass (%s) has a %s annotated member (%s) that is not a primitive int.".formatted(this.entityClass, PlanningPinToIndex.class.getSimpleName(), member));
            }
            this.declaredPlanningPinIndexMemberAccessorList.add(memberAccessor);
        }
    }

    private void processVariableAnnotations(DescriptorPolicy descriptorPolicy) {
        for (GenuineVariableDescriptor<Solution_> genuineVariableDescriptor : this.declaredGenuineVariableDescriptorMap.values()) {
            genuineVariableDescriptor.processAnnotations(descriptorPolicy);
        }
        for (ShadowVariableDescriptor shadowVariableDescriptor : this.declaredShadowVariableDescriptorMap.values()) {
            shadowVariableDescriptor.processAnnotations(descriptorPolicy);
        }
    }

    public void linkEntityDescriptors(DescriptorPolicy descriptorPolicy) {
        this.investigateParentsToLinkInherited(this.entityClass);
        this.createEffectiveVariableDescriptorMaps();
        this.createEffectiveMovableEntitySelectionFilter();
    }

    private void investigateParentsToLinkInherited(Class<?> investigateClass) {
        this.effectiveInheritedEntityDescriptorList = new ArrayList<EntityDescriptor<Solution_>>(4);
        if (investigateClass == null || investigateClass.isArray()) {
            return;
        }
        this.linkInherited(investigateClass.getSuperclass());
        for (Class<?> superInterface : investigateClass.getInterfaces()) {
            this.linkInherited(superInterface);
        }
    }

    private void linkInherited(Class<?> potentialEntityClass) {
        EntityDescriptor<Solution_> entityDescriptor = this.solutionDescriptor.getEntityDescriptorStrict(potentialEntityClass);
        if (entityDescriptor != null) {
            this.effectiveInheritedEntityDescriptorList.add(entityDescriptor);
        } else {
            this.investigateParentsToLinkInherited(potentialEntityClass);
        }
    }

    private void createEffectiveVariableDescriptorMaps() {
        this.effectiveGenuineVariableDescriptorMap = new LinkedHashMap<String, GenuineVariableDescriptor<Solution_>>(this.declaredGenuineVariableDescriptorMap.size());
        this.effectiveShadowVariableDescriptorMap = new LinkedHashMap<String, ShadowVariableDescriptor<Solution_>>(this.declaredShadowVariableDescriptorMap.size());
        for (EntityDescriptor<Solution_> inheritedEntityDescriptor : this.effectiveInheritedEntityDescriptorList) {
            this.effectiveGenuineVariableDescriptorMap.putAll(inheritedEntityDescriptor.effectiveGenuineVariableDescriptorMap);
            this.effectiveShadowVariableDescriptorMap.putAll(inheritedEntityDescriptor.effectiveShadowVariableDescriptorMap);
        }
        List<String> redefinedGenuineVariables = this.declaredGenuineVariableDescriptorMap.keySet().stream().filter(key -> this.effectiveGenuineVariableDescriptorMap.containsKey(key)).toList();
        if (!redefinedGenuineVariables.isEmpty()) {
            throw new IllegalStateException("The class (%s) redefines the genuine variables (%s), which is not permitted.\nMaybe remove the variables (%s) from the class (%s).".formatted(this.entityClass, redefinedGenuineVariables, String.join((CharSequence)", ", redefinedGenuineVariables), this.entityClass));
        }
        this.effectiveGenuineVariableDescriptorMap.putAll(this.declaredGenuineVariableDescriptorMap);
        List<String> redefinedShadowVariables = this.declaredShadowVariableDescriptorMap.keySet().stream().filter(key -> this.effectiveShadowVariableDescriptorMap.containsKey(key)).toList();
        if (!redefinedShadowVariables.isEmpty()) {
            throw new IllegalStateException("The class (%s) redefines the shadow variables (%s), which is not permitted.\nMaybe remove the variables (%s) from the class (%s).".formatted(this.entityClass, redefinedShadowVariables, redefinedShadowVariables, this.entityClass));
        }
        this.effectiveShadowVariableDescriptorMap.putAll(this.declaredShadowVariableDescriptorMap);
        this.effectiveVariableDescriptorMap = CollectionUtils.newLinkedHashMap(this.effectiveGenuineVariableDescriptorMap.size() + this.effectiveShadowVariableDescriptorMap.size());
        this.effectiveVariableDescriptorMap.putAll(this.effectiveGenuineVariableDescriptorMap);
        this.effectiveVariableDescriptorMap.putAll(this.effectiveShadowVariableDescriptorMap);
        this.effectiveGenuineVariableDescriptorList = new ArrayList<GenuineVariableDescriptor<Solution_>>(this.effectiveGenuineVariableDescriptorMap.values());
        this.effectiveGenuineListVariableDescriptorList = this.effectiveGenuineVariableDescriptorList.stream().filter(VariableDescriptor::isListVariable).map(l -> (ListVariableDescriptor)l).toList();
    }

    private void createEffectiveMovableEntitySelectionFilter() {
        if (this.declaredMovableEntityFilter != null && !this.hasAnyDeclaredGenuineVariableDescriptor()) {
            throw new IllegalStateException("The entityClass (%s) has a movableEntitySelectionFilterClass (%s), but it has no declared genuine variables, only shadow variables.".formatted(this.entityClass, this.declaredMovableEntityFilter.getClass()));
        }
        ArrayList<MovableFilter<Solution_>> movableFilterList = new ArrayList<MovableFilter<Solution_>>();
        for (EntityDescriptor<Solution_> inheritedEntityDescriptor : this.effectiveInheritedEntityDescriptorList) {
            if (!inheritedEntityDescriptor.hasEffectiveMovableEntityFilter()) continue;
            movableFilterList.add(inheritedEntityDescriptor.effectiveMovableEntityFilter);
        }
        if (this.declaredMovableEntityFilter != null) {
            movableFilterList.add(this.declaredMovableEntityFilter);
        }
        movableFilterList.addAll(this.declaredPinEntityFilterList);
        this.effectiveMovableEntityFilter = movableFilterList.isEmpty() ? null : (MovableFilter)movableFilterList.stream().reduce(MovableFilter::and).orElseThrow(() -> new IllegalStateException("Impossible state: no movable filters."));
    }

    private void createEffectivePlanningPinIndexReader() {
        if (!this.hasAnyGenuineListVariables()) {
            this.effectivePlanningPinToIndexReader = null;
            return;
        }
        ArrayList<MemberAccessor> planningPinIndexMemberAccessorList = new ArrayList<MemberAccessor>();
        for (EntityDescriptor<Solution_> inheritedEntityDescriptor : this.effectiveInheritedEntityDescriptorList) {
            if (inheritedEntityDescriptor.effectivePlanningPinToIndexReader == null) continue;
            planningPinIndexMemberAccessorList.addAll(inheritedEntityDescriptor.declaredPlanningPinIndexMemberAccessorList);
        }
        planningPinIndexMemberAccessorList.addAll(this.declaredPlanningPinIndexMemberAccessorList);
        switch (planningPinIndexMemberAccessorList.size()) {
            case 0: {
                this.effectivePlanningPinToIndexReader = null;
                break;
            }
            case 1: {
                MemberAccessor memberAccessor = (MemberAccessor)planningPinIndexMemberAccessorList.get(0);
                this.effectivePlanningPinToIndexReader = entity -> (Integer)memberAccessor.executeGetter(entity);
                break;
            }
            default: {
                throw new IllegalStateException("The entityClass (%s) has (%d) @%s-annotated members (%s), where it should only have one.".formatted(this.entityClass, planningPinIndexMemberAccessorList.size(), PlanningPinToIndex.class.getSimpleName(), planningPinIndexMemberAccessorList));
            }
        }
    }

    public void linkVariableDescriptors(DescriptorPolicy descriptorPolicy) {
        for (GenuineVariableDescriptor<Solution_> genuineVariableDescriptor : this.declaredGenuineVariableDescriptorMap.values()) {
            genuineVariableDescriptor.linkVariableDescriptors(descriptorPolicy);
        }
        for (ShadowVariableDescriptor shadowVariableDescriptor : this.declaredShadowVariableDescriptorMap.values()) {
            shadowVariableDescriptor.linkVariableDescriptors(descriptorPolicy);
        }
        for (Member member : ConfigUtils.getDeclaredMembers(this.entityClass)) {
            this.processPlanningPinIndexAnnotation(descriptorPolicy, member);
        }
        this.createEffectivePlanningPinIndexReader();
    }

    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public boolean matchesEntity(Object entity) {
        return this.entityClass.isAssignableFrom(entity.getClass());
    }

    public boolean hasPinningFilter() {
        return this.declaredMovableEntityFilter != null;
    }

    public boolean hasEffectiveMovableEntityFilter() {
        return this.effectiveMovableEntityFilter != null;
    }

    public boolean supportsPinning() {
        return this.hasEffectiveMovableEntityFilter() || this.effectivePlanningPinToIndexReader != null;
    }

    public BiPredicate<Solution_, Object> getEffectiveMovableEntityFilter() {
        return this.effectiveMovableEntityFilter;
    }

    public <A> UniEnumeratingFilter<Solution_, A> getEntityMovablePredicate() {
        return this.entityMovablePredicate;
    }

    public SelectionSorter<Solution_, Object> getDescendingSorter() {
        return this.descendingSorter;
    }

    public Collection<String> getGenuineVariableNameSet() {
        return this.effectiveGenuineVariableDescriptorMap.keySet();
    }

    public GenuineVariableDescriptor<Solution_> getGenuineVariableDescriptor(String variableName) {
        return this.effectiveGenuineVariableDescriptorMap.get(variableName);
    }

    public @Nullable ShadowVariablesInconsistentVariableDescriptor<Solution_> getShadowVariablesInconsistentDescriptor() {
        return this.shadowVariablesInconsistentDescriptor;
    }

    public boolean hasBothGenuineListAndBasicVariables() {
        if (!this.isGenuine()) {
            return false;
        }
        return this.hasAnyGenuineListVariables() && this.hasAnyGenuineBasicVariables();
    }

    public boolean hasAnyGenuineBasicVariables() {
        if (!this.isGenuine()) {
            return false;
        }
        return this.getDeclaredGenuineVariableDescriptors().stream().anyMatch(descriptor -> !descriptor.isListVariable());
    }

    public boolean hasAnyGenuineChainedVariables() {
        if (!this.isGenuine()) {
            return false;
        }
        return this.getDeclaredGenuineVariableDescriptors().stream().filter(descriptor -> descriptor instanceof BasicVariableDescriptor).map(descriptor -> (BasicVariableDescriptor)descriptor).anyMatch(BasicVariableDescriptor::isChained);
    }

    public boolean hasAnyGenuineListVariables() {
        if (!this.isGenuine()) {
            return false;
        }
        return this.getGenuineListVariableDescriptor() != null;
    }

    public boolean isGenuine() {
        return !this.effectiveGenuineVariableDescriptorMap.isEmpty();
    }

    public ListVariableDescriptor<Solution_> getGenuineListVariableDescriptor() {
        if (this.effectiveGenuineListVariableDescriptorList.isEmpty()) {
            return null;
        }
        return this.effectiveGenuineListVariableDescriptorList.get(0);
    }

    public List<GenuineVariableDescriptor<Solution_>> getGenuineVariableDescriptorList() {
        return this.effectiveGenuineVariableDescriptorList;
    }

    public List<GenuineVariableDescriptor<Solution_>> getGenuineBasicVariableDescriptorList() {
        return this.effectiveGenuineVariableDescriptorList.stream().filter(descriptor -> !descriptor.isListVariable()).toList();
    }

    public long getGenuineVariableCount() {
        return this.effectiveGenuineVariableDescriptorList.size();
    }

    public int getValueRangeCount() {
        int count = 0;
        for (GenuineVariableDescriptor<Solution_> genuineVariableDescriptor : this.effectiveGenuineVariableDescriptorList) {
            ValueRangeDescriptor<Solution_> valueRangeDescriptor = genuineVariableDescriptor.getValueRangeDescriptor();
            if (valueRangeDescriptor instanceof CompositeValueRangeDescriptor) {
                CompositeValueRangeDescriptor compositeValueRangeDescriptor = (CompositeValueRangeDescriptor)valueRangeDescriptor;
                count += compositeValueRangeDescriptor.getValueRangeCount();
            }
            ++count;
        }
        return count;
    }

    public Collection<ShadowVariableDescriptor<Solution_>> getShadowVariableDescriptors() {
        return this.effectiveShadowVariableDescriptorMap.values();
    }

    public ShadowVariableDescriptor<Solution_> getShadowVariableDescriptor(String variableName) {
        return this.effectiveShadowVariableDescriptorMap.get(variableName);
    }

    public Map<String, VariableDescriptor<Solution_>> getVariableDescriptorMap() {
        return this.effectiveVariableDescriptorMap;
    }

    public boolean hasVariableDescriptor(String variableName) {
        return this.effectiveVariableDescriptorMap.containsKey(variableName);
    }

    public @Nullable VariableDescriptor<Solution_> getVariableDescriptor(String variableName) {
        return this.effectiveVariableDescriptorMap.get(variableName);
    }

    public @NonNull VariableDescriptor<Solution_> getVariableDescriptorOrFail(String variableName) {
        VariableDescriptor<Solution_> variableDescriptor = this.effectiveVariableDescriptorMap.get(variableName);
        if (variableDescriptor == null) {
            throw new IllegalArgumentException("Entity class %s does not hava a \"%s\" genuine or shadow variable.\nMaybe you meant one of %s?".formatted(this.entityClass.getSimpleName(), variableName, this.effectiveVariableDescriptorMap.keySet()));
        }
        return variableDescriptor;
    }

    public boolean hasAnyDeclaredGenuineVariableDescriptor() {
        return !this.declaredGenuineVariableDescriptorMap.isEmpty();
    }

    public Collection<GenuineVariableDescriptor<Solution_>> getDeclaredGenuineVariableDescriptors() {
        return this.declaredGenuineVariableDescriptorMap.values();
    }

    public Collection<ShadowVariableDescriptor<Solution_>> getDeclaredShadowVariableDescriptors() {
        return this.declaredShadowVariableDescriptorMap.values();
    }

    public Collection<CascadingUpdateShadowVariableDescriptor<Solution_>> getDeclaredCascadingUpdateShadowVariableDescriptors() {
        return this.declaredCascadingUpdateShadowVariableDecriptorMap.values();
    }

    public Collection<VariableDescriptor<Solution_>> getDeclaredVariableDescriptors() {
        ArrayList<VariableDescriptor<Solution_>> variableDescriptors = new ArrayList<VariableDescriptor<Solution_>>(this.declaredGenuineVariableDescriptorMap.size() + this.declaredShadowVariableDescriptorMap.size());
        variableDescriptors.addAll(this.declaredGenuineVariableDescriptorMap.values());
        variableDescriptors.addAll(this.declaredShadowVariableDescriptorMap.values());
        return variableDescriptors;
    }

    public String buildInvalidVariableNameExceptionMessage(String variableName) {
        if (!ReflectionHelper.hasGetterMethod(this.entityClass, variableName) && !ReflectionHelper.hasField(this.entityClass, variableName)) {
            Object exceptionMessage = "The variableName (%s) for entityClass (%s) does not exist as a getter or field on that class.\nCheck the spelling of the variableName (%s).".formatted(variableName, this.entityClass, variableName);
            if (variableName.length() >= 2 && !Character.isUpperCase(variableName.charAt(0)) && Character.isUpperCase(variableName.charAt(1))) {
                String correctedVariableName = variableName.substring(0, 1).toUpperCase() + variableName.substring(1);
                exceptionMessage = (String)exceptionMessage + "Maybe it needs to be correctedVariableName (%s) instead, if it's a getter, because the JavaBeans spec states that the first letter should be a upper case if the second is upper case.".formatted(correctedVariableName);
            }
            return exceptionMessage;
        }
        return "The variableName (%s) for entityClass (%s) exists as a getter or field on that class, but isn't in the planning variables (%s).\n%sMaybe your planning entity's getter or field lacks a @%s annotation or a shadow variable annotation.".formatted(variableName, this.entityClass, this.effectiveVariableDescriptorMap.keySet(), Character.isUpperCase(variableName.charAt(0)) ? "Maybe the variableName (%s) should start with a lowercase.%n".formatted(variableName) : "", PlanningVariable.class.getSimpleName());
    }

    public static List<Class<?>> extractInheritedClasses(Class<?> entityClass) {
        ArrayList entityClassList = new ArrayList();
        EntityDescriptor.readParentEntityClassAnnotations(entityClass, entityClassList);
        return entityClassList.stream().filter(c -> !c.equals(entityClass)).toList();
    }

    private static void readParentEntityClassAnnotations(Class<?> entityClass, List<Class<?>> declaredEntityList) {
        if (entityClass == null || entityClass.equals(Object.class)) {
            return;
        }
        if (EntityDescriptorValidator.isEntityClass(entityClass)) {
            declaredEntityList.add(entityClass);
        }
        EntityDescriptor.readParentEntityClassAnnotations(entityClass.getSuperclass(), declaredEntityList);
        for (Class<?> clazz : entityClass.getInterfaces()) {
            EntityDescriptor.readParentEntityClassAnnotations(clazz, declaredEntityList);
        }
    }

    public List<Object> extractEntities(Solution_ solution) {
        ArrayList<Object> entityList = new ArrayList<Object>();
        this.visitAllEntities(solution, entityList::add);
        return entityList;
    }

    public void visitAllEntities(Solution_ solution, Consumer<Object> visitor) {
        this.solutionDescriptor.visitEntitiesByEntityClass(solution, this.entityClass, entity -> {
            visitor.accept(entity);
            return false;
        });
    }

    public PlanningPinToIndexReader getEffectivePlanningPinToIndexReader() {
        return this.effectivePlanningPinToIndexReader;
    }

    public int countUninitializedVariables(Object entity) {
        int count = 0;
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : this.effectiveGenuineVariableDescriptorList) {
            if (variableDescriptor.isInitialized(entity)) continue;
            ++count;
        }
        return count;
    }

    public boolean isInitialized(Object entity) {
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : this.effectiveGenuineVariableDescriptorList) {
            if (variableDescriptor.isInitialized(entity)) continue;
            return false;
        }
        return true;
    }

    public boolean hasNoNullVariables(Object entity) {
        return switch (this.effectiveGenuineVariableDescriptorList.size()) {
            case 0 -> true;
            case 1 -> {
                if (this.effectiveGenuineVariableDescriptorList.get(0).getValue(entity) != null) {
                    yield true;
                }
                yield false;
            }
            default -> {
                for (GenuineVariableDescriptor<Solution_> variableDescriptor : this.effectiveGenuineVariableDescriptorList) {
                    if (variableDescriptor.getValue(entity) != null) continue;
                    yield false;
                }
                yield true;
            }
        };
    }

    public int countReinitializableVariables(Object entity) {
        int count = 0;
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : this.effectiveGenuineVariableDescriptorList) {
            if (!variableDescriptor.isReinitializable(entity)) continue;
            ++count;
        }
        return count;
    }

    public boolean isMovable(Solution_ workingSolution, Object entity) {
        return this.isGenuine() && (this.effectiveMovableEntityFilter == null || this.effectiveMovableEntityFilter.test(workingSolution, entity));
    }

    public PlanningEntityMetaModel<Solution_, ?> getEntityMetaModel() {
        if (this.entityMetaModel != null) {
            return this.entityMetaModel;
        }
        this.entityMetaModel = this.solutionDescriptor.getMetaModel().entity(this.entityClass);
        return this.entityMetaModel;
    }

    public String toString() {
        return "%s(%s)".formatted(this.getClass().getSimpleName(), this.entityClass.getName());
    }
}

